/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.XlinkMockData;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class XlinkWfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected XlinkMockData createTestData() {
        return new XlinkMockData();
    }

    @Test
    public void testGetCapabilities() {
        Document doc = this.getAsDOM("wfs?request=GetCapabilities");
        LOGGER.info("WFS GetCapabilities response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testDescribeFeatureType() {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&typename=gsml:MappedFeature");
        LOGGER.info("WFS DescribeFeatureType response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testGetFeature() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS GetFeature response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
    }

    @Test
    public void testGetFeatureContent() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&featureID=mf1,mf2,mf3,mf4");
        LOGGER.info("WFS testGetFeatureContent response:\n" + this.prettyString(doc));
        this.assertXpathCount(4, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("GUNTHORPE FORMATION", "//gsml:MappedFeature[@gml:id='mf1']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='mf1']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//gsml:MappedFeature[@gml:id='mf1']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:x-test:GeologicUnit:gu.25699", "//gsml:MappedFeature[@gml:id='mf1']/gsml:specification/@xlink:href", doc);
        this.assertXpathEvaluatesTo("MERCIA MUDSTONE GROUP", "//gsml:MappedFeature[@gml:id='mf2']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='mf2']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.3 52.6 -1.3 52.6 -1.2 52.5 -1.2 52.5 -1.3", "//gsml:MappedFeature[@gml:id='mf2']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:x-test:GeologicUnit:gu.25678", "//gsml:MappedFeature[@gml:id='mf2']/gsml:specification/@xlink:href", doc);
        this.assertXpathEvaluatesTo("CLIFTON FORMATION", "//gsml:MappedFeature[@gml:id='mf3']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='mf3']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//gsml:MappedFeature[@gml:id='mf3']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:x-test:GeologicUnit:gu.25678", "//gsml:MappedFeature[@gml:id='mf3']/gsml:specification/@xlink:href", doc);
        this.assertXpathEvaluatesTo("MURRADUC BASALT", "//gsml:MappedFeature[@gml:id='mf4']/gml:name", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//gsml:MappedFeature[@gml:id='mf4']/gsml:shape/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.3 52.6 -1.3 52.6 -1.2 52.5 -1.2 52.5 -1.3", "//gsml:MappedFeature[@gml:id='mf4']/gsml:shape//gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:x-test:GeologicUnit:gu.25682", "//gsml:MappedFeature[@gml:id='mf4']/gsml:specification/@xlink:href", doc);
    }
}

