/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.XlinkGeometryMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class XlinkGeometryTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected AbstractAppSchemaMockData createTestData() {
        return new XlinkGeometryMockData();
    }

    @Test
    public void testGeometry() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typeName=ex:MyTestFeature");
        LOGGER.info("WFS GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("xlinkvalue1", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:geometryref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue2", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:curveref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue3", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:pointref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue4", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:linestringref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue5", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:surfaceref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue6", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:polygonref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue7", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:multicurveref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue8", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:multipointref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue9", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:multilinestringref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue10", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:multisurfaceref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("xlinkvalue11", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='1']/ex:multipolygonref/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom1", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:geometry/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom2", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:curve/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom3", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:point/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom4", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:linestring/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom5", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:surface/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom6", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:polygon/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom7", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multicurve/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom8", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multipoint/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom9", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multilinestring/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom10", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multisurface/@xlink:href", doc);
        this.assertXpathEvaluatesTo("#geom11", "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multipolygon/@xlink:href", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:geometry/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:curve/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:point/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:linestring/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:surface/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:polygon/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multicurve/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multipoint/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multilinestring/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multisurface/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multipolygon/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:geometryref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:curveref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:pointref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:linestringref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:surfaceref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:polygonref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multicurveref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multipointref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multilinestringref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multisurfaceref/*", doc);
        this.assertXpathCount(0, "wfs:FeatureCollection/gml:featureMember/ex:MyTestFeature[@gml:id='2']/ex:multipolygonref/*", doc);
    }
}

