/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.config.ServiceInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.GeoPackageUtil;
import org.geoserver.test.WmsSupportMockData;
import org.geoserver.wms.WMSInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class WmsGetFeatureInfoTest
extends AbstractAppSchemaTestSupport {
    @Before
    public void setupAdvancedProjectionHandling() {
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.setFeaturesReprojectionDisabled(false);
        this.getGeoServer().save((ServiceInfo)wms);
    }

    @Override
    protected WmsSupportMockData createTestData() {
        WmsSupportMockData mockData = new WmsSupportMockData();
        mockData.addStyle("Default", "styles/Default.sld");
        mockData.addStyle("positionalaccuracy21", "styles/positionalaccuracy21.sld");
        return mockData;
    }

    @Test
    public void testGetCapabilities() {
        Document doc = this.getAsDOM("wms?request=GetCapabilities");
        LOGGER.info("WMS =GetCapabilities response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathCount(1, "//wms:Layer/wms:Name[.='gsml:MappedFeature']", doc);
        this.assertXpathCount(1, "//wms:GetFeatureInfo/wms:Format[.='application/vnd.ogc.gml/3.1.1']", doc);
    }

    @Test
    public void testGetFeatureInfoText() throws Exception {
        String str = this.getAsString("wms?request=GetFeatureInfo&SRS=EPSG:4326&BBOX=-1.3,52,0,52.5&LAYERS=gsml:MappedFeature&QUERY_LAYERS=gsml:MappedFeature&X=0&Y=0&width=100&height=100");
        LOGGER.info("WMS =GetFeatureInfo Text response:\n" + str);
        Assert.assertTrue((boolean)str.contains("FeatureImpl:MappedFeature<MappedFeatureType id=mf2>"));
    }

    @Test
    public void testGetFeatureInfoGML() throws Exception {
        String request = "wms?request=GetFeatureInfo&SRS=EPSG:4326&BBOX=-1.3,52,0,52.5&LAYERS=gsml:MappedFeature&QUERY_LAYERS=gsml:MappedFeature&X=0&Y=0&width=100&height=100&INFO_FORMAT=application/vnd.ogc.gml/3.1.1";
        Document doc = this.getAsDOM(request);
        LOGGER.info("WMS =GetFeatureInfo GML response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf2", "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature/@gml:id", doc);
        this.assertXpathEvaluatesTo("gu.25678", "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.validateGet(request);
    }

    @Test
    public void testGetFeatureInfoGMLReprojection() throws Exception {
        if (GeoPackageUtil.isGeopkgTest()) {
            return;
        }
        String request = "wms?request=GetFeatureInfo&SRS=EPSG:3857&BBOX=-144715.338031256,6800125.45439731,0,6891041.72389159&LAYERS=gsml:MappedFeature&QUERY_LAYERS=gsml:MappedFeature&X=0&Y=0&width=100&height=100&INFO_FORMAT=application/vnd.ogc.gml/3.1.1";
        Document doc = this.getAsDOM(request);
        LOGGER.info("WMS =GetFeatureInfo GML response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf2", "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature/@gml:id", doc);
        this.assertXpathEvaluatesTo("gu.25678", "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathMatches(".*3857", "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature[@gml:id='mf2']/gsml:shape/gml:Polygon/@srsName", doc);
        this.validateGet(request);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.setFeaturesReprojectionDisabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
        doc = this.getAsDOM(request);
        this.assertXpathMatches(".*4326", "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature[@gml:id='mf2']/gsml:shape/gml:Polygon/@srsName", doc);
    }

    @Test
    public void testGetFeatureInfoGML21() throws Exception {
        String request = "wms?request=GetFeatureInfo&styles=positionalaccuracy21&SRS=EPSG:4326&BBOX=-1.3,53,0,53.5&LAYERS=gsml:MappedFeature&QUERY_LAYERS=gsml:MappedFeature&X=0&Y=0&width=100&height=100&INFO_FORMAT=application/vnd.ogc.gml/3.1.1";
        Document doc = this.getAsDOM(request);
        LOGGER.info("WMS =GetFeatureInfo GML response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf4", "/wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature/@gml:id", doc);
        this.validateGet(request);
    }

    @Test
    public void testGetFeatureInfoHTML() throws Exception {
        Document doc = this.getAsDOM("wms?request=GetFeatureInfo&SRS=EPSG:4326&BBOX=-1.3,52,0,52.5&LAYERS=gsml:MappedFeature&QUERY_LAYERS=gsml:MappedFeature&X=0&Y=0&width=100&height=100&INFO_FORMAT=text/html");
        LOGGER.info("WMS =GetFeatureInfo HTML response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "/html/body/table/tr/td[.='mf2']", doc);
        this.assertXpathCount(1, "/html/body/table/tr/td/table[caption/.='CGI_TermValuePropertyType']/tr/td/table[caption/.='CGI_TermValueType']", doc);
        this.assertXpathCount(1, "/html/body/table/tr/td/table[caption/.='GeologicFeaturePropertyType']/tr/td/table[caption/.='GeologicUnitType']/tr/th[.='gml:description']", doc);
    }
}

