/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StringConstantIdMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class StringConstantIdWfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected StringConstantIdMockData createTestData() {
        return new StringConstantIdMockData();
    }

    @Test
    public void testGetFeature() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathEvaluatesTo("string constant", "(//gsml:MappedFeature)[1]/@gml:id", doc);
        this.assertXpathCount(1, "//gsml:GeologicUnit/@gml:id", doc);
        if (System.getProperty("testDatabase") != null) {
            this.assertXpathEvaluatesTo("GEOLOGICUNIT.4", "//gsml:GeologicUnit/@gml:id", doc);
        } else {
            this.assertXpathEvaluatesTo("4", "//gsml:GeologicUnit/@gml:id", doc);
        }
    }
}

