/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.SpecimenMockData;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class SpecimenWfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected SpecimenMockData createTestData() {
        return new SpecimenMockData();
    }

    @Test
    public void testGetFeature() {
        String path = "wfs?version=1.1.0&request=GetFeature&typename=spec:SF_Specimen&outputFormat=gml32";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        Assert.assertEquals((Object)"http://www.opengis.net/wfs/2.0", (Object)doc.getDocumentElement().getNamespaceURI());
        Assert.assertEquals((Object)"FeatureCollection", (Object)doc.getDocumentElement().getLocalName());
    }

    @Test
    public void testGetFeatureValid() {
        String path = "wfs?version=1.1.0&request=GetFeature&typename=spec:SF_Specimen&outputformat=gml32";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        this.validateGet(path);
    }

    @Test
    public void testGetFeatureContent() {
        String path = "wfs?version=1.1.0&request=GetFeature&typename=spec:SF_Specimen&outputformat=gml32";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberReturned", doc);
        this.assertXpathCount(2, "//spec:SF_Specimen", doc);
        this.assertXpathEvaluatesTo("First", "//spec:SF_Specimen[@gml:id='specimen.1']/gml:name", doc);
        this.assertXpathEvaluatesTo("2.7", "//spec:SF_Specimen[@gml:id='specimen.1']/spec:size", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/def/uom/UCUM/g", "//spec:SF_Specimen[@gml:id='specimen.1']/spec:size/@uom", doc);
        this.assertXpathEvaluatesTo("Second", "//spec:SF_Specimen[@gml:id='specimen.2']/gml:name", doc);
        this.assertXpathEvaluatesTo("0.31", "//spec:SF_Specimen[@gml:id='specimen.2']/spec:size", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/def/uom/UCUM/g", "//spec:SF_Specimen[@gml:id='specimen.2']/spec:size/@uom", doc);
    }
}

