/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.IOException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.SimpleAttributeFeatureChainMockData;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.appschema.jdbc.NestedFilterToSQL;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.filter.ComplexFilterSplitter;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.util.NullProgressListener;
import org.geotools.jdbc.JDBCDataStore;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.w3c.dom.Document;

public class SimpleAttributeFeatureChainWfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected SimpleAttributeFeatureChainMockData createTestData() {
        return new SimpleAttributeFeatureChainMockData();
    }

    @Test
    public void testGetFeature() {
        String path = "wfs?request=GetFeature&version=1.1.0&typeName=gsml:MappedFeature";
        Document doc = this.getAsDOM(path);
        LOGGER.info("MappedFeature with name feature chained Response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("4", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature", doc);
        this.checkMf1(doc);
        this.assertXpathEvaluatesTo("133.8855 -23.6701", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4326", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsName", doc);
        this.checkMf2(doc);
        this.assertXpathEvaluatesTo("167.9388 -29.0434", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4326", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsName", doc);
        this.checkMf3(doc);
        this.assertXpathEvaluatesTo("-1.2 53.5 -1.2 53.6 -1.1 53.6 -1.1 53.5 -1.2 53.5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4283", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsName", doc);
        this.checkMf4(doc);
        this.assertXpathEvaluatesTo("-1.3 53.5 -1.3 53.6 -1.2 53.6 -1.2 52.5 -1.3 53.5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gsml:shape/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gsml:shape/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4283", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gsml:shape/gml:Polygon/@srsName", doc);
    }

    @Test
    public void testReprojecting() {
        String path = "wfs?request=GetFeature&version=1.1.0&typeName=gsml:MappedFeature&srsName=EPSG:4326";
        Document doc = this.getAsDOM(path);
        LOGGER.info("Reprojected MappedFeature with name feature chained Response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("4", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(4, "//gsml:MappedFeature", doc);
        this.checkMf1(doc);
        this.assertXpathEvaluatesTo("133.8855 -23.6701", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4326", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsName", doc);
        this.checkMf2(doc);
        this.assertXpathEvaluatesTo("167.9388 -29.0434", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4326", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsName", doc);
        this.checkMf3(doc);
        this.assertXpathEvaluatesTo("-1.2 53.50000004 -1.2 53.60000004 -1.1 53.60000004 -1.1 53.50000004 -1.2 53.50000004", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4326", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsName", doc);
        this.checkMf4(doc);
        this.assertXpathEvaluatesTo("-1.3 53.50000004 -1.3 53.60000004 -1.2 53.60000004 -1.2 52.50000004 -1.3 53.50000004", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gsml:shape/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gsml:shape/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4326", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gsml:shape/gml:Polygon/@srsName", doc);
    }

    @Test
    public void testAttributeFilter() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name</ogc:PropertyName>                <ogc:Literal>nametwo 4</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.checkMf3(doc);
        this.assertXpathEvaluatesTo("-1.2 53.5 -1.2 53.6 -1.1 53.6 -1.1 53.5 -1.2 53.5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4283", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsName", doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name</ogc:PropertyName>                <ogc:Literal>nametwo 3</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.checkMf2(doc);
        this.assertXpathEvaluatesTo("167.9388 -29.0434", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4326", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsName", doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name</ogc:PropertyName>                <ogc:Literal>nametwo 2</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.checkMf2(doc);
        this.assertXpathEvaluatesTo("167.9388 -29.0434", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4326", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/@srsName", doc);
    }

    @Test
    public void testClientPropertiesFilter() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name/@codeSpace</ogc:PropertyName>                <ogc:Literal>some:uri:mf3</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.checkMf3(doc);
        this.assertXpathEvaluatesTo("-1.2 53.5 -1.2 53.6 -1.1 53.6 -1.1 53.5 -1.2 53.5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4283", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsName", doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name/@codeSpace</ogc:PropertyName>                <ogc:Literal>some uri 4</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.checkMf3(doc);
        this.assertXpathEvaluatesTo("-1.2 53.5 -1.2 53.6 -1.1 53.6 -1.1 53.5 -1.2 53.5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4283", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsName", doc);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd urn:cgi:xmlns:CGI:GeoSciML:2.0 http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd\">    <wfs:Query typeName=\"gsml:MappedFeature\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:PropertyName>gml:name/@xlink:href</ogc:PropertyName>                <ogc:Literal>some:uri:4</ogc:Literal>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS filter GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.checkMf3(doc);
        this.assertXpathEvaluatesTo("-1.2 53.5 -1.2 53.6 -1.1 53.6 -1.1 53.5 -1.2 53.5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsDimension", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4283", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Polygon/@srsName", doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedFilterEncoding() throws IOException, FilterToSQLException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName("gsml", "MappedFeature");
        FeatureSource fs = ftInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        AppSchemaDataAccess da = (AppSchemaDataAccess)fs.getDataStore();
        FeatureTypeMapping rootMapping = da.getMappingByNameOrElement(ftInfo.getQualifiedName());
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(rootMapping));
        JDBCDataStore store = (JDBCDataStore)rootMapping.getSource().getDataStore();
        NestedFilterToSQL nestedFilterToSQL = this.createNestedFilterEncoder(rootMapping);
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware();
        ff.setNamepaceContext(rootMapping.getNamespaces());
        PropertyIsEqualTo propertyIsEqualTo = ff.equals((Expression)ff.property("gml:name[2]"), (Expression)ff.literal((Object)"nameone 4"));
        ComplexFilterSplitter splitter = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitter.visit(propertyIsEqualTo, null);
        Filter preFilter = splitter.getFilterPre();
        Filter postFilter = splitter.getFilterPost();
        Assert.assertEquals((Object)propertyIsEqualTo, (Object)preFilter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
        Filter unrolled = AppSchemaDataAccess.unrollFilter((Filter)propertyIsEqualTo, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        String encodedFilter = nestedFilterToSQL.encodeToString(unrolled);
        Assert.assertTrue((boolean)encodedFilter.contains("EXISTS"));
        this.assertContainsFeatures(fs.getFeatures((Filter)propertyIsEqualTo), "mf3");
        PropertyIsEqualTo ordinaryFilter = ff.equals((Expression)ff.property("gml:name[1]"), (Expression)ff.literal((Object)"GUNTHORPE FORMATION"));
        ComplexFilterSplitter splitter2 = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitter2.visit(ordinaryFilter, null);
        preFilter = splitter2.getFilterPre();
        postFilter = splitter2.getFilterPost();
        Assert.assertEquals((Object)ordinaryFilter, (Object)preFilter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
        unrolled = AppSchemaDataAccess.unrollFilter((Filter)ordinaryFilter, (FeatureTypeMapping)rootMapping);
        Assert.assertFalse((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        String ordinaryEncoded = nestedFilterToSQL.encodeToString(unrolled);
        Assert.assertFalse((boolean)ordinaryEncoded.contains("EXISTS"));
        this.assertContainsFeatures(fs.getFeatures((Filter)ordinaryFilter), "mf1");
        PropertyIsEqualTo multipleFilter = ff.equals((Expression)ff.property("gml:name"), (Expression)ff.literal((Object)"GUNTHORPE FORMATION"));
        ComplexFilterSplitter splitter3 = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitter3.visit(multipleFilter, null);
        preFilter = splitter3.getFilterPre();
        postFilter = splitter3.getFilterPost();
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)preFilter);
        Assert.assertEquals((Object)multipleFilter, (Object)postFilter);
        unrolled = AppSchemaDataAccess.unrollFilter((Filter)multipleFilter, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        this.assertContainsFeatures(fs.getFeatures((Filter)multipleFilter), "mf1");
        PropertyIsEqualTo regularFilter = ff.equals((Expression)ff.property("gml:name[1]"), (Expression)ff.literal((Object)"GUNTHORPE FORMATION"));
        PropertyIsEqualTo nestedFilter = ff.equals((Expression)ff.property("gml:name[2]"), (Expression)ff.literal((Object)"nameone 4"));
        Or combined = ff.or((Filter)regularFilter, (Filter)nestedFilter);
        ComplexFilterSplitter splitterCombined = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitterCombined.visit(combined, null);
        preFilter = splitterCombined.getFilterPre();
        postFilter = splitterCombined.getFilterPost();
        Assert.assertEquals((Object)combined, (Object)preFilter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
        unrolled = AppSchemaDataAccess.unrollFilter((Filter)combined, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        String encodedCombined = nestedFilterToSQL.encodeToString(unrolled);
        Assert.assertTrue((boolean)encodedCombined.matches("^\\(.*GUNTHORPE FORMATION.*OR.*EXISTS.*\\)$"));
        this.assertContainsFeatures(fs.getFeatures((Filter)combined), "mf1", "mf3");
        AppSchemaDataAccessRegistry.getAppSchemaProperties().setProperty("app-schema.orUnionReplace", "false");
        try {
            this.assertContainsFeatures(fs.getFeatures((Filter)combined), "mf1", "mf3");
        }
        finally {
            AppSchemaDataAccessRegistry.getAppSchemaProperties().setProperty("app-schema.orUnionReplace", "true");
        }
        PropertyIsNotEqualTo notEquals = ff.notEqual((Expression)ff.property("gml:name[2]"), (Expression)ff.property("gml:name[3]"));
        ComplexFilterSplitter splitterNotEquals = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitterNotEquals.visit(notEquals, null);
        preFilter = splitterNotEquals.getFilterPre();
        postFilter = splitterNotEquals.getFilterPost();
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)preFilter);
        Assert.assertEquals((Object)notEquals, (Object)postFilter);
        unrolled = AppSchemaDataAccess.unrollFilter((Filter)notEquals, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        this.assertContainsFeatures(fs.getFeatures((Filter)notEquals), "mf1", "mf2", "mf3", "mf4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnionImprovement() throws IOException, FilterToSQLException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName("gsml", "MappedFeature");
        FeatureSource fs = ftInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        AppSchemaDataAccess da = (AppSchemaDataAccess)fs.getDataStore();
        FeatureTypeMapping rootMapping = da.getMappingByNameOrElement(ftInfo.getQualifiedName());
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(rootMapping));
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware();
        ff.setNamepaceContext(rootMapping.getNamespaces());
        PropertyIsEqualTo regularFilter = ff.equals((Expression)ff.property("gml:name[2]"), (Expression)ff.literal((Object)"nameone 2"));
        PropertyIsEqualTo nestedFilter = ff.equals((Expression)ff.property("gml:name[2]"), (Expression)ff.literal((Object)"nameone 4"));
        Or combined = ff.or((Filter)regularFilter, (Filter)nestedFilter);
        this.assertContainsFeatures(fs.getFeatures((Filter)combined), "mf2", "mf3");
        AppSchemaDataAccessRegistry.getAppSchemaProperties().setProperty("app-schema.orUnionReplace", "false");
        try {
            FeatureSource fs1 = ftInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
            this.assertContainsFeatures(fs1.getFeatures((Filter)combined), "mf2", "mf3");
        }
        finally {
            AppSchemaDataAccessRegistry.getAppSchemaProperties().setProperty("app-schema.orUnionReplace", "true");
        }
    }

    private void checkMf1(Document doc) {
        this.assertXpathCount(4, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name", doc);
        this.assertXpathEvaluatesTo("GUNTHORPE FORMATION", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name[1]", doc);
        this.assertXpathEvaluatesTo("nameone 1", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name[2]", doc);
        this.assertXpathEvaluatesTo("some uri 1", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name[2]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("nametwo 1", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name[3]", doc);
        this.assertXpathEvaluatesTo("some:uri:mf1", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name[3]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("some:uri:1", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gml:name[4]/@xlink:href", doc);
    }

    private void checkMf2(Document doc) {
        this.assertXpathCount(7, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name", doc);
        this.assertXpathEvaluatesTo("MERCIA MUDSTONE GROUP", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[1]", doc);
        this.assertXpathEvaluatesTo("nameone 2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[2]", doc);
        this.assertXpathEvaluatesTo("some uri 2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[2]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("nameone 3", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[3]", doc);
        this.assertXpathEvaluatesTo("some uri 3", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[3]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("nametwo 2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[4]", doc);
        this.assertXpathEvaluatesTo("some:uri:mf2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[4]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("nametwo 3", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[5]", doc);
        this.assertXpathEvaluatesTo("some:uri:mf2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[5]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("some:uri:2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[6]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("some:uri:3", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gml:name[7]/@xlink:href", doc);
    }

    private void checkMf3(Document doc) {
        this.assertXpathCount(4, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gml:name", doc);
        this.assertXpathEvaluatesTo("CLIFTON FORMATION", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gml:name[1]", doc);
        this.assertXpathEvaluatesTo("nameone 4", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gml:name[2]", doc);
        this.assertXpathEvaluatesTo("some uri 4", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gml:name[2]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("nametwo 4", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gml:name[3]", doc);
        this.assertXpathEvaluatesTo("some:uri:mf3", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gml:name[3]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("some:uri:4", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gml:name[4]/@xlink:href", doc);
    }

    private void checkMf4(Document doc) {
        this.assertXpathCount(4, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gml:name", doc);
        this.assertXpathEvaluatesTo("MURRADUC BASALT", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gml:name[1]", doc);
        this.assertXpathEvaluatesTo("nameone 5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gml:name[2]", doc);
        this.assertXpathEvaluatesTo("some uri 5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gml:name[2]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("nametwo 5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gml:name[3]", doc);
        this.assertXpathEvaluatesTo("some:uri:mf4", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gml:name[3]/@codeSpace", doc);
        this.assertXpathEvaluatesTo("some:uri:5", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gml:name[4]/@xlink:href", doc);
    }
}

