/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class SameNestedAttributeTest
extends AbstractAppSchemaTestSupport {
    private static final String STATIONS_PREFIX = "st";
    private static final String STATIONS_URI = "http://www.stations.org/1.0";

    @Override
    protected StationsMockData createTestData() {
        return new MockData();
    }

    @Test
    public void testWfsGetFeatureWithAdvancedNestedFilter() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("wfs", this.readResource("/test-data/stations/sameNameAttribute/requests/wfs_get_feature_1.xml"));
        String content = response.getContentAsString();
        LOGGER.fine(content);
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"gml:id=\"st.1\""));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"gml:id=\"st.2\""));
        MatcherAssert.assertThat((Object)StringUtils.countMatches((CharSequence)content, (CharSequence)"<wfs:member>"), (Matcher)CoreMatchers.is((Object)2));
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace(SameNestedAttributeTest.STATIONS_PREFIX, SameNestedAttributeTest.STATIONS_URI);
            this.addAppSchemaFeatureType(SameNestedAttributeTest.STATIONS_PREFIX, null, "Station", "/test-data/stations/sameNameAttribute/stations.xml", Collections.emptyMap(), "/test-data/stations/sameNameAttribute/stations.xsd", "/test-data/stations/sameNameAttribute/institutes.xml", "/test-data/stations/sameNameAttribute/persons.xml", "/test-data/stations/sameNameAttribute/stations.properties", "/test-data/stations/sameNameAttribute/institutes.properties", "/test-data/stations/sameNameAttribute/persons.properties");
        }
    }
}

