/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.GeoPackageUtil;
import org.geoserver.test.SRSReprojectionMockData;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.ProgressListener;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.appschema.jdbc.NestedFilterToSQL;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.filter.ComplexFilterSplitter;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.util.NullProgressListener;
import org.geotools.geometry.jts.JTS;
import org.geotools.gml.producer.CoordinateFormatter;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.w3c.dom.Document;

public class SRSReprojectionTest
extends AbstractAppSchemaTestSupport {
    final String EPSG_4326 = "urn:x-ogc:def:crs:EPSG:4326";
    final String EPSG_4283 = "EPSG:4283";

    @Override
    protected SRSReprojectionMockData createTestData() {
        return new SRSReprojectionMockData();
    }

    @Test
    public void testNonFeatureTypeProxy() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&srsName=EPSG:4326");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("value01", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:observationMethod[1]/gsml:CGI_TermValue/gsml:value[@codeSpace='codespace01']", doc);
        this.assertXpathEvaluatesTo("value02", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:observationMethod[2]/gsml:CGI_TermValue/gsml:value[@codeSpace='codespace02']", doc);
        this.assertXpathEvaluatesTo("value03", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:observationMethod[1]/gsml:CGI_TermValue/gsml:value[@codeSpace='codespace03']", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:observationMethod[1]/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathCount(0, "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gsml:observationMethod[2]/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4326", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo("133.8855 -23.6701", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/gml:pos", doc);
        doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&srsName=urn:x-ogc:def:crs:EPSG:4326");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("-23.6701 133.8855", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/gml:pos", doc);
    }

    @Test
    public void testChainingReprojection() throws NoSuchAuthorityCodeException, FactoryException, MismatchedDimensionException, TransformException {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainer response:\n" + this.prettyString(doc));
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4283");
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"urn:x-ogc:def:crs:EPSG:4326");
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        GeometryFactory factory = new GeometryFactory();
        Polygon srcPolygon = factory.createPolygon(factory.createLinearRing(factory.getCoordinateSequenceFactory().create(new Coordinate[]{new Coordinate(-1.2, 52.5), new Coordinate(-1.2, 52.6), new Coordinate(-1.1, 52.6), new Coordinate(-1.1, 52.5), new Coordinate(-1.2, 52.5)})), null);
        Polygon targetPolygon = (Polygon)JTS.transform((Geometry)srcPolygon, (MathTransform)transform);
        StringBuffer polygonBuffer = new StringBuffer();
        CoordinateFormatter formatter = new CoordinateFormatter(8);
        for (Coordinate coord : targetPolygon.getCoordinates()) {
            formatter.format(coord.x, polygonBuffer).append(" ");
            formatter.format(coord.y, polygonBuffer).append(" ");
        }
        String targetPolygonCoords = polygonBuffer.toString().trim();
        Point targetPoint = (Point)JTS.transform((Geometry)factory.createPoint(new Coordinate(42.58, 31.29)), (MathTransform)transform);
        String targetPointCoord = formatter.format(targetPoint.getCoordinate().x) + " " + formatter.format(targetPoint.getCoordinate().y);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//ex:geomContainer[@gml:id='1']/ex:nestedFeature[2]/ex:nestedGeom[@gml:id='secondNested.2']/ex:nestedFeature/ex:nestedGeom[@gml:id='thirdNested.1']/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "//ex:geomContainer[@gml:id='2']/ex:nestedFeature[2]/ex:nestedGeom[@gml:id='secondNested.1']/ex:nestedFeature/ex:nestedGeom[@gml:id='thirdNested.2']/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("31.29 42.58", "//ex:geomContainer[@gml:id='2']/ex:nestedFeature[2]/ex:nestedGeom[@gml:id='secondNested.1']/ex:nestedFeature/ex:nestedGeom[@gml:id='thirdNested.2']/ex:geom/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("NAME", "//ex:geomContainer[@gml:id='2']/ex:nestedFeature[2]/ex:nestedGeom[@gml:id='secondNested.1']/ex:name", doc);
        this.assertXpathCount(0, "//ex:geomContainer[@gml:id='2']/ex:nestedFeature[2]/ex:nestedGeom[@gml:id='secondNested.1']/ex:geom", doc);
        doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&srsName=urn:x-ogc:def:crs:EPSG:4326");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainer response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo(targetPolygonCoords, "//ex:geomContainer[@gml:id='1']/ex:nestedFeature[2]/ex:nestedGeom[@gml:id='secondNested.2']/ex:nestedFeature/ex:nestedGeom[@gml:id='thirdNested.1']/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//ex:geomContainer[@gml:id='2']/ex:nestedFeature[2]/ex:nestedGeom[@gml:id='secondNested.1']/ex:nestedFeature/ex:nestedGeom[@gml:id='thirdNested.2']/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo(targetPointCoord, "//ex:geomContainer[@gml:id='2']/ex:nestedFeature[2]/ex:nestedGeom[@gml:id='secondNested.1']/ex:nestedFeature/ex:nestedGeom[@gml:id='thirdNested.2']/ex:geom/gml:Point/gml:pos", doc);
    }

    @Test
    public void testChainingXlink() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainer response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("http://example.com/UrnResolver/?uri=1", "//ex:geomContainer[@gml:id='1']/ex:nestedFeature[3]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("http://example.com/UrnResolver/?uri=2", "//ex:geomContainer[@gml:id='2']/ex:nestedFeature[3]/@xlink:href", doc);
    }

    @Test
    public void testNestedSpatialFilterEncoding() throws IOException, FilterToSQLException {
        if (GeoPackageUtil.isGeopkgTest()) {
            return;
        }
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName("ex", "geomContainer");
        FeatureSource fs = ftInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        AppSchemaDataAccess da = (AppSchemaDataAccess)fs.getDataStore();
        FeatureTypeMapping rootMapping = da.getMappingByNameOrElement(ftInfo.getQualifiedName());
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(rootMapping));
        JDBCDataStore store = (JDBCDataStore)rootMapping.getSource().getDataStore();
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware();
        ff.setNamepaceContext(rootMapping.getNamespaces());
        GeometryFactory factory = new GeometryFactory();
        Polygon srcPolygon = factory.createPolygon(factory.createLinearRing(factory.getCoordinateSequenceFactory().create(new Coordinate[]{new Coordinate(-1.2, 52.5), new Coordinate(-1.2, 52.6), new Coordinate(-1.1, 52.6), new Coordinate(-1.1, 52.5), new Coordinate(-1.2, 52.5)})), null);
        Envelope bounds = srcPolygon.getEnvelopeInternal();
        BBOX intersects = ff.bbox("ex:nestedFeature[2]/ex:nestedGeom/ex:nestedFeature/ex:nestedGeom/ex:geom", bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY(), "EPSG:4283");
        ComplexFilterSplitter splitter = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitter.visit(intersects, null);
        Filter preFilter = splitter.getFilterPre();
        Filter postFilter = splitter.getFilterPost();
        Assert.assertEquals((Object)intersects, (Object)preFilter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
        Filter unrolled = AppSchemaDataAccess.unrollFilter((Filter)intersects, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        NestedFilterToSQL nestedFilterToSQL = this.createNestedFilterEncoder(rootMapping);
        String encodedFilter = nestedFilterToSQL.encodeToString(unrolled);
        Assert.assertTrue((boolean)encodedFilter.contains("EXISTS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReprojection() throws Exception {
        FeatureTypeInfo typeInfo;
        Catalog catalog = this.getCatalog();
        try {
            typeInfo = catalog.getFeatureTypeByName("gsml:MappedFeature");
            typeInfo.setSRS("EPSG:3857");
            typeInfo.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
            catalog.save((ResourceInfo)typeInfo);
            Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature");
            this.print(doc);
            this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:3857", "//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsName", doc);
        }
        finally {
            typeInfo = catalog.getFeatureTypeByName("gsml:MappedFeature");
            typeInfo.setSRS("EPSG:4326");
            typeInfo.setProjectionPolicy(ProjectionPolicy.NONE);
            catalog.save((ResourceInfo)typeInfo);
        }
    }
}

