/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.GeoPackageUtil;
import org.geoserver.test.StationsMockData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public final class ReprojectionAxisFlipTest
extends AbstractAppSchemaTestSupport {
    private static final String STATIONS_PREFIX = "st";
    private static final String STATIONS_URI = "http://www.stations.org/1.0";

    @Override
    protected StationsMockData createTestData() {
        return new MockData();
    }

    @Before
    public void beforeTest() {
        this.setDeclaredCrs("st:Station", "EPSG:4052");
    }

    @Test
    public void testWfsGetFeatureWithBbox() throws Exception {
        if (GeoPackageUtil.isGeopkgTest()) {
            return;
        }
        this.genericWfsGetFeatureWithBboxTest(() -> this.getAsServletResponse("wfs?service=WFS&version=2.0&request=GetFeature&typeName=st:Station&maxFeatures=1&outputFormat=gml32&srsName=urn:ogc:def:crs:EPSG::4052&bbox=3,-3,6,0"));
    }

    @Test
    public void testWfsGetFeatureWithBboxPost() throws Exception {
        if (GeoPackageUtil.isGeopkgTest()) {
            return;
        }
        this.genericWfsGetFeatureWithBboxTest(() -> this.postAsServletResponse("wfs", this.readResource("/test-data/stations/noDefaultGeometry/requests/wfs20_get_feature_1.xml")));
    }

    private void genericWfsGetFeatureWithBboxTest(Request request) throws Exception {
        MockHttpServletResponse response = request.execute();
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"gml:id=\"st.1\""));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"gml:id=\"st.2\""));
        MatcherAssert.assertThat((Object)StringUtils.countMatches((CharSequence)content, (CharSequence)"<wfs:member>"), (Matcher)CoreMatchers.is((Object)2));
        this.setDeclaredCrs("st:Station", null);
        response = request.execute();
        content = response.getContentAsString();
        MatcherAssert.assertThat((Object)StringUtils.countMatches((CharSequence)content, (CharSequence)"Exception"), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)StringUtils.countMatches((CharSequence)content, (CharSequence)"<wfs:member>"), (Matcher)CoreMatchers.is((Object)0));
    }

    private void setDeclaredCrs(String featureTypeName, String srs) {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(featureTypeName);
        MatcherAssert.assertThat((Object)info, (Matcher)CoreMatchers.notNullValue());
        info.setSRS(srs);
        this.getCatalog().save((ResourceInfo)info);
    }

    @FunctionalInterface
    private static interface Request {
        public MockHttpServletResponse execute() throws Exception;
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace(ReprojectionAxisFlipTest.STATIONS_PREFIX, ReprojectionAxisFlipTest.STATIONS_URI);
            this.addAppSchemaFeatureType(ReprojectionAxisFlipTest.STATIONS_PREFIX, null, "Station", "/test-data/stations/noDefaultGeometry/stations.xml", Collections.emptyMap(), "/test-data/stations/noDefaultGeometry/stations.xsd", "/test-data/stations/noDefaultGeometry/stations.properties");
        }
    }
}

