/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.BBox3DMockData;
import org.geoserver.test.GeoPackageUtil;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class Reprojection3DTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected BBox3DMockData createTestData() {
        return new BBox3DMockData();
    }

    @Test
    public void testReprojection() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=gsml:MappedFeature&srsName=EPSG:4891");
        LOGGER.info("WFS GetFeature&typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        if (!GeoPackageUtil.isGeopkgTest()) {
            Assert.assertEquals((Object)"3", (Object)this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsDimension", doc));
            Assert.assertEquals((Object)"http://www.opengis.net/gml/srs/epsg.xml#4891", (Object)this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsName", doc));
            String point = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/gml:pos", doc);
            Assert.assertTrue((Double.parseDouble(point.split(" ")[2]) - 104.08756174333 < 1.0E-5 ? 1 : 0) != 0);
            point = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/gml:pos", doc);
            Assert.assertTrue((Double.parseDouble(point.split(" ")[2]) - -0.8719314243599996 < 1.0E-5 ? 1 : 0) != 0);
            point = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Point/gml:pos", doc);
            Assert.assertTrue((Double.parseDouble(point.split(" ")[2]) - -2.97579399217 < 1.0E-5 ? 1 : 0) != 0);
            point = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gsml:shape/gml:Point/gml:pos", doc);
            Assert.assertTrue((Double.parseDouble(point.split(" ")[2]) - 80.17838118318 < 1.0E-5 ? 1 : 0) != 0);
            point = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf5']/gsml:shape/gml:LineString/gml:posList", doc);
            String[] coords = point.split(" ");
            Assert.assertTrue((Double.parseDouble(coords[2]) - 104.08756174333 < 1.0E-5 ? 1 : 0) != 0);
            Assert.assertTrue((Double.parseDouble(coords[5]) - -0.8719314243599996 < 1.0E-5 ? 1 : 0) != 0);
            Assert.assertTrue((Double.parseDouble(coords[8]) - -2.97579399217 < 1.0E-5 ? 1 : 0) != 0);
            Assert.assertTrue((Double.parseDouble(coords[11]) - 80.17838118318 < 1.0E-5 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((Object)"2", (Object)this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsDimension", doc));
            Assert.assertEquals((Object)"http://www.opengis.net/gml/srs/epsg.xml#4891", (Object)this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/@srsName", doc));
            String point = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf1']/gsml:shape/gml:Point/gml:pos", doc);
            Assert.assertTrue((Double.parseDouble(point.split(" ")[1]) - 104.08756174333 < 1.0E-5 ? 1 : 0) != 0);
            point = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf2']/gsml:shape/gml:Point/gml:pos", doc);
            Assert.assertTrue((Double.parseDouble(point.split(" ")[1]) - -0.8719314243599996 < 1.0E-5 ? 1 : 0) != 0);
            point = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf3']/gsml:shape/gml:Point/gml:pos", doc);
            Assert.assertTrue((Double.parseDouble(point.split(" ")[1]) - -2.97579399217 < 1.0E-5 ? 1 : 0) != 0);
            point = this.evaluate("//gsml:MappedFeature[@gml:id='gsml.mappedfeature.mf4']/gsml:shape/gml:Point/gml:pos", doc);
            Assert.assertTrue((Double.parseDouble(point.split(" ")[1]) - 80.17838118318 < 1.0E-5 ? 1 : 0) != 0);
        }
    }
}

