/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.config.ServiceInfo;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.PropertyEncodingOrderMockData;
import org.geoserver.wfs.WFSInfo;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PropertyEncodingOrderTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected AbstractAppSchemaMockData createTestData() {
        return new PropertyEncodingOrderMockData();
    }

    @Test
    public void testPropertyEncodingOrder_Borehole() throws Exception {
        String path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:Borehole";
        Document doc = this.getAsDOM(path);
        LOGGER.info("WFS GetFeature&gsml:Borehole:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("1", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(1, "//gsml:Borehole[@gml:id='BOREHOLE.WTB5']", doc);
        Node borehole = doc.getElementsByTagName("gsml:Borehole").item(0);
        Assert.assertEquals((Object)"gsml:Borehole", (Object)borehole.getNodeName());
        Assert.assertEquals((Object)"BOREHOLE.WTB5", (Object)borehole.getAttributes().getNamedItem("gml:id").getNodeValue());
        Node name = borehole.getFirstChild();
        Assert.assertEquals((Object)"gml:name", (Object)name.getNodeName());
        Assert.assertEquals((Object)"WTB5 TEST", (Object)name.getFirstChild().getNodeValue());
        Node sampledFeature = name.getNextSibling();
        Assert.assertEquals((Object)"sa:sampledFeature", (Object)sampledFeature.getNodeName());
        Node shape = sampledFeature.getNextSibling();
        Assert.assertEquals((Object)"sa:shape", (Object)shape.getNodeName());
        Node posList = shape.getFirstChild().getFirstChild();
        Assert.assertEquals((Object)"gml:posList", (Object)posList.getNodeName());
        Assert.assertEquals((Object)"-28.4139 121.142 -28.4139 121.142", (Object)posList.getFirstChild().getNodeValue());
        Node collarLocation = shape.getNextSibling();
        Assert.assertEquals((Object)"gsml:collarLocation", (Object)collarLocation.getNodeName());
        Node boreholeCollar = collarLocation.getFirstChild();
        Assert.assertEquals((Object)"gsml:BoreholeCollar", (Object)boreholeCollar.getNodeName());
        Assert.assertEquals((Object)"BOREHOLE.COLLAR.WTB5", (Object)boreholeCollar.getAttributes().getNamedItem("gml:id").getNodeValue());
        Assert.assertEquals((Object)"-28.4139 121.142", (Object)boreholeCollar.getFirstChild().getFirstChild().getFirstChild().getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"1.0", (Object)boreholeCollar.getFirstChild().getNextSibling().getFirstChild().getNodeValue());
        Node indexData = collarLocation.getNextSibling();
        Assert.assertEquals((Object)"gsml:indexData", (Object)indexData.getNodeName());
        Node boreholeDetails = indexData.getFirstChild();
        Assert.assertEquals((Object)"gsml:BoreholeDetails", (Object)boreholeDetails.getNodeName());
        Node operator = boreholeDetails.getFirstChild();
        Assert.assertEquals((Object)"GSWA", (Object)operator.getAttributes().getNamedItem("xlink:title").getNodeValue());
        Node dateOfDrilling = operator.getNextSibling();
        Assert.assertEquals((Object)"2004-09-17", (Object)dateOfDrilling.getFirstChild().getNodeValue());
        Node drillingMethod = dateOfDrilling.getNextSibling();
        Assert.assertEquals((Object)"diamond core", (Object)drillingMethod.getFirstChild().getNodeValue());
        Node startPoint = drillingMethod.getNextSibling();
        Assert.assertEquals((Object)"natural ground surface", (Object)startPoint.getFirstChild().getNodeValue());
        Node inclinationType = startPoint.getNextSibling();
        Assert.assertEquals((Object)"vertical", (Object)inclinationType.getFirstChild().getNodeValue());
        Node coreInterval = inclinationType.getNextSibling();
        Assert.assertEquals((Object)"106.0", (Object)coreInterval.getFirstChild().getFirstChild().getFirstChild().getNodeValue());
        Assert.assertEquals((Object)"249.0", (Object)coreInterval.getFirstChild().getFirstChild().getNextSibling().getFirstChild().getNodeValue());
        Node coreCustodian = coreInterval.getNextSibling();
        Assert.assertEquals((Object)"CSIRONR", (Object)coreCustodian.getAttributes().getNamedItem("xlink:title").getNodeValue());
        this.validateGet(path);
    }

    @Test
    public void testPropertyEncodingOrder_PlanarOrientation() throws Exception {
        String path = "wfs?request=GetFeature&version=1.1.0&typename=er:MineralOccurrence";
        Document doc = this.getAsDOM(path);
        LOGGER.info("WFS GetFeature&er:MineralOccurrence:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//er:MineralOccurrence[@gml:id='er.mineraloccurrence.S0032895']", doc);
        Node feature = doc.getElementsByTagName("er:MineralOccurrence").item(0);
        Assert.assertEquals((Object)"er:MineralOccurrence", (Object)feature.getNodeName());
        this.assertXpathEvaluatesTo("er.mineraloccurrence.S0032895", "//er:MineralOccurrence/@gml:id", doc);
        Node name = feature.getFirstChild();
        Assert.assertEquals((Object)"gml:name", (Object)name.getNodeName());
        this.assertXpathEvaluatesTo("Robinson Range - Deposit D", "//er:MineralOccurrence[@gml:id='er.mineraloccurrence.S0032895']/gml:name", doc);
        Node planarOrientation = name.getNextSibling();
        Assert.assertEquals((Object)"er:planarOrientation", (Object)planarOrientation.getNodeName());
        Node gsml_planarOrientation = planarOrientation.getFirstChild();
        Assert.assertEquals((Object)"gsml:CGI_PlanarOrientation", (Object)gsml_planarOrientation.getNodeName());
        Node convention = gsml_planarOrientation.getFirstChild();
        Assert.assertEquals((Object)"gsml:convention", (Object)convention.getNodeName());
        this.assertXpathEvaluatesTo("strike dip right hand rule", "//er:MineralOccurrence[@gml:id='er.mineraloccurrence.S0032895']/er:planarOrientation/gsml:CGI_PlanarOrientation/gsml:convention", doc);
        Node azimuth = convention.getNextSibling();
        Assert.assertEquals((Object)"gsml:azimuth", (Object)azimuth.getNodeName());
        this.assertXpathEvaluatesTo("50.0", "//er:MineralOccurrence[@gml:id='er.mineraloccurrence.S0032895']/er:planarOrientation/gsml:CGI_PlanarOrientation/gsml:azimuth/gsml:CGI_NumericValue/gsml:principalValue", doc);
        Node dip = azimuth.getNextSibling();
        Assert.assertEquals((Object)"gsml:dip", (Object)dip.getNodeName());
        this.assertXpathEvaluatesTo("60-80", "//er:MineralOccurrence[@gml:id='er.mineraloccurrence.S0032895']/er:planarOrientation/gsml:CGI_PlanarOrientation/gsml:dip/gsml:CGI_TermValue/gsml:value", doc);
        Node polarity = dip.getNextSibling();
        Assert.assertEquals((Object)"gsml:polarity", (Object)polarity.getNodeName());
        this.assertXpathEvaluatesTo("not applicable", "//er:MineralOccurrence[@gml:id='er.mineraloccurrence.S0032895']/er:planarOrientation/gsml:CGI_PlanarOrientation/gsml:polarity", doc);
    }

    @Test
    public void testPropertyEncodingOrder_GeologicUnit() throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.setEncodeFeatureMember(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        String path = "wfs?request=GetFeature&version=1.1.0&typename=gsml:GeologicUnit&featureid=gu.25699";
        Document doc = this.getAsDOM(path);
        LOGGER.info("WFS GetFeature&typename=gsml:GeologicUnit&featureid=gu.25699:\n" + this.prettyString(doc));
        Assert.assertEquals((long)1L, (long)doc.getElementsByTagName("gml:featureMember").getLength());
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25699']", doc);
        Node feature = doc.getElementsByTagName("gsml:GeologicUnit").item(0);
        Assert.assertEquals((Object)"gsml:GeologicUnit", (Object)feature.getNodeName());
        Node description = feature.getFirstChild();
        Assert.assertEquals((Object)"gml:description", (Object)description.getNodeName());
        this.assertXpathEvaluatesTo("Olivine basalt, tuff, microgabbro, minor sedimentary rocks", "//gsml:GeologicUnit[@gml:id='gu.25699']/gml:description", doc);
        Node name1 = description.getNextSibling();
        Assert.assertEquals((Object)"gml:name", (Object)name1.getNodeName());
        this.assertXpathEvaluatesTo("Yaugher Volcanic Group", "//gsml:GeologicUnit[@gml:id='gu.25699']/gml:name[1]", doc);
        Node name2 = name1.getNextSibling();
        Assert.assertEquals((Object)"gml:name", (Object)name2.getNodeName());
        this.assertXpathEvaluatesTo("-Py", "//gsml:GeologicUnit[@gml:id='gu.25699']/gml:name[2]", doc);
        Node observationMethod = name2.getNextSibling();
        Assert.assertEquals((Object)"gsml:observationMethod", (Object)observationMethod.getNodeName());
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("http://urn.opengis.net", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:observationMethod/gsml:CGI_TermValue/gsml:value/@codeSpace", doc);
        Node purpose = observationMethod.getNextSibling();
        Assert.assertEquals((Object)"gsml:purpose", (Object)purpose.getNodeName());
        this.assertXpathEvaluatesTo("instance", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:purpose", doc);
        Node occurrence = purpose.getNextSibling();
        Assert.assertEquals((Object)"gsml:occurrence", (Object)occurrence.getNodeName());
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:occurrence[@xlink:href='urn:cgi:feature:MappedFeature:mf1']", doc);
        Node geologicUnitType = occurrence.getNextSibling();
        Assert.assertEquals((Object)"gsml:geologicUnitType", (Object)geologicUnitType.getNodeName());
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:geologicUnitType/@xlink:href", doc);
        Node exposureColor = geologicUnitType.getNextSibling();
        Assert.assertEquals((Object)"gsml:exposureColor", (Object)exposureColor.getNodeName());
        this.assertXpathEvaluatesTo("Blue", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:exposureColor/gsml:CGI_TermValue/gsml:value", doc);
        Node outcropCharacter = exposureColor.getNextSibling();
        Assert.assertEquals((Object)"gsml:outcropCharacter", (Object)outcropCharacter.getNodeName());
        this.assertXpathEvaluatesTo("x", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:outcropCharacter/gsml:CGI_TermValue/gsml:value", doc);
        Node composition = outcropCharacter.getNextSibling();
        Assert.assertEquals((Object)"gsml:composition", (Object)composition.getNodeName());
        Node compositionPart = doc.getElementsByTagName("gsml:CompositionPart").item(0);
        Assert.assertEquals((Object)"gsml:CompositionPart", (Object)compositionPart.getNodeName());
        Node role = compositionPart.getFirstChild();
        Assert.assertEquals((Object)"gsml:role", (Object)role.getNodeName());
        this.assertXpathEvaluatesTo("fictitious component", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:composition/gsml:CompositionPart/gsml:role", doc);
        Node lithology = role.getNextSibling();
        Assert.assertEquals((Object)"gsml:lithology", (Object)lithology.getNodeName());
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::missing", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:composition/gsml:CompositionPart/gsml:lithology/gsml:ControlledConcept/gsml:vocabulary/@xlink:href", doc);
        Node proportion = lithology.getNextSibling();
        Assert.assertEquals((Object)"gsml:proportion", (Object)proportion.getNodeName());
        this.assertXpathEvaluatesTo("nonexistent", "//gsml:GeologicUnit[@gml:id='gu.25699']/gsml:composition/gsml:CompositionPart/gsml:proportion/gsml:CGI_TermValue/gsml:value", doc);
        this.validateGet(path);
    }
}

