/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Stream;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.JDBCFeatureStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public final class NormalizedMultiValuesTest
extends AbstractAppSchemaTestSupport {
    private XpathEngine WFS11_XPATH_ENGINE;
    private XpathEngine WFS20_XPATH_ENGINE;

    @Before
    public void beforeTest() {
        this.WFS11_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "ows", "http://www.opengis.net/ows", "wfs", "http://www.opengis.net/wfs", "gml", "http://www.opengis.net/gml");
        this.WFS20_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "ows", "http://www.opengis.net/ows/1.1", "wfs", "http://www.opengis.net/wfs/2.0", "gml", "http://www.opengis.net/gml/3.2");
    }

    @Override
    protected StationsMockData createTestData() {
        return new MockData();
    }

    @Test
    public void testGetAllNormalizedMultiValuesWfs11() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs?request=GetFeature&version=1.1.0&typename=st_gml31:Station_gml31";
        Document document = this.getAsDOM(request);
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 3, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31");
        this.checkStation1Gml31(document);
        this.checkStation2Gml31(document);
        this.checkStation3Gml31(document);
    }

    @Test
    public void testGetAllNormalizedMultiValuesWfsJson11() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs?request=GetFeature&version=1.1.0&typename=st_gml31:Station_gml31&outputFormat=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONArray features = json.getJSONArray("features");
        Assert.assertEquals((long)3L, (long)features.size());
        JSONObject station = this.getStationById(features, "st.1");
        Assert.assertNotNull((Object)station);
        this.checkStationJson1(station);
        station = this.getStationById(features, "st.2");
        Assert.assertNotNull((Object)station);
        this.checkStationJson2(station);
        station = this.getStationById(features, "st.3");
        Assert.assertNotNull((Object)station);
        this.checkStationJson3(station);
    }

    private void checkStationJson1(JSONObject station) {
        JSONArray tags = station.getJSONObject("properties").getJSONArray("tag");
        Assert.assertEquals((long)3L, (long)tags.size());
        this.assertTagsArrayHasTagContent(tags, "st_1_tag_a", 1);
        this.assertTagsArrayHasTagContent(tags, "st_1_tag_b", 2);
        this.assertTagsArrayHasTagContent(tags, "europe", 3);
    }

    private void checkStationJson2(JSONObject station) {
        JSONArray tags = station.getJSONObject("properties").getJSONArray("tag");
        Assert.assertEquals((long)3L, (long)tags.size());
        this.assertTagsArrayHasTagContent(tags, "st_2_tag_a", 4);
        this.assertTagsArrayHasTagContent(tags, "st_2_tag_b", 5);
        this.assertTagsArrayHasTagContent(tags, "europe", 6);
    }

    private void checkStationJson3(JSONObject station) {
        Assert.assertFalse((boolean)station.has("tag"));
    }

    private void assertTagsArrayHasTagContent(JSONArray tags, String value, int code) {
        Assert.assertTrue((String)("Tag value=" + value + ", code=" + code + " not found"), (boolean)this.toJsonObjectStream(tags).anyMatch(tag -> this.isTagContent((JSONObject)tag, value, code)));
    }

    private Stream<JSONObject> toJsonObjectStream(JSONArray array) {
        return array.stream().filter(obj -> obj instanceof JSONObject).map(obj -> (JSONObject)obj);
    }

    private boolean isTagContent(JSONObject tag, String value, int code) {
        try {
            String valueJson = tag.getString("value");
            int codeJson = tag.getInt("@code");
            return Objects.equals(value, valueJson) && Objects.equals(code, codeJson);
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    private JSONObject getStationById(JSONArray features, String id) {
        for (Object obj : features) {
            JSONObject station;
            if (!(obj instanceof JSONObject) || !Objects.equals((station = (JSONObject)obj).getString("id"), id)) continue;
            return station;
        }
        return null;
    }

    @Test
    public void testGetAllNormalizedMultiValuesWfs20() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32";
        Document document = this.getAsDOM(request);
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 3, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
        this.checkStation1Gml32(document);
        this.checkStation2Gml32(document);
        this.checkStation3Gml32(document);
    }

    @Test
    public void testGetAllNormalizedMultiValuesWfsJson20() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32&outputFormat=application/json";
        JSONObject json = (JSONObject)this.getAsJSON(request);
        JSONArray features = json.getJSONArray("features");
        Assert.assertEquals((long)3L, (long)features.size());
        JSONObject station = this.getStationById(features, "st.1");
        Assert.assertNotNull((Object)station);
        this.checkStationJson1(station);
        station = this.getStationById(features, "st.2");
        Assert.assertNotNull((Object)station);
        this.checkStationJson2(station);
        station = this.getStationById(features, "st.3");
        Assert.assertNotNull((Object)station);
        this.checkStationJson3(station);
    }

    @Test
    public void testGetAllNormalizedMultiValuesWfsJsonFormat20() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32&outputFormat=application/json";
        MockHttpServletResponse response = this.getAsServletResponse(request);
        String content = response.getContentAsString();
        this.validateJsonOutput(content);
    }

    private void validateJsonOutput(String jsonString) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        try {
            objectMapper.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Json format is not valid", e);
        }
    }

    @Test
    public void testGetFilteredNormalizedMultiValuesWfs11() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs";
        Document document = this.postAsDOM(request, this.readResource("/test-data/stations/multiValues/requests/station_tag_filter_wfs11_1.xml"));
        this.checkStation1Gml31(document);
    }

    @Test
    public void testGetFilteredNormalizedMultiValuesWfs20() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs";
        Document document = this.postAsDOM(request, this.readResource("/test-data/stations/multiValues/requests/station_tag_filter_wfs20_1.xml"));
        this.checkStation1Gml32(document);
    }

    @Test
    public void testGetFilteredAttributeMultiValuesWfs20() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs";
        Document document = this.postAsDOM(request, this.readResource("/test-data/stations/multiValues/requests/station_tag_code_filter_wfs20.xml"));
        this.checkStation1Gml32(document);
    }

    @Test
    public void testGetFilteredAttributeMultiValuesWfs11() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs";
        Document document = this.postAsDOM(request, this.readResource("/test-data/stations/multiValues/requests/station_tag_code_filter_wfs11.xml"));
        this.checkStation1Gml31(document);
    }

    private void checkStation1Gml31(Document document) {
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1'][st_gml31:tag='st_1_tag_a']/st_gml31:tag[@st_gml31:code='1']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1'][st_gml31:tag='st_1_tag_b']/st_gml31:tag[@st_gml31:code='2']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1'][st_gml31:tag='europe']/st_gml31:tag[@st_gml31:code='3']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:measurements/ms_gml31:Measurement_gml31[@gml:id='ms.1'][ms_gml31:tag='temperature_tag'][ms_gml31:tag='desert_tag']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:measurements/ms_gml31:Measurement_gml31[@gml:id='ms.2'][ms_gml31:tag='wind_tag']");
    }

    private void checkStation2Gml31(Document document) {
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.2']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.2'][st_gml31:tag='st_2_tag_a']/st_gml31:tag[@st_gml31:code='4']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.2'][st_gml31:tag='st_2_tag_b']/st_gml31:tag[@st_gml31:code='5']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.2'][st_gml31:tag='europe']/st_gml31:tag[@st_gml31:code='6']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.2']/st_gml31:measurements/ms_gml31:Measurement_gml31[@gml:id='ms.3'][ms_gml31:tag='pressure_tag']");
    }

    private void checkStation3Gml31(Document document) {
        String stationPath = "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.3']";
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, stationPath);
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 0, stationPath + "/st_gml31:tag");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, stationPath + "/st_gml31:measurements/ms_gml31:Measurement_gml31[@gml:id='ms.4']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 0, stationPath + "/st_gml31:measurements/ms_gml31:Measurement_gml31[@gml:id='ms.4']/ms_gml31:tag");
    }

    private void checkStation1Gml32(Document document) {
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1'][st_gml32:tag='st_1_tag_a']/st_gml32:tag[@st_gml32:code='1']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1'][st_gml32:tag='st_1_tag_b']/st_gml32:tag[@st_gml32:code='2']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1'][st_gml32:tag='europe']/st_gml32:tag[@st_gml32:code='3']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1']/st_gml32:measurements/ms_gml32:Measurement_gml32[@gml:id='ms.1'][ms_gml32:tag='temperature_tag'][ms_gml32:tag='desert_tag']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1']/st_gml32:measurements/ms_gml32:Measurement_gml32[@gml:id='ms.1']/ms_gml32:tag[@ms_gml32:code='8']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1']/st_gml32:measurements/ms_gml32:Measurement_gml32[@gml:id='ms.2'][ms_gml32:tag='wind_tag']");
    }

    private void checkStation2Gml32(Document document) {
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.2']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.2'][st_gml32:tag='st_2_tag_a']/st_gml32:tag[@st_gml32:code='4']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.2'][st_gml32:tag='st_2_tag_b']/st_gml32:tag[@st_gml32:code='5']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.2'][st_gml32:tag='europe']/st_gml32:tag[@st_gml32:code='6']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.2']/st_gml32:measurements/ms_gml32:Measurement_gml32[@gml:id='ms.3'][ms_gml32:tag='pressure_tag']");
    }

    private void checkStation3Gml32(Document document) {
        String stationPath = "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.3']";
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.3']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 0, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.3']/st_gml32:tag");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.3']/st_gml32:measurements/ms_gml32:Measurement_gml32[@gml:id='ms.4']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 0, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.3']/st_gml32:measurements/ms_gml32:Measurement_gml32[@gml:id='ms.4']/ms_gml32:tag");
    }

    private void checkCount(XpathEngine xpathEngine, Document document, int expectedCount, String xpath) {
        try {
            MatcherAssert.assertThat((Object)xpathEngine.getMatchingNodes(xpath, document).getLength(), (Matcher)CoreMatchers.is((Object)expectedCount));
        }
        catch (Exception exception) {
            throw new RuntimeException("Error evaluating xpath.", exception);
        }
    }

    private boolean notJdbcBased() throws Exception {
        NameImpl name;
        FeatureTypeInfo featureTypeInfo = this.getCatalog().getFeatureTypeByName("Station_gml31");
        DataAccess dataAccess = featureTypeInfo.getStore().getDataStore(null);
        AppSchemaDataAccess appSchemaDataAccess = (AppSchemaDataAccess)dataAccess;
        FeatureSource featureSource = appSchemaDataAccess.getMappingByName((Name)(name = new NameImpl("http://www.stations_gml31.org/1.0", "Station_gml31"))).getSource();
        return !(featureSource instanceof JDBCFeatureStore);
    }

    @Test
    public void testJDBCMultipleValueWithClientProps() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32";
        Document document = this.getAsDOM(request);
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 3, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32/st_gml32:info[@xlink:href='http://www.stations.org/1.0/st1' and @xlink:title='ST1']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32/st_gml32:info[@xlink:href='http://www.stations.org/1.0/st2' and @xlink:title='ST2']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32/st_gml32:info[@xlink:href='http://www.stations.org/1.0/st3' and @xlink:title='ST3']");
    }

    @Test
    public void testJDBCMultipleValueWithClientPropsFilter() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32&cql_filter=st_gml32:info.\"@xlink:title\"='ST2'";
        Document document = this.getAsDOM(request);
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32/st_gml32:info[@xlink:title='ST2']");
    }

    @Test
    public void testJDBCMultipleValueWithPKInTargetColumn() throws Exception {
        if (this.notJdbcBased()) {
            return;
        }
        String request = "wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32";
        Document document = this.getAsDOM(request);
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 3, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32/st_gml32:use[@xlink:href='http://link/use1' and @xlink:title='use1']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32/st_gml32:use[@xlink:href='http://link/use2' and @xlink:title='use2']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32/st_gml32:use[@xlink:href='http://link/use3' and @xlink:title='use3']");
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace("st_gml31", "http://www.stations_gml31.org/1.0");
            this.putNamespace("ms_gml31", "http://www.measurements_gml31.org/1.0");
            this.putNamespace("st_gml32", "http://www.stations_gml32.org/1.0");
            this.putNamespace("ms_gml32", "http://www.measurements_gml32.org/1.0");
            HashMap<String, String> gml31Parameters = new HashMap<String, String>();
            gml31Parameters.put("GML_PREFIX", "gml31");
            gml31Parameters.put("GML_PREFIX_UPPER", "GML31");
            gml31Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml");
            gml31Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.1.1/base/gml.xsd");
            this.addAppSchemaFeatureType("st_gml31", "gml31", "Station_gml31", "/test-data/stations/multiValues/stations.xml", gml31Parameters, "/test-data/stations/multiValues/stations.xsd", "/test-data/stations/multiValues/stations.properties", "/test-data/stations/multiValues/measurements.xml", "/test-data/stations/multiValues/measurements.xsd", "/test-data/stations/multiValues/measurements.properties", "/test-data/stations/multiValues/tags.properties", "/test-data/stations/multiValues/info.properties", "/test-data/stations/multiValues/use.properties");
            HashMap<String, String> gml32Parameters = new HashMap<String, String>();
            gml32Parameters.put("GML_PREFIX", "gml32");
            gml32Parameters.put("GML_PREFIX_UPPER", "GML32");
            gml32Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml/3.2");
            gml32Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd");
            this.addAppSchemaFeatureType("st_gml32", "gml32", "Station_gml32", "/test-data/stations/multiValues/stations.xml", gml32Parameters, "/test-data/stations/multiValues/stations.xsd", "/test-data/stations/multiValues/stations.properties", "/test-data/stations/multiValues/measurements.xml", "/test-data/stations/multiValues/measurements.xsd", "/test-data/stations/multiValues/measurements.properties", "/test-data/stations/multiValues/tags.properties", "/test-data/stations/multiValues/info.properties", "/test-data/stations/multiValues/use.properties");
        }
    }
}

