/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.IOException;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.NestedIdSupportTestData;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.appschema.jdbc.NestedFilterToSQL;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.filter.ComplexFilterSplitter;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.util.NullProgressListener;
import org.geotools.jdbc.JDBCDataStore;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.w3c.dom.Document;

public class NestedIdSupportTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected NestedIdSupportTestData createTestData() {
        return new NestedIdSupportTestData();
    }

    @Test
    public void testNestedIdFeatureChaining() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" ><wfs:Query typeName=\"gsml:MappedFeature\"><ogc:Filter>     <ogc:PropertyIsEqualTo>        <ogc:PropertyName>gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology/gsml:ControlledConcept/@gml:id</ogc:PropertyName>        <ogc:Literal>cc.1</ogc:Literal>     </ogc:PropertyIsEqualTo> </ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("MappedFeature: WFS GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("mf4", "wfs:FeatureCollection/gml:featureMember/gsml:MappedFeature/@gml:id", doc);
    }

    @Test
    public void testNestedIdInlineMapping() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML:2.0\" ><wfs:Query typeName=\"gsml:Borehole\"><ogc:Filter>     <ogc:PropertyIsEqualTo>        <ogc:PropertyName>gsml:indexData/gsml:BoreholeDetails/@gml:id</ogc:PropertyName>        <ogc:Literal>bh.details.11.sp</ogc:Literal>     </ogc:PropertyIsEqualTo> </ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("Borehole: WFS GetFeature response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:Borehole", doc);
        this.assertXpathEvaluatesTo("11", "wfs:FeatureCollection/gml:featureMember/gsml:Borehole/@gml:id", doc);
    }

    @Test
    public void testNestedFiltersEncoding() throws IOException, FilterToSQLException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName("gsml", "MappedFeature");
        FeatureSource fs = ftInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        AppSchemaDataAccess da = (AppSchemaDataAccess)fs.getDataStore();
        FeatureTypeMapping rootMapping = da.getMappingByNameOrElement(ftInfo.getQualifiedName());
        Assume.assumeTrue((boolean)this.shouldTestNestedFiltersEncoding(rootMapping));
        JDBCDataStore store = (JDBCDataStore)rootMapping.getSource().getDataStore();
        NestedFilterToSQL nestedFilterToSQL = this.createNestedFilterEncoder(rootMapping);
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware();
        ff.setNamepaceContext(rootMapping.getNamespaces());
        PropertyIsEqualTo nestedIdFilter = ff.equals((Expression)ff.property("gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:lithology/gsml:ControlledConcept/@gml:id"), (Expression)ff.literal((Object)"cc.1"));
        ComplexFilterSplitter splitter = new ComplexFilterSplitter(store.getFilterCapabilities(), rootMapping);
        splitter.visit(nestedIdFilter, null);
        Filter preFilter = splitter.getFilterPre();
        Filter postFilter = splitter.getFilterPost();
        Assert.assertEquals((Object)nestedIdFilter, (Object)preFilter);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)postFilter);
        Filter unrolled = AppSchemaDataAccess.unrollFilter((Filter)nestedIdFilter, (FeatureTypeMapping)rootMapping);
        Assert.assertTrue((boolean)NestedFilterToSQL.isNestedFilter((Filter)unrolled));
        String encodedFilter = nestedFilterToSQL.encodeToString(unrolled);
        Assert.assertTrue((boolean)encodedFilter.matches("^EXISTS.*SELECT.*FROM.*INNER JOIN.*INNER JOIN.*WHERE.*$"));
        this.assertContainsFeatures(fs.getFeatures((Filter)nestedIdFilter), "mf4");
    }
}

