/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class NestedElementsFilteringTest
extends AbstractAppSchemaTestSupport {
    private static final String STATIONS_PREFIX = "st";
    private static final String STATIONS_URI = "http://www.stations.org/1.0";

    @Override
    protected StationsMockData createTestData() {
        return new MockData();
    }

    @Test
    public void testWfsGetFeatureWithAdvancedNestedFilter() throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse("wfs", this.readResource("/test-data/stations/nestedElements/requests/wfs_get_feature_1.xml"));
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"gml:id=\"ins.1\""));
        MatcherAssert.assertThat((Object)StringUtils.countMatches((CharSequence)content, (CharSequence)"<wfs:member>"), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWfsIncludedNamespacesDeclaration() throws Exception {
        Document doc = this.postAsDOM("wfs", this.readResource("/test-data/stations/nestedElements/requests/wfs_get_feature_1.xml"));
        Node perAttributeNode = doc.getFirstChild().getAttributes().getNamedItem("xmlns:per");
        Assert.assertTrue((boolean)(perAttributeNode instanceof Attr));
        Attr perAttr = (Attr)perAttributeNode;
        Assert.assertEquals((Object)"http://www.person.org/1.0", (Object)perAttr.getValue());
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace(NestedElementsFilteringTest.STATIONS_PREFIX, NestedElementsFilteringTest.STATIONS_URI);
            this.addAppSchemaFeatureType(NestedElementsFilteringTest.STATIONS_PREFIX, null, "Station", "/test-data/stations/nestedElements/stations.xml", Collections.emptyMap(), "/test-data/stations/nestedElements/stations.xsd", "/test-data/stations/nestedElements/institutes.xml", "/test-data/stations/nestedElements/persons.xml", "/test-data/stations/nestedElements/stations.properties", "/test-data/stations/nestedElements/institutes.properties", "/test-data/stations/nestedElements/persons.properties");
        }
    }
}

