/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.opengis.wfs20.StoredQueryDescriptionType;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.NamespaceInfoImpl;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.StationsAppSchemaTestSupport;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public final class NamespacesWfsTest
extends StationsAppSchemaTestSupport {
    private static final String TEST_STORED_QUERY_ID = "NamespacesTestStoredQuery";
    private static final String TEST_STORED_QUERY_DEFINITION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wfs:StoredQueryDescription id='NamespacesTestStoredQuery' xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"${GML_NAMESPACE}\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\">>\n  <wfs:QueryExpressionText\n   returnFeatureTypes='st_${GML_PREFIX}:Station_${GML_PREFIX}'\n   language='urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression'\n   isPrivate='false'>\n    <wfs:Query typeNames='st_${GML_PREFIX}:Station_${GML_PREFIX}'>\n      <fes:Filter>\n        <fes:PropertyIsEqualTo>\n          <fes:ValueReference>st_${GML_PREFIX}:measurements/ms_${GML_PREFIX}:Measurement_${GML_PREFIX}/ms_${GML_PREFIX}:name</fes:ValueReference>\n          <fes:Literal>wind</fes:Literal>\n        </fes:PropertyIsEqualTo>\n      </fes:Filter>\n    </wfs:Query>\n  </wfs:QueryExpressionText>\n</wfs:StoredQueryDescription>";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addTestNamespaceToCatalog();
    }

    @Test
    public void globalServiceGetFeatureNamespacesWfs11() {
        Document document = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=st_gml31:Station_gml31");
        this.checkWfs11StationsGetFeatureResult(document);
    }

    @Test
    public void virtualServiceGetFeatureNamespacesWfs11() {
        Document document = this.getAsDOM("st_gml31/wfs?request=GetFeature&version=1.1.0&typename=st_gml31:Station_gml31");
        this.checkWfs11StationsGetFeatureResult(document);
    }

    @Test
    public void globalServiceGetFeatureNamespacesWfs20() {
        Document document = this.getAsDOM("wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32");
        this.checkWfs20StationsGetFeatureResult(document);
    }

    @Test
    public void virtualServiceGetFeatureNamespacesWfs20() {
        Document document = this.getAsDOM("st_gml32/wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32");
        this.checkWfs20StationsGetFeatureResult(document);
    }

    @Test
    public void globalServiceGetPropertyValueNamespacesGml32() {
        Document document = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0&typename=st_gml32:Station_gml32&valueReference=st_gml32:measurements");
        this.checkGml32StationsGetPropertyValueResult(document);
    }

    @Test
    public void virtualServiceGetPropertyValueNamespacesGml32() {
        Document document = this.getAsDOM("st_gml32/wfs?request=GetPropertyValue&version=2.0&typename=st_gml32:Station_gml32&valueReference=st_gml32:measurements");
        this.checkGml32StationsGetPropertyValueResult(document);
    }

    @Test
    public void globalServiceStoredQueryNamespacesGml32() throws Exception {
        StoredQueryProvider storedQueryProvider = new StoredQueryProvider(this.getCatalog());
        try {
            this.createTestStoredQuery(storedQueryProvider, this.GML32_PARAMETERS);
            Document document = this.getAsDOM("wfs?request=GetFeature&version=2.0&StoredQueryID=NamespacesTestStoredQuery");
            this.checkWfs20StationsGetFeatureResult(document);
        }
        finally {
            storedQueryProvider.removeAll();
            Assert.assertEquals((long)1L, (long)storedQueryProvider.listStoredQueries().size());
        }
    }

    @Test
    public void virtualServiceStoredQueryNamespacesGml32() throws Exception {
        StoredQueryProvider storedQueryProvider = new StoredQueryProvider(this.getCatalog());
        try {
            this.createTestStoredQuery(storedQueryProvider, this.GML32_PARAMETERS);
            Document document = this.getAsDOM("st_gml32/wfs?request=GetFeature&version=2.0&StoredQueryID=NamespacesTestStoredQuery");
            this.checkWfs20StationsGetFeatureResult(document);
        }
        finally {
            storedQueryProvider.removeAll();
            Assert.assertEquals((long)1L, (long)storedQueryProvider.listStoredQueries().size());
        }
    }

    @Test
    public void globalServiceStoredQueryNamespacesGml31() throws Exception {
        StoredQueryProvider storedQueryProvider = new StoredQueryProvider(this.getCatalog());
        try {
            this.createTestStoredQuery(storedQueryProvider, this.GML31_PARAMETERS);
            Document document = this.getAsDOM("wfs?request=GetFeature&version=2.0&outputFormat=gml3&StoredQueryID=NamespacesTestStoredQuery");
            this.checkWfs11StationsGetFeatureResult(document);
        }
        finally {
            storedQueryProvider.removeAll();
            Assert.assertEquals((long)1L, (long)storedQueryProvider.listStoredQueries().size());
        }
    }

    @Test
    public void virtualServiceStoredQueryNamespacesGml31() throws Exception {
        StoredQueryProvider storedQueryProvider = new StoredQueryProvider(this.getCatalog(), null, true, null);
        try {
            this.createTestStoredQuery(storedQueryProvider, this.GML31_PARAMETERS);
            Document document = this.getAsDOM("st_gml31/wfs?request=GetFeature&version=2.0&outputFormat=gml3&StoredQueryID=NamespacesTestStoredQuery");
            this.checkWfs11StationsGetFeatureResult(document);
        }
        finally {
            storedQueryProvider.removeAll();
            Assert.assertEquals((long)1L, (long)storedQueryProvider.listStoredQueries().size());
        }
    }

    private void createTestStoredQuery(StoredQueryProvider storedQueryProvider, Map<String, String> parameters) throws Exception {
        StoredQueryDescriptionType storedQueryDescriptionType = this.createTestStoredQueryDefinition(parameters);
        StoredQuery result = storedQueryProvider.createStoredQuery(storedQueryDescriptionType);
        Assert.assertEquals((long)2L, (long)storedQueryProvider.listStoredQueries().size());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)TEST_STORED_QUERY_ID));
        MatcherAssert.assertThat((Object)storedQueryProvider.getStoredQuery(TEST_STORED_QUERY_ID).getName(), (Matcher)CoreMatchers.is((Object)TEST_STORED_QUERY_ID));
    }

    private StoredQueryDescriptionType createTestStoredQueryDefinition(Map<String, String> parameters) throws Exception {
        Parser p = new Parser((Configuration)new WFSConfiguration());
        p.setRootElementType(WFS.StoredQueryDescriptionType);
        String queryDefinition = NamespacesWfsTest.substitutePlaceHolders(TEST_STORED_QUERY_DEFINITION, parameters);
        try (StringReader reader = new StringReader(queryDefinition);){
            StoredQueryDescriptionType storedQueryDescriptionType = (StoredQueryDescriptionType)p.parse((Reader)reader);
            return storedQueryDescriptionType;
        }
    }

    private static String substitutePlaceHolders(String string, Map<String, String> placeHolderValues) {
        String processedString = string;
        for (Map.Entry<String, String> placeHolder : placeHolderValues.entrySet()) {
            processedString = processedString.replace(String.format("${%s}", placeHolder.getKey()), placeHolder.getValue());
        }
        return processedString;
    }

    private void checkWfs11StationsGetFeatureResult(Document document) {
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:measurements/ms_gml31:Measurement_gml31[ms_gml31:name='temperature']");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id='st.1']/st_gml31:location/gml:Point[gml:pos='1 -1']");
    }

    private void checkWfs20StationsGetFeatureResult(Document document) {
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1']/st_gml32:measurements/ms_gml32:Measurement_gml32[ms_gml32:name='temperature']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id='st.1']/st_gml32:location/gml:Point[gml:pos='1 -1']");
    }

    private void checkGml32StationsGetPropertyValueResult(Document document) {
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:ValueCollection/wfs:member/st_gml32:measurements/ms_gml32:Measurement_gml32[ms_gml32:name='temperature']");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:ValueCollection/wfs:member/st_gml32:measurements/ms_gml32:Measurement_gml32[ms_gml32:name='wind']");
    }

    @Test
    public void testTwoQueriesNamespacesGml32() throws Exception {
        String wfsQuery = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-data/stations/stations_two_queries.xml"), (Charset)StandardCharsets.UTF_8);
        Document document = this.postAsDOM("wfs", wfsQuery);
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/wfs:member/wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/wfs:member/wfs:FeatureCollection/wfs:member/ms_gml32:Measurement_gml32");
        String output = NamespacesWfsTest.toString(document);
        Assert.assertTrue((output.indexOf("null:Measurement_gml32") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("null:Station_gml32") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("ms_gml32:Measurement_gml32") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("st_gml32:Station_gml32") > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)output.indexOf("xmlns:test1=\"http://www.test1.org/test1\""), (long)-1L);
    }

    @Test
    public void testTwoQueriesNamespacesGml31() throws Exception {
        String wfsQuery = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-data/stations/stations_two_queries_1.1.xml"), (Charset)StandardCharsets.UTF_8);
        Document document = this.postAsDOM("wfs", wfsQuery);
        String output = NamespacesWfsTest.toString(document);
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, document, 1, "/wfs:FeatureCollection/gml:featureMember/ms_gml31:Measurement_gml31");
        Assert.assertTrue((output.indexOf("null:Measurement_gml31") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("null:Station_gml31") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("ms_gml31:Measurement_gml31") > -1 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("st_gml31:Station_gml31") > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)output.indexOf("xmlns:test1=\"http://www.test1.org/test1\""), (long)-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsolatedWorkspaceGetFeatureNamespacesWfs11() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspaceInfo = catalog.getWorkspaceByName("st_gml31");
        workspaceInfo.setIsolated(true);
        catalog.save(workspaceInfo);
        try {
            Document document = this.getAsDOM("st_gml31/wfs?request=GetFeature&version=1.1.0&typename=st_gml31:Station_gml31");
            Assert.assertEquals((Object)"http://www.measurements_gml31.org/1.0", (Object)document.getFirstChild().getAttributes().getNamedItemNS("http://www.w3.org/2000/xmlns/", "ms_gml31").getTextContent());
            Assert.assertNull((Object)document.getFirstChild().getAttributes().getNamedItemNS("http://www.w3.org/2000/xmlns/", "test1"));
        }
        finally {
            workspaceInfo = catalog.getWorkspaceByName("st_gml31");
            workspaceInfo.setIsolated(false);
            catalog.save(workspaceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsolatedWorkspaceGetFeatureNamespacesWfs20() throws Exception {
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspaceInfo = catalog.getWorkspaceByName("st_gml32");
        workspaceInfo.setIsolated(true);
        catalog.save(workspaceInfo);
        try {
            Document document = this.getAsDOM("st_gml32/wfs?request=GetFeature&version=2.0.0&typename=st_gml32:Station_gml32");
            Assert.assertEquals((Object)"http://www.measurements_gml32.org/1.0", (Object)document.getFirstChild().getAttributes().getNamedItemNS("http://www.w3.org/2000/xmlns/", "ms_gml32").getTextContent());
            Assert.assertNull((Object)document.getFirstChild().getAttributes().getNamedItemNS("http://www.w3.org/2000/xmlns/", "test1"));
        }
        finally {
            workspaceInfo = catalog.getWorkspaceByName("st_gml32");
            workspaceInfo.setIsolated(false);
            catalog.save(workspaceInfo);
        }
    }

    private void addTestNamespaceToCatalog() {
        NamespaceInfoImpl ns1 = new NamespaceInfoImpl();
        ns1.setURI("http://www.test1.org/test1");
        ns1.setPrefix("test1");
        this.getCatalog().add((NamespaceInfo)ns1);
    }
}

