/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.MultivaluedXlinkHrefMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class MultivaluedXlinkHrefTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected MultivaluedXlinkHrefMockData createTestData() {
        return new MultivaluedXlinkHrefMockData();
    }

    @Test
    public void testGetFeature() {
        Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetFeature&typenames=gsml:GeologicUnit");
        LOGGER.info("WFS GetFeature, typename=gsml:GeologicUnit response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.1", "//gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit[@gml:id='gu.1']/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("http://resource.example.org/mapped-feature/mf.2", "//gsml:GeologicUnit[@gml:id='gu.1']/gsml:occurrence[1]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("http://resource.example.org/mapped-feature/mf.3", "//gsml:GeologicUnit[@gml:id='gu.1']/gsml:occurrence[2]/@xlink:href", doc);
    }

    @Test
    public void testGetFeatureFilterFirstXlinkHref() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" >    <wfs:Query typeNames=\"gsml:GeologicUnit\">        <fes:Filter>            <fes:PropertyIsEqualTo>                <fes:ValueReference>gsml:occurrence/@xlink:href</fes:ValueReference>                <fes:Literal>http://resource.example.org/mapped-feature/mf.2</fes:Literal>            </fes:PropertyIsEqualTo>        </fes:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info(this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.1", "//gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit[@gml:id='gu.1']/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("http://resource.example.org/mapped-feature/mf.2", "//gsml:GeologicUnit[@gml:id='gu.1']/gsml:occurrence[1]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("http://resource.example.org/mapped-feature/mf.3", "//gsml:GeologicUnit[@gml:id='gu.1']/gsml:occurrence[2]/@xlink:href", doc);
    }

    @Test
    public void testGetFeatureFilterSecondXlinkHref() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" >    <wfs:Query typeNames=\"gsml:GeologicUnit\">        <fes:Filter>            <fes:PropertyIsEqualTo>                <fes:ValueReference>gsml:occurrence/@xlink:href</fes:ValueReference>                <fes:Literal>http://resource.example.org/mapped-feature/mf.3</fes:Literal>            </fes:PropertyIsEqualTo>        </fes:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info(this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit", doc);
        this.assertXpathEvaluatesTo("gu.1", "//gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathCount(2, "//gsml:GeologicUnit[@gml:id='gu.1']/gsml:occurrence", doc);
        this.assertXpathEvaluatesTo("http://resource.example.org/mapped-feature/mf.2", "//gsml:GeologicUnit[@gml:id='gu.1']/gsml:occurrence[1]/@xlink:href", doc);
        this.assertXpathEvaluatesTo("http://resource.example.org/mapped-feature/mf.3", "//gsml:GeologicUnit[@gml:id='gu.1']/gsml:occurrence[2]/@xlink:href", doc);
    }

    @Test
    public void testGetFeatureFilterNonexistentXlinkHref() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:gsml=\"urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" >    <wfs:Query typeNames=\"gsml:GeologicUnit\">        <fes:Filter>            <fes:PropertyIsEqualTo>                <fes:ValueReference>gsml:occurrence/@xlink:href</fes:ValueReference>                <fes:Literal>http://resource.example.org/mapped-feature/does-not-exist</fes:Literal>            </fes:PropertyIsEqualTo>        </fes:Filter>    </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info(this.prettyString(doc));
        this.assertXpathCount(0, "//gsml:GeologicUnit", doc);
    }
}

