/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.MultiGeometryMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class MultiGeometryTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected AbstractAppSchemaMockData createTestData() {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        return new MultiGeometryMockData();
    }

    @Test
    public void testMultiGeometry() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainer response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//ex:geomContainer[@gml:id='mf1']/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("5.03335814 -1", "//ex:geomContainer[@gml:id='mf1']/ex:geom/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4979", "//ex:geomContainer[@gml:id='mf1']/ex:shape/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("133.8855 -23.6701 112", "//ex:geomContainer[@gml:id='mf1']/ex:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4326", "//ex:geomContainer[@gml:id='mf1']/ex:nestedFeature/ex:nestedGeom/ex:geom/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.5 -1.2 52.6 -1.2 52.6 -1.1 52.5 -1.1 52.5 -1.2", "//ex:geomContainer[@gml:id='mf1']/ex:nestedFeature/ex:nestedGeom/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
    }

    @Test
    public void testMultiGeometryReprojected() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&srsName=urn:x-ogc:def:crs:EPSG:4052");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainer response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4052", "//ex:geomContainer[@gml:id='mf1']/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("5 -1", "//ex:geomContainer[@gml:id='mf1']/ex:geom/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("http://www.opengis.net/gml/srs/epsg.xml#4979", "//ex:geomContainer[@gml:id='mf1']/ex:shape/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("133.8855 -23.6701 112", "//ex:geomContainer[@gml:id='mf1']/ex:shape/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4052", "//ex:geomContainer[@gml:id='mf1']/ex:nestedFeature/ex:nestedGeom/ex:geom/gml:Polygon/@srsName", doc);
        this.assertXpathEvaluatesTo("52.31400393 -1.2 52.41418008 -1.2 52.41418008 -1.1 52.31400393 -1.1 52.31400393 -1.2", "//ex:geomContainer[@gml:id='mf1']/ex:nestedFeature/ex:nestedGeom/ex:geom/gml:Polygon/gml:exterior/gml:LinearRing/gml:posList", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4052", "//ex:geomContainer[@gml:id='mf1']/ex:location/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("4.96649296 -1", "//ex:geomContainer[@gml:id='mf1']/ex:location/gml:Point/gml:pos", doc);
    }
}

