/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.geotools.jdbc.ConnectionLifecycleListener;
import org.geotools.jdbc.JDBCDataStore;

class MockConnectionLifecycleListener
implements ConnectionLifecycleListener {
    Map<JDBCDataStore, ActionCount> actionCountByDataStore = new HashMap<JDBCDataStore, ActionCount>();

    MockConnectionLifecycleListener() {
    }

    private void initCountIfNecessary(JDBCDataStore store) {
        if (!this.actionCountByDataStore.containsKey(store)) {
            this.actionCountByDataStore.put(store, new ActionCount());
        }
    }

    public void onBorrow(JDBCDataStore store, Connection cx) throws SQLException {
        this.initCountIfNecessary(store);
        ++this.actionCountByDataStore.get((Object)store).borrowCount;
    }

    public void onRelease(JDBCDataStore store, Connection cx) throws SQLException {
        this.initCountIfNecessary(store);
        ++this.actionCountByDataStore.get((Object)store).releaseCount;
    }

    public void onCommit(JDBCDataStore store, Connection cx) throws SQLException {
        this.initCountIfNecessary(store);
        ++this.actionCountByDataStore.get((Object)store).commitCount;
    }

    public void onRollback(JDBCDataStore store, Connection cx) throws SQLException {
        this.initCountIfNecessary(store);
        ++this.actionCountByDataStore.get((Object)store).rollbackCount;
    }

    class ActionCount {
        int borrowCount = 0;
        int releaseCount = 0;
        int commitCount = 0;
        int rollbackCount = 0;

        ActionCount() {
        }
    }
}

