/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.FeatureGML32ResolveMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class LocalResolveFeatureChainingByRefTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected FeatureGML32ResolveMockData createTestData() {
        return new FeatureGML32ResolveMockData();
    }

    @Test
    public void testResolveDepth2() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:GeologicUnit&resolve=local&resolveDepth=2");
        LOGGER.info("WFS testResolveDepth2 response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25678']/gsml:occurrence/gsml:MappedFeature[@gml:id='mf2']", doc);
        this.assertXpathEvaluatesTo("#gu.25678", "//gsml:GeologicUnit[@gml:id='gu.25678']/gsml:occurrence/gsml:MappedFeature[@gml:id='mf2']/gsml:specification/@xlink:href", doc);
    }

    @Test
    public void testResolveDepth1() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:GeologicUnit&resolve=local&resolveDepth=1");
        LOGGER.info("WFS testResolveDepth1 response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25678']/gsml:occurrence/gsml:MappedFeature[@gml:id='mf2']", doc);
        this.assertXpathEvaluatesTo("urn:x-test:GeologicUnit:gu.25678", "//gsml:GeologicUnit[@gml:id='gu.25678']/gsml:occurrence/gsml:MappedFeature[@gml:id='mf2']/gsml:specification/@xlink:href", doc);
    }

    @Test
    public void testResolveDepth0() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:GeologicUnit&resolve=local&resolveDepth=0");
        LOGGER.info("WFS testResolveDepth0 response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25678']/gsml:occurrence[@xlink:href='urn:cgi:feature:MappedFeature:mf2']", doc);
    }

    @Test
    public void testNoResolve() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typename=gsml:GeologicUnit&resolve=none");
        LOGGER.info("WFS testNoResolve response:\n" + this.prettyString(doc));
        this.assertXpathCount(1, "//gsml:GeologicUnit[@gml:id='gu.25678']/gsml:occurrence[@xlink:href='urn:cgi:feature:MappedFeature:mf2']", doc);
    }
}

