/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.geoserver.test.StationsAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class HandlesIncludesTest
extends StationsAppSchemaTestSupport {
    @Override
    protected StationsMockData createTestData() {
        return new HandlesIncludesMockData();
    }

    @Test
    public void testGMLOutput32_With_Include() throws Exception {
        Document document = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=st_gml32:Station_gml32");
        this.assertXpathEvaluatesTo("http://www.measurements_gml32.org/1.0", "namespace-uri(//*[local-name()='Measurement_gml32'][1])", document);
    }

    private static class HandlesIncludesMockData
    extends StationsMockData {
        private HandlesIncludesMockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace("st_gml32", "http://www.stations_gml32.org/1.0");
            this.putNamespace("ms_gml32", "http://www.measurements_gml32.org/1.0");
            HashMap<String, String> gml32Parameters = new HashMap<String, String>();
            gml32Parameters.put("GML_PREFIX", "gml32");
            gml32Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml/3.2");
            gml32Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd");
            this.addMeasurementFeatureType("ms_gml32", "gml32", "measurements", "handlesIncludes/measurements.xml", gml32Parameters);
            this.addStationFeatureType("st_gml32", "gml32", "stations", "handlesIncludes/stations.xml", gml32Parameters);
        }

        @Override
        protected void addStationFeatureType(String namespacePrefix, String gmlPrefix, String mappingsName, String mappingsPath, Map<String, String> parameters) {
            File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
            gmlDirectory.mkdirs();
            File stationsMappings = new File(gmlDirectory, String.format("%s_%s.xml", mappingsName, gmlPrefix));
            File stationsProperties = new File(gmlDirectory, String.format("stations_%s.properties", gmlPrefix));
            File stationsSchema = new File(gmlDirectory, String.format("stations_%s.xsd", gmlPrefix));
            File measurementsSchema = new File(gmlDirectory, String.format("measurements_%s.xsd", gmlPrefix));
            HandlesIncludesMockData.substituteParameters("/test-data/stations/" + mappingsPath, parameters, stationsMappings);
            HandlesIncludesMockData.substituteParameters("/test-data/stations/handlesIncludes/stations.properties", parameters, stationsProperties);
            HandlesIncludesMockData.substituteParameters("/test-data/stations/handlesIncludes/stations.xsd", parameters, stationsSchema);
            HandlesIncludesMockData.substituteParameters("/test-data/stations/handlesIncludes/measurements.xsd", parameters, measurementsSchema);
            this.addStationFeatures(stationsProperties);
            this.addFeatureType(namespacePrefix, String.format("Station_%s", gmlPrefix), stationsMappings.getAbsolutePath(), stationsProperties.getAbsolutePath(), stationsSchema.getAbsolutePath(), measurementsSchema.getAbsolutePath());
        }

        @Override
        protected void addMeasurementFeatureType(String namespacePrefix, String gmlPrefix, String mappingsName, String mappingsPath, Map<String, String> parameters) {
            File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
            gmlDirectory.mkdirs();
            File measurementsMappings = new File(gmlDirectory, String.format("%s_%s.xml", mappingsName, gmlPrefix));
            File measurementsProperties = new File(gmlDirectory, String.format("measurements_%s.properties", gmlPrefix));
            File measurementsSchema = new File(gmlDirectory, String.format("measurements_%s.xsd", gmlPrefix));
            HandlesIncludesMockData.substituteParameters("/test-data/stations/" + mappingsPath, parameters, measurementsMappings);
            HandlesIncludesMockData.substituteParameters("/test-data/stations/handlesIncludes/measurements.properties", parameters, measurementsProperties);
            HandlesIncludesMockData.substituteParameters("/test-data/stations/handlesIncludes/measurements.xsd", parameters, measurementsSchema);
            this.addMeasurementFeatures(measurementsProperties);
            this.addFeatureType(namespacePrefix, String.format("Measurement_%s", gmlPrefix), measurementsMappings.getAbsolutePath(), measurementsProperties.getAbsolutePath(), measurementsSchema.getAbsolutePath());
        }
    }
}

