/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.Gsml32BoreholeMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class Gsml32BoreholeWfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected Gsml32BoreholeMockData createTestData() {
        return new Gsml32BoreholeMockData();
    }

    @Test
    public void testGetFeatureContent() throws Exception {
        String path = "wfs?request=GetFeature&typename=gsmlbh:Borehole&outputFormat=gml32";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberReturned", doc);
        this.assertXpathCount(2, "//gsmlbh:Borehole", doc);
        this.assertXpathCount(1, "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']", doc);
        String lineStringPath = "sa:relatedSamplingFeature/sa:SamplingFeatureComplex/sa:relatedSamplingFeature/spec:SF_Specimen/spec:samplingLocation/gml:LineString";
        this.assertXpathEvaluatesTo("borehole.specimen.samplingLocation.GA.100", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@gml:id", doc);
        this.assertXpathEvaluatesTo("#borehole.shape.GA.17322", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@srsName", doc);
        this.assertXpathEvaluatesTo("1", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@srsDimension", doc);
        this.assertXpathEvaluatesTo("m", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@uomLabels", doc);
        this.assertXpathEvaluatesTo("57.9 66.4", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/gml:posList", doc);
        this.assertXpathEvaluatesTo("borehole.shape.GA.17322", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/sams:shape/gml:Curve/@gml:id", doc);
        this.assertXpathCount(0, "/gsmlbh:Borehole[@gml:id='borehole.GA.17322']/sams:shape/gml:Curve/@srsName", doc);
        this.assertXpathCount(0, "/gsmlbh:Borehole[@gml:id='borehole.GA.17322']/sams:shape/gml:Curve/@srsDimension", doc);
        this.assertXpathCount(1, "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']", doc);
        this.assertXpathEvaluatesTo("borehole.specimen.samplingLocation.GA.102", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@gml:id", doc);
        this.assertXpathEvaluatesTo("#borehole.shape.GA.17338", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@srsName", doc);
        this.assertXpathEvaluatesTo("1", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@srsDimension", doc);
        this.assertXpathEvaluatesTo("m", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@uomLabels", doc);
        this.assertXpathEvaluatesTo("85.3 89.6", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/gml:posList", doc);
        this.assertXpathEvaluatesTo("borehole.shape.GA.17338", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/sams:shape/gml:Curve/@gml:id", doc);
        this.assertXpathCount(0, "/gsmlbh:Borehole[@gml:id='borehole.GA.17338']/sams:shape/gml:Curve/@srsName", doc);
        this.assertXpathCount(0, "/gsmlbh:Borehole[@gml:id='borehole.GA.17338']/sams:shape/gml:Curve/@srsDimension", doc);
    }
}

