/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.Gsml32BoreholeIntervalMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class Gsml32BoreholeIntervalWfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected Gsml32BoreholeIntervalMockData createTestData() {
        return new Gsml32BoreholeIntervalMockData();
    }

    @Test
    public void testGetFeatureContent() throws Exception {
        String path = "wfs?request=GetFeature&typename=gsmlbh:Borehole&outputFormat=gml32";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberReturned", doc);
        this.assertXpathCount(2, "//gsmlbh:Borehole", doc);
        this.assertXpathCount(1, "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']", doc);
        String lineStringPath = "gsmlbh:downholeDrillingDetails/gsmlbh:DrillingDetails/gsmlbh:interval/gml:LineString";
        this.assertXpathEvaluatesTo("borehole.drillingDetails.interval.17322", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@gml:id", doc);
        this.assertXpathEvaluatesTo("#borehole.shape.GA.17322", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@srsName", doc);
        this.assertXpathEvaluatesTo("1", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@srsDimension", doc);
        this.assertXpathEvaluatesTo("m", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@uomLabels", doc);
        this.assertXpathEvaluatesTo("0 153.92", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/gml:posList", doc);
        this.assertXpathEvaluatesTo("borehole.drillingDetails.interval.17338", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@gml:id", doc);
        this.assertXpathEvaluatesTo("#borehole.shape.GA.17338", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@srsName", doc);
        this.assertXpathEvaluatesTo("1", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@srsDimension", doc);
        this.assertXpathEvaluatesTo("m", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@uomLabels", doc);
        this.assertXpathEvaluatesTo("0 91.55", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/gml:posList", doc);
        lineStringPath = "gsmlbh:logElement/gsmlbh:MappedInterval/gsml:shape/gml:LineString";
        this.assertXpathEvaluatesTo("borehole.mappedInterval.shape.100", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@gml:id", doc);
        this.assertXpathEvaluatesTo("#borehole.shape.GA.17322", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@srsName", doc);
        this.assertXpathEvaluatesTo("1", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@srsDimension", doc);
        this.assertXpathEvaluatesTo("m", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/@uomLabels", doc);
        this.assertXpathEvaluatesTo("57.9 66.4", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/" + lineStringPath + "/gml:posList", doc);
        lineStringPath = "gsmlbh:logElement/gsmlbh:MappedInterval/gsml:shape/gml:LineString";
        this.assertXpathEvaluatesTo("borehole.mappedInterval.shape.102", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@gml:id", doc);
        this.assertXpathEvaluatesTo("#borehole.shape.GA.17338", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@srsName", doc);
        this.assertXpathEvaluatesTo("1", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@srsDimension", doc);
        this.assertXpathEvaluatesTo("m", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/@uomLabels", doc);
        this.assertXpathEvaluatesTo("85.3 89.6", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/" + lineStringPath + "/gml:posList", doc);
        this.assertXpathEvaluatesTo("borehole.shape.GA.17322", "//gsmlbh:Borehole[@gml:id='borehole.GA.17322']/sams:shape/gml:Curve/@gml:id", doc);
        this.assertXpathCount(0, "/gsmlbh:Borehole[@gml:id='borehole.GA.17322']/sams:shape/gml:Curve/@srsName", doc);
        this.assertXpathCount(0, "/gsmlbh:Borehole[@gml:id='borehole.GA.17322']/sams:shape/gml:Curve/@srsDimension", doc);
        this.assertXpathEvaluatesTo("borehole.shape.GA.17338", "//gsmlbh:Borehole[@gml:id='borehole.GA.17338']/sams:shape/gml:Curve/@gml:id", doc);
        this.assertXpathCount(0, "/gsmlbh:Borehole[@gml:id='borehole.GA.17338']/sams:shape/gml:Curve/@srsDimension", doc);
    }
}

