/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.Gsml30MockData;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class Gsml30WfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected Gsml30MockData createTestData() {
        return new Gsml30MockData();
    }

    @Test
    public void testDescribeFeatureType() {
        String path = "wfs?request=DescribeFeatureType&typename=gsml:MappedFeature&version=1.1.0";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathEvaluatesTo(this.getNamespace("gsml"), "//@targetNamespace", doc);
        this.assertXpathCount(1, "//xsd:include", doc);
        this.assertXpathCount(0, "//xsd:import", doc);
        this.assertXpathEvaluatesTo("https://www.seegrid.csiro.au/subversion/GeoSciML/branches/3.0.0_rc1_gml3.2/geosciml-core/3.0.0/xsd/geosciml-core.xsd", "//xsd:include/@schemaLocation", doc);
        this.assertXpathCount(0, "//xsd:complexType", doc);
        this.assertXpathCount(0, "//xsd:element", doc);
    }

    @Test
    public void testGetFeature() {
        String path = "wfs?request=GetFeature&typename=gsml:MappedFeature&outputFormat=gml32";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        Assert.assertEquals((Object)"http://www.opengis.net/wfs/2.0", (Object)doc.getDocumentElement().getNamespaceURI());
        Assert.assertEquals((Object)"FeatureCollection", (Object)doc.getDocumentElement().getLocalName());
    }

    @Test
    public void testGetFeatureValid() {
        String path = "wfs?request=GetFeature&typename=gsml:MappedFeature&outputFormat=gml32";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        this.validateGet(path);
    }

    @Test
    public void testGetFeatureContent() throws Exception {
        String path = "wfs?request=GetFeature&typename=gsml:MappedFeature&outputFormat=gml32";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberReturned", doc);
        this.assertXpathCount(2, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("First", "//gsml:MappedFeature[@gml:id='mf.1']/gml:name", doc);
        this.assertXpathEvaluatesTo("Second", "//gsml:MappedFeature[@gml:id='mf.2']/gml:name", doc);
        this.assertXpathEvaluatesTo("250000", "//gsml:MappedFeature[@gml:id='mf.1']/gsml:resolutionScale/gmd:MD_RepresentativeFraction/gmd:denominator/gco:Integer", doc);
        this.assertXpathEvaluatesTo("250000", "//gsml:MappedFeature[@gml:id='mf.2']/gsml:resolutionScale/gmd:MD_RepresentativeFraction/gmd:denominator/gco:Integer", doc);
    }

    @Test
    public void testNamespace() throws Exception {
        String path = "wfs?request=GetFeature&typename=gsml:MappedFeature&outputFormat=gml32";
        String newline = System.getProperty("line.separator");
        Document doc = this.getAsDOM(path);
        LOGGER.info("Response for " + path + " :" + newline + this.prettyString(doc));
        this.assertXpathEvaluatesTo("2", "/wfs:FeatureCollection/@numberReturned", doc);
        this.assertXpathCount(2, "/wfs:FeatureCollection/wfs:member", doc);
        for (String prefix : this.getRequiredNamespaces().keySet()) {
            Assert.assertEquals((Object)this.getNamespace(prefix), (Object)doc.getFirstChild().getAttributes().getNamedItemNS("http://www.w3.org/2000/xmlns/", prefix).getTextContent());
        }
        Assert.assertEquals((long)0L, (long)doc.getFirstChild().getChildNodes().item(0).getAttributes().getLength());
        Assert.assertEquals((long)0L, (long)doc.getFirstChild().getChildNodes().item(1).getAttributes().getLength());
    }

    private Map<String, String> getRequiredNamespaces() {
        HashMap<String, String> requiredNamespaces = new HashMap<String, String>();
        requiredNamespaces.put("gsml", "urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0");
        requiredNamespaces.put("gmd", "http://www.isotc211.org/2005/gmd");
        requiredNamespaces.put("gco", "http://www.isotc211.org/2005/gco");
        requiredNamespaces.put("cgu", "urn:cgi:xmlns:CGI:Utilities:3.0.0");
        requiredNamespaces.put("swe", "http://www.opengis.net/swe/1.0/gml32");
        return requiredNamespaces;
    }
}

