/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.XLink32MockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class GetPropertyValueTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected XLink32MockData createTestData() {
        return new XLink32MockData();
    }

    @Test
    public void testGetPropertyValue() {
        Document doc = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0.0&typename=gsml:MappedFeature&valueReference=gml:name");
        LOGGER.info("WFS GetPropertyValue response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("GUNTHORPE FORMATION", "//wfs:member[1]/gml:name", doc);
        this.assertXpathCount(5, "//gml:name", doc);
        this.assertXpathCount(0, "//gsml:shape", doc);
        this.assertXpathCount(0, "//gsml:specification", doc);
    }

    @Test
    public void testNoResolve() {
        Document doc = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0.0&typename=gsml:MappedFeature&valueReference=gsml:specification&resolve=none");
        LOGGER.info("WFS GetPropertyValue response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("urn:x-test:GeologicUnit:gu.25699", "//wfs:member[1]/gsml:specification/@xlink:href", doc);
        this.assertXpathCount(0, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(0, "//gsml:CompositionPart", doc);
    }

    @Test
    public void testResolveDepth2() {
        Document doc = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0.0&typename=gsml:MappedFeature&resolve=local&valueReference=gsml:specification&resolveDepth=2");
        LOGGER.info("WFS GetPropertyValue response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("gu.25699", "//gsml:specification[1]/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:ogc:def:nil:OGC::unknown", "//wfs:member[1]/gsml:specification/gsml:GeologicUnit/gsml:composition/gsml:CompositionPart/gsml:role/@xlink:href", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(3, "//gsml:CompositionPart", doc);
        doc = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0.0&typename=gsml:MappedFeature&resolve=local&valueReference=gsml:specification/gsml:GeologicUnit/gml:name&resolveDepth=2");
        LOGGER.info("WFS GetPropertyValue response:\n" + this.prettyString(doc));
        this.assertXpathCount(10, "//gml:name", doc);
        this.assertXpathEvaluatesTo("Yaugher Volcanic Group", "//wfs:member[1]/gml:name", doc);
        this.assertXpathEvaluatesTo("-Py", "//wfs:member[2]/gml:name", doc);
        doc = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0.0&typename=gsml:MappedFeature&resolve=local&valueReference=gsml:specification/gsml:GeologicUnit/gml:name[1]&resolveDepth=2");
        LOGGER.info("WFS GetPropertyValue response:\n" + this.prettyString(doc));
        this.assertXpathCount(4, "//gml:name", doc);
        this.assertXpathEvaluatesTo("Yaugher Volcanic Group", "//wfs:member[1]/gml:name", doc);
        doc = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0.0&typename=gsml:MappedFeature&resolve=local&valueReference=gsml:specification/gsml:GeologicUnit/gml:name[2]&resolveDepth=2");
        LOGGER.info("WFS GetPropertyValue response:\n" + this.prettyString(doc));
        this.assertXpathCount(4, "//gml:name", doc);
        this.assertXpathEvaluatesTo("-Py", "//wfs:member[1]/gml:name", doc);
    }

    @Test
    public void testResolveDepth1() {
        Document doc = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0.0&typename=gsml:MappedFeature&valueReference=gsml:specification&resolve=local&resolveDepth=1");
        LOGGER.info("WFS GetPropertyValue response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("gu.25699", "//wfs:member[1]/gsml:specification/gsml:GeologicUnit/@gml:id", doc);
        this.assertXpathEvaluatesTo("urn:x-test:CompositionPart:cp.167775491936278899", "//wfs:member[1]/gsml:specification/gsml:GeologicUnit/gsml:composition/@xlink:href", doc);
        this.assertXpathCount(3, "//gsml:GeologicUnit", doc);
        this.assertXpathCount(0, "//gsml:CompositionPart", doc);
    }

    @Test
    public void testGetPropertyValueMax() {
        Document doc = this.getAsDOM("wfs?request=GetPropertyValue&version=2.0.0&typename=gsml:MappedFeature&valueReference=gml:name&count=2");
        LOGGER.info("WFS GetPropertyValue response:\n" + this.prettyString(doc));
        this.assertXpathCount(2, "//gml:name", doc);
    }
}

