/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.FeatureGML32MockData;
import org.geoserver.test.GeoPackageUtil;
import org.junit.Test;
import org.w3c.dom.Document;

public class GetFeatureNumberMatchedGMLTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected FeatureGML32MockData createTestData() {
        return new FeatureGML32MockData();
    }

    @Test
    public void testGetMappedFeatureHitsCount() {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml3&request=GetFeature&typeNames=gsml:MappedFeature&resulttype=hits");
        LOGGER.info("WFS GetFeature, typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertNumberMathcedAndNumberReturned(doc, 5, 0);
    }

    @Test
    public void testGetFeatureHitsCountWithFilterOnRootAttribute() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml3&request=GetFeature&typeNames=gsml:MappedFeature&resulttype=hits&cql_filter=gsml:MappedFeature.gml:name = 'MURRADUC BASALT'");
        LOGGER.info(this.prettyString(doc));
        this.assertNumberMathcedAndNumberReturned(doc, 1, 0);
    }

    @Test
    public void testGetFeatureHitsCountWithFilterOnNestedAttribute() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml3&request=GetFeature&typeNames=gsml:MappedFeature&resulttype=hits&cql_filter=gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gml:description = 'Olivine basalt'");
        LOGGER.info(this.prettyString(doc));
        this.assertNumberMathcedAndNumberReturned(doc, 1, 0);
    }

    @Test
    public void testGetFeatureHitsCountWithFilterOnNestedAttribute2() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml3&request=GetFeature&typeNames=gsml:MappedFeature&resulttype=hits&cql_filter=gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gml:description LIKE %27%25Olivine%20basalt%2C%20tuff%25%27");
        LOGGER.info(this.prettyString(doc));
        this.assertNumberMathcedAndNumberReturned(doc, 3, 0);
    }

    @Test
    public void testGetFeatureHitsCountWithFilterOnNestedAttributeWithMaxNumber() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml3&request=GetFeature&typeNames=gsml:MappedFeature&resulttype=hits&cql_filter=gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gml:description LIKE %27%25Olivine%20basalt%2C%20tuff%25%27&count=1");
        LOGGER.info(this.prettyString(doc));
        this.assertNumberMathcedAndNumberReturned(doc, 3, 0);
    }

    @Test
    public void testGetFeatureNumberMatchedWithFilterOnNestedAttribute() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter=gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gml:description = 'Olivine basalt'");
        LOGGER.info(this.prettyString(doc));
        this.assertNumberMathcedAndNumberReturned(doc, 1, 1);
    }

    @Test
    public void testGetFeatureNumberMatchedWithFilterOnNestedAttribute2() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter=gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gml:description LIKE %27%25Olivine%20basalt%2C%20tuff%25%27");
        LOGGER.info(this.prettyString(doc));
        this.assertNumberMathcedAndNumberReturned(doc, 3, 3);
    }

    @Test
    public void testGetFeatureNumberMatchedWithAndNestedFilterOnSameTypes() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter=gsml:specification.gsml:GeologicUnit.gml:description = 'Olivine basalt'AND gsml:specification.gsml:GeologicUnit.gml:name = 'New Group'");
        this.assertNumberMathcedAndNumberReturned(doc, 1, 1);
    }

    @Test
    public void testGetFeatureNumberMatchedWithComplexPropertyORSimpleProperty() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter=gsml:specification.gsml:GeologicUnit.gml:description LIKE %27%25Olivine%20basalt%2C%20tuff%25%27 OR gsml:MappedFeature.gml:name = 'MURRADUC BASALT'");
        this.assertNumberMathcedAndNumberReturned(doc, 4, 4);
    }

    @Test
    public void testGetFeatureNumberMatchedWithSimplePropertyANDComplexProperty() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter=gsml:specification.gsml:GeologicUnit.gml:description = 'Olivine basalt' AND gsml:MappedFeature.gml:name = 'MURRADUC BASALT'");
        this.assertNumberMathcedAndNumberReturned(doc, 1, 1);
    }

    @Test
    public void testGetFeatureNumberMatchedWithComplexPropertyORSimplePropertyWithPagination() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter=gsml:specification.gsml:GeologicUnit.gml:description LIKE %27%25Olivine%20basalt%2C%20tuff%25%27 OR gsml:MappedFeature.gml:name = 'MURRADUC BASALT'&startIndex=3&count=2");
        this.assertNumberMathcedAndNumberReturned(doc, 4, 1);
    }

    @Test
    public void testGetFeatureNumberMatchedWithMultipleAND() throws Exception {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter=gsml:specification.gsml:GeologicUnit.gml:name = 'New Group' AND gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gml:description LIKE %27%25Olivine%25%27 AND gsml:MappedFeature.gml:name = 'MURRADUC BASALT'");
        this.assertNumberMathcedAndNumberReturned(doc, 1, 1);
    }

    @Test
    public void testGetFeatureNumberMatchedWithGeomComplexFilter() throws Exception {
        if (GeoPackageUtil.isGeopkgTest()) {
            return;
        }
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter= intersects(gsml:shape, buffer(POLYGON((-1.3 52.5,-1.3 52.6,-1.2 52.6,-1.2 52.5,-1.3 52.5)),100)) AND gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gml:description LIKE %27%25Olivine%20basalt%2C%20tuff%25%27");
        this.assertNumberMathcedAndNumberReturned(doc, 3, 3);
    }

    @Test
    public void testGetFeatureNumberMatchedWithGeomComplexFilterWithPagination() throws Exception {
        if (GeoPackageUtil.isGeopkgTest()) {
            return;
        }
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter= intersects(gsml:shape, buffer(POLYGON((-1.3 52.5,-1.3 52.6,-1.2 52.6,-1.2 52.5,-1.3 52.5)),100)) AND gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gml:description LIKE %27%25Olivine%20basalt%2C%20tuff%25%27&startIndex=1");
        this.assertNumberMathcedAndNumberReturned(doc, 3, 2);
    }

    @Test
    public void testGetFeatureNumberMatchedWithGeomComplexFilterManyAND() throws Exception {
        if (GeoPackageUtil.isGeopkgTest()) {
            return;
        }
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml32&request=GetFeature&typeNames=gsml:MappedFeature&cql_filter= intersects(gsml:shape, buffer(POLYGON((-1.3 52.5,-1.3 52.6,-1.2 52.6,-1.2 52.5,-1.3 52.5)),100)) AND gsml:MappedFeature.gsml:specification.gsml:GeologicUnit.gml:description LIKE %27%25Olivine%20basalt%2C%20tuff%25%27 AND gsml:MappedFeature.gml:name = 'GUNTHORPE FORMATION'");
        this.assertNumberMathcedAndNumberReturned(doc, 1, 1);
    }

    @Test
    public void testGetMappedNumberMatchedWithIdFilter() {
        Document doc = this.getAsDOM("ows?service=WFS&version=2.0.0&outputFormat=gml3&request=GetFeature&typeNames=gsml:MappedFeature&resulttype=hits&&cql_filter=IN('mf1')");
        LOGGER.info("WFS GetFeature, typename=gsml:MappedFeature response:\n" + this.prettyString(doc));
        this.assertNumberMathcedAndNumberReturned(doc, 1, 0);
    }

    private void assertNumberMathcedAndNumberReturned(Document doc, int numberMatched, int numberReturned) {
        this.assertXpathEvaluatesTo(String.valueOf(numberMatched), "/wfs:FeatureCollection/@numberMatched", doc);
        this.assertXpathEvaluatesTo(String.valueOf(numberReturned), "/wfs:FeatureCollection/@numberReturned", doc);
    }
}

