/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.Gsml32BoreholeMockData;
import org.geoserver.test.StationsMockData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public final class GeoJsonOutputFormatWfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected AbstractAppSchemaMockData createTestData() {
        return new MockData();
    }

    @Test
    public void testGetGeoJsonResponseWfs11() throws Exception {
        JSON response = this.getAsJSON("wfs?request=GetFeature&version=1.1.0&typename=st_gml31:Station_gml31&outputFormat=application/json");
        this.checkStation1Exists(response);
    }

    @Test
    public void testGetGeoJsonResponseWfs20() throws Exception {
        JSON response = this.getAsJSON("wfs?request=GetFeature&version=2.0&typenames=st_gml32:Station_gml32&outputFormat=application/json");
        this.checkStation1Exists(response);
        JSONObject station = this.getFeaturePropertiesById(response, "st.2");
        MatcherAssert.assertThat((Object)station, (Matcher)CoreMatchers.notNullValue());
        JSONObject contact = station.getJSONObject("contact");
        MatcherAssert.assertThat((Object)contact.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)contact.get("@mail"), (Matcher)CoreMatchers.is((Object)"st2@stations.org"));
        JSONObject phone = contact.getJSONObject("phone");
        MatcherAssert.assertThat((Object)phone.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertFalse((boolean)phone.has("value"));
        MatcherAssert.assertThat((Object)phone.get("@timeZone"), (Matcher)CoreMatchers.is((Object)""));
        JSONObject featureLinkA = station.getJSONArray("featureLinkA").getJSONObject(0);
        Assert.assertEquals((Object)"http://www.geoserver.org/featureA", (Object)featureLinkA.getString("@href"));
        JSONObject featureLinkB = station.getJSONArray("featureLinkB").getJSONObject(0);
        Assert.assertEquals((Object)"http://www.geoserver.org/featureB", (Object)featureLinkB.getString("@href"));
        JSONObject featureLinkC = station.getJSONObject("featureLinkC");
        Assert.assertEquals((Object)"http://www.geoserver.org/featureC", (Object)featureLinkC.getString("@href"));
    }

    @Test
    public void testGetGeoJsonResponseWfs20WithNullGeometryAttribute() throws Exception {
        JSON response = this.getAsJSON("wfs?request=GetFeature&version=2.0&typenames=st_gml32:Station_gml32&outputFormat=application/json");
        this.checkStation1Exists(response);
        JSONObject station3 = (JSONObject)((JSONObject)response).getJSONArray("features").get(2);
        JSONObject geometry = station3.getJSONObject("geometry");
        Assert.assertTrue((boolean)station3.containsKey((Object)"geometry"));
        Assert.assertTrue((boolean)geometry.isNullObject());
    }

    private void checkStation1Exists(JSON geoJson) {
        JSONObject station = this.getFeaturePropertiesById(geoJson, "st.1");
        MatcherAssert.assertThat((Object)station, (Matcher)CoreMatchers.notNullValue());
        JSONObject name = station.getJSONObject("name");
        MatcherAssert.assertThat((Object)name.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)name.get("value"), (Matcher)CoreMatchers.is((Object)"station1"));
        MatcherAssert.assertThat((Object)name.get("@code"), (Matcher)CoreMatchers.is((Object)"st1"));
        JSONObject contact = station.getJSONObject("contact");
        MatcherAssert.assertThat((Object)contact.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)contact.get("@mail"), (Matcher)CoreMatchers.is((Object)"st1@stations.org"));
        JSONObject phone = contact.getJSONObject("phone");
        MatcherAssert.assertThat((Object)phone.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)phone.get("value"), (Matcher)CoreMatchers.is((Object)"95482156"));
        MatcherAssert.assertThat((Object)phone.get("@timeZone"), (Matcher)CoreMatchers.is((Object)"CET"));
        JSONArray measurements = station.getJSONArray("measurements");
        MatcherAssert.assertThat((Object)measurements.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)measurements.getJSONObject(0).getString("@href"), (Matcher)CoreMatchers.containsString((String)"http://www.stations.org/ms."));
        MatcherAssert.assertThat((Object)measurements.getJSONObject(1).getString("@href"), (Matcher)CoreMatchers.containsString((String)"http://www.stations.org/ms."));
    }

    @Test
    public void testSimpleContentTimeEncoding() throws Exception {
        String path = "wfs?request=GetFeature&typename=gsmlbh:Borehole&outputFormat=json";
        JSON json = this.getAsJSON(path);
        JSONObject properties = this.getFeaturePropertiesById(json, "borehole.GA.17322");
        MatcherAssert.assertThat((Object)properties, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        JSONObject timeInstant = this.getNestedObject(properties, "relatedSamplingFeature", "relatedSamplingFeature", "properties", "samplingTime", "TimeInstant");
        MatcherAssert.assertThat((Object)timeInstant.getString("timePosition"), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)"2014-07-02T00:00:00Z"), CoreMatchers.is((Object)"2014-07-02Z")}));
    }

    @Test
    public void testOneDimensionalEncoding() throws Exception {
        String path = "wfs?request=GetFeature&typename=gsmlbh:Borehole&outputFormat=json";
        JSON json = this.getAsJSON(path);
        JSONObject properties = this.getFeaturePropertiesById(json, "borehole.GA.17322");
        MatcherAssert.assertThat((Object)properties, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        JSONObject samplingLocation = this.getNestedObject(properties, "relatedSamplingFeature", "relatedSamplingFeature", "geometry");
        JSONArray coordinates = samplingLocation.getJSONArray("coordinates");
        MatcherAssert.assertThat((Object)coordinates.size(), (Matcher)CoreMatchers.is((Object)2));
        JSONArray c1 = coordinates.getJSONArray(0);
        MatcherAssert.assertThat((Object)c1.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertEquals((double)57.9, (double)c1.getDouble(0), (double)0.1);
        JSONArray c2 = coordinates.getJSONArray(1);
        MatcherAssert.assertThat((Object)c2.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertEquals((double)66.5, (double)c2.getDouble(0), (double)0.1);
    }

    @Test
    public void testNestedFeatureEncoding() throws Exception {
        String path = "wfs?request=GetFeature&typename=gsml:Borehole&outputFormat=json";
        JSON json = this.getAsJSON(path);
        JSONObject properties = this.getFeaturePropertiesById(json, "BOREHOLE.WTB5");
        MatcherAssert.assertThat((Object)properties, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((Object)"Borehole", (Object)properties.getString("@featureType"));
        JSONObject collar = this.getNestedObject(properties, "collarLocation");
        Assert.assertEquals((Object)"BOREHOLE.COLLAR.WTB5", (Object)collar.getString("id"));
        Assert.assertEquals((Object)"Feature", (Object)collar.getString("type"));
        JSONObject collarGeometry = collar.getJSONObject("geometry");
        JSONArray coordinates = collarGeometry.getJSONArray("coordinates");
        MatcherAssert.assertThat((Object)coordinates.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertEquals((double)-28.4139, (double)coordinates.getDouble(0), (double)0.1);
        Assert.assertEquals((double)121.142, (double)coordinates.getDouble(1), (double)0.1);
        JSONObject collarProperties = collar.getJSONObject("properties");
        Assert.assertEquals((Object)"BoreholeCollar", (Object)collarProperties.getString("@featureType"));
        JSONObject indexData = properties.getJSONObject("indexData");
        Assert.assertEquals((Object)"BoreholeDetails", (Object)indexData.getString("@dataType"));
        Assert.assertEquals((Object)"BoundingShape", (Object)indexData.getJSONObject("coredInterval").getString("@dataType"));
        JSONArray sampledFeatures = properties.getJSONArray("sampledFeature");
        Assert.assertEquals((long)1L, (long)sampledFeatures.size());
        JSONObject sampledFeature = sampledFeatures.getJSONObject(0);
        Assert.assertEquals((Object)"http://www.opengis.net/def/nil/OGC/0/unknown", (Object)sampledFeature.getString("@href"));
        Assert.assertEquals((Object)"http://www.geosciml.org/geosciml/2.0/doc/GeoSciML/GeologicUnit/GeologicUnit.html", (Object)sampledFeature.getString("@role"));
        Assert.assertEquals((Object)"unknown", (Object)sampledFeature.getString("@title"));
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace("st_gml31", "http://www.stations_gml31.org/1.0");
            this.putNamespace("ms_gml31", "http://www.measurements_gml31.org/1.0");
            this.putNamespace("st_gml32", "http://www.stations_gml32.org/1.0");
            this.putNamespace("ms_gml32", "http://www.measurements_gml32.org/1.0");
            this.addAppSchemaFeatureType("st_gml31", "gml31", "Station_gml31", "/test-data/stations/geoJson/stations.xml", MockData.getGml31StandardParamaters(), "/test-data/stations/geoJson/measurements.xml", "/test-data/stations/geoJson/stations.xsd", "/test-data/stations/geoJson/stations.properties", "/test-data/stations/geoJson/measurements.properties");
            this.addAppSchemaFeatureType("st_gml32", "gml32", "Station_gml32", "/test-data/stations/geoJson/stations.xml", MockData.getGml32StandardParamaters(), "/test-data/stations/geoJson/measurements.xml", "/test-data/stations/geoJson/stations.xsd", "/test-data/stations/geoJson/stations.properties", "/test-data/stations/geoJson/measurements.properties");
            new Gsml32BoreholeMockData().getNamespaces().forEach((k, v) -> this.putNamespace((String)k, (String)v));
            this.addFeatureType("gsmlbh", "Borehole", "Gsml32Borehole.xml", "Gsml32Borehole.properties");
            this.putNamespace("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0");
            this.addFeatureType("gsml", "Borehole", "Borehole.xml", "Borehole.properties");
        }
    }
}

