/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.FeatureChainingMockData;
import org.geoserver.test.MockConnectionLifecycleListener;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.joining.JoiningNestedAttributeMapping;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureIterator;
import org.geotools.jdbc.JDBCDataStore;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class FeatureChainingSharedConnectionTest
extends AbstractAppSchemaTestSupport {
    private int nestedFeaturesCount;
    private Transaction mfTransaction;
    private Transaction guTransaction;
    private JDBCDataStore mfSourceDataStore;
    private JDBCDataStore guSourceDataStore;

    @Override
    protected FeatureChainingMockData createTestData() {
        return new FeatureChainingMockData();
    }

    @Before
    public void setUp() {
        this.nestedFeaturesCount = 0;
        this.mfTransaction = null;
        this.guTransaction = null;
        this.mfSourceDataStore = null;
        this.guSourceDataStore = null;
    }

    @Test
    public void testSharedConnection() throws Exception {
        MockConnectionLifecycleListener connListener = new MockConnectionLifecycleListener();
        FeatureTypeInfo mfTypeInfo = this.getCatalog().getFeatureTypeByName("gsml", "MappedFeature");
        Assert.assertNotNull((Object)mfTypeInfo);
        FeatureTypeInfo guTypeInfo = this.getCatalog().getFeatureTypeByName("gsml", "GeologicUnit");
        Assert.assertNotNull((Object)guTypeInfo);
        FeatureSource fs = mfTypeInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        MappingFeatureSource mfFs = this.unwrap(fs);
        FeatureSource mfSourceFs = mfFs.getMapping().getSource();
        fs = guTypeInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        MappingFeatureSource guFs = this.unwrap(fs);
        FeatureSource guSourceFs = guFs.getMapping().getSource();
        Assume.assumeTrue((mfSourceFs.getDataStore() instanceof JDBCDataStore && guSourceFs.getDataStore() instanceof JDBCDataStore && AppSchemaDataAccessConfigurator.isJoining() ? 1 : 0) != 0);
        this.mfSourceDataStore = (JDBCDataStore)mfSourceFs.getDataStore();
        this.guSourceDataStore = (JDBCDataStore)guSourceFs.getDataStore();
        try (FeatureIterator fIt = mfFs.getFeatures().features();){
            Assert.assertTrue((boolean)fIt.hasNext());
            Assert.assertNotNull((Object)fIt.next());
        }
        this.mfSourceDataStore.getConnectionLifecycleListeners().add(connListener);
        this.guSourceDataStore.getConnectionLifecycleListeners().add(connListener);
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware();
        ff.setNamepaceContext(mfFs.getMapping().getNamespaces());
        PropertyIsLike like = ff.like((Expression)ff.property("gsml:specification/gsml:GeologicUnit/gml:description"), "*sedimentary*");
        try (DataAccessMappingFeatureIterator mappingIt = (DataAccessMappingFeatureIterator)mfFs.getFeatures((Filter)like).features();){
            Assert.assertTrue((boolean)mappingIt.hasNext());
            Feature f = mappingIt.next();
            Assert.assertNotNull((Object)f);
            FeatureSource mappedSource = mappingIt.getMappedSource();
            Assert.assertSame((Object)mappedSource.getDataStore(), (Object)this.mfSourceDataStore);
            Assert.assertNotNull((Object)mappingIt.getTransaction());
            this.mfTransaction = mappingIt.getTransaction();
            this.testSharedConnectionRecursively(mfFs.getMapping(), mappingIt, (DataAccess)this.mfSourceDataStore, this.mfTransaction);
        }
        Assert.assertEquals((long)2L, (long)connListener.actionCountByDataStore.size());
        Assert.assertTrue((boolean)connListener.actionCountByDataStore.containsKey(this.mfSourceDataStore));
        Assert.assertEquals((long)1L, (long)connListener.actionCountByDataStore.get((Object)this.mfSourceDataStore).borrowCount);
        Assert.assertEquals((long)1L, (long)connListener.actionCountByDataStore.get((Object)this.mfSourceDataStore).releaseCount);
        Assert.assertTrue((boolean)connListener.actionCountByDataStore.containsKey(this.guSourceDataStore));
        Assert.assertEquals((long)1L, (long)connListener.actionCountByDataStore.get((Object)this.guSourceDataStore).borrowCount);
        Assert.assertEquals((long)1L, (long)connListener.actionCountByDataStore.get((Object)this.guSourceDataStore).releaseCount);
        Assert.assertEquals((long)8L, (long)this.nestedFeaturesCount);
    }

    private MappingFeatureSource unwrap(FeatureSource fs) {
        MappingFeatureSource mfFs;
        if (fs instanceof DecoratingFeatureSource) {
            mfFs = (MappingFeatureSource)((DecoratingFeatureSource)fs).unwrap(MappingFeatureSource.class);
        } else {
            Assert.assertTrue((boolean)(fs instanceof MappingFeatureSource));
            mfFs = (MappingFeatureSource)fs;
        }
        return mfFs;
    }

    private void testSharedConnectionRecursively(FeatureTypeMapping mapping, DataAccessMappingFeatureIterator mappingIt, DataAccess parentDataStore, Transaction parentTx) throws IOException {
        List attrs = mapping.getAttributeMappings();
        Assert.assertNotNull((Object)attrs);
        Assert.assertFalse((boolean)attrs.isEmpty());
        for (AttributeMapping attr : attrs) {
            if (!(attr instanceof JoiningNestedAttributeMapping)) continue;
            ++this.nestedFeaturesCount;
            JoiningNestedAttributeMapping joiningNestedAttr = (JoiningNestedAttributeMapping)attr;
            Map nestedFeatureIterators = joiningNestedAttr.getNestedFeatureIterators((Object)mappingIt);
            Assert.assertNotNull((Object)nestedFeatureIterators);
            if (nestedFeatureIterators.isEmpty()) continue;
            Assert.assertEquals((long)1L, (long)nestedFeatureIterators.size());
            FeatureTypeMapping nestedMapping = joiningNestedAttr.getFeatureTypeMapping(null);
            DataAccessMappingFeatureIterator nestedIt = (DataAccessMappingFeatureIterator)nestedFeatureIterators.values().iterator().next();
            Transaction expectedTx = parentTx;
            DataAccess expectedDataStore = parentDataStore;
            String nestedFeatureName = nestedMapping.getTargetFeature().getLocalName();
            if (nestedFeatureName.equals("GeologicUnit")) {
                expectedDataStore = this.guSourceDataStore;
                if (this.guTransaction == null) {
                    this.guTransaction = nestedIt.getTransaction();
                }
                expectedTx = this.guTransaction;
            } else if (nestedFeatureName.equals("MappedFeature")) {
                expectedDataStore = this.mfSourceDataStore;
                if (this.mfTransaction == null) {
                    this.mfTransaction = nestedIt.getTransaction();
                }
                expectedTx = this.mfTransaction;
            }
            FeatureSource nestedMappedSource = nestedIt.getMappedSource();
            Assert.assertEquals((Object)expectedDataStore, (Object)nestedMappedSource.getDataStore());
            Assert.assertEquals((Object)expectedTx, (Object)nestedIt.getTransaction());
            this.testSharedConnectionRecursively(nestedMapping, nestedIt, expectedDataStore, expectedTx);
        }
    }
}

