/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.DuplicateTypeMockData;
import org.junit.Test;
import org.w3c.dom.Document;

public class DuplicateTypeTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected DuplicateTypeMockData createTestData() {
        return new DuplicateTypeMockData();
    }

    @Test
    public void testGetDuplicateMappedFeature() throws Exception {
        String request = "GetFeature&version=1.1.0&typename=gsml:DuplicateMappedFeature";
        Document doc = this.getAsDOM("wfs?request=" + request);
        LOGGER.info("WFS " + request + " response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("4", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(4, "//gsml:DuplicateMappedFeature", doc);
        this.assertXpathEvaluatesTo("unknown", "(//gsml:DuplicateMappedFeature)[1]/gsml:positionalAccuracy/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("", "(//gsml:DuplicateMappedFeature)[1]/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue", doc);
    }

    @Test
    public void testGetMappedFeature() throws Exception {
        String request = "GetFeature&version=1.1.0&typename=gsml:MappedFeature";
        Document doc = this.getAsDOM("wfs?request=" + request);
        LOGGER.info("WFS " + request + " response:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("5", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(5, "//gsml:MappedFeature", doc);
        this.assertXpathEvaluatesTo("", "(//gsml:MappedFeature)[1]/gsml:positionalAccuracy/gsml:CGI_TermValue/gsml:value", doc);
        this.assertXpathEvaluatesTo("200.0", "(//gsml:MappedFeature)[1]/gsml:positionalAccuracy/gsml:CGI_NumericValue/gsml:principalValue", doc);
    }
}

