/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.ArrayList;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.DuplicatePropertiesMockData;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class DuplicatePropertiesWfsTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected DuplicatePropertiesMockData createTestData() {
        return new DuplicatePropertiesMockData();
    }

    @Test
    public void testGetCapabilities() {
        Document doc = this.getAsDOM("wfs?request=GetCapabilities&version=1.1.0");
        LOGGER.info("WFS GetCapabilities response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:WFS_Capabilities", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathCount(1, "//wfs:FeatureType", doc);
        ArrayList<String> featureTypeNames = new ArrayList<String>(1);
        featureTypeNames.add(this.evaluate("//wfs:FeatureType[1]/wfs:Name", doc));
        Assert.assertTrue((boolean)featureTypeNames.contains("ex:ERM"));
    }

    @Test
    public void testGetFeature() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=ex:ERM");
        LOGGER.info("WFS GetFeature&typename=ex:ERM response:\n" + this.prettyString(doc));
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        this.assertXpathCount(2, "//ex:purpose", doc);
        this.assertXpathEvaluatesTo("instance", "//ex:material/ex:RockMaterial/ex:purpose", doc);
    }
}

