/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class DefaultGeometryTest
extends AbstractAppSchemaTestSupport {
    private static final String GML31_PREFIX = "gml31";
    private static final String GML32_PREFIX = "gml32";
    private static final String XPATH_BASE_GML31 = "/wfs:FeatureCollection/gml:featureMember";
    private static final String XPATH_BASE_GML32 = "/wfs:FeatureCollection/wfs:member";
    private static final String STATION_FEATURE = "st_${GML_PREFIX}:Station_${GML_PREFIX}";
    private static final String STATION_WITH_MEASUREMENTS_FEATURE = "st_${GML_PREFIX}:StationWithMeasurements_${GML_PREFIX}";
    private static final String XPATH_STATION = "/st_${GML_PREFIX}:Station_${GML_PREFIX}";
    private static final String XPATH_STATION_FAKE_GEOM = "/st_${GML_PREFIX}:Station_${GML_PREFIX}/st_${GML_PREFIX}:__DEFAULT_GEOMETRY__";
    private static final String XPATH_STATION_GEOM = "/st_${GML_PREFIX}:Station_${GML_PREFIX}/st_${GML_PREFIX}:location/st_${GML_PREFIX}:position/gml:Point";
    private static final String XPATH_STATION_WITH_MEASUREMENTS = "/st_${GML_PREFIX}:StationWithMeasurements_${GML_PREFIX}";
    private static final String XPATH_STATION_WITH_MEASUREMENTS_FAKE_GEOM = "/st_${GML_PREFIX}:StationWithMeasurements_${GML_PREFIX}/st_${GML_PREFIX}:__DEFAULT_GEOMETRY__";
    private static final String XPATH_STATION_WITH_MEASUREMENTS_GEOM = "/st_${GML_PREFIX}:StationWithMeasurements_${GML_PREFIX}/st_${GML_PREFIX}:measurements/ms_${GML_PREFIX}:Measurement_${GML_PREFIX}/ms_${GML_PREFIX}:sampledArea/ms_${GML_PREFIX}:SampledArea/ms_${GML_PREFIX}:geometry";
    private XpathEngine WFS11_XPATH_ENGINE;
    private XpathEngine WFS20_XPATH_ENGINE;

    @Before
    public void beforeTest() {
        this.WFS11_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "wfs", "http://www.opengis.net/wfs", "gml", "http://www.opengis.net/gml");
        this.WFS20_XPATH_ENGINE = StationsMockData.buildXpathEngine(this.getTestData().getNamespaces(), "ows", "http://www.opengis.net/ows/1.1", "wfs", "http://www.opengis.net/wfs/2.0", "gml", "http://www.opengis.net/gml/3.2");
    }

    @Override
    protected StationsMockData createTestData() {
        MockData mockData = new MockData();
        mockData.addStyle("Default_Point", "styles/default_point.sld");
        mockData.addStyle("Default_Polygon", "styles/default_polygon.sld");
        return mockData;
    }

    @Test
    public void testWfs11GetFeatureDefaultGeometry() throws Exception {
        this.testWfsGetFeature("1.1.0", STATION_FEATURE, XPATH_STATION, XPATH_STATION_FAKE_GEOM, XPATH_STATION_GEOM);
        this.testWfsGetFeature("1.1.0", STATION_WITH_MEASUREMENTS_FEATURE, XPATH_STATION_WITH_MEASUREMENTS, XPATH_STATION_WITH_MEASUREMENTS_FAKE_GEOM, XPATH_STATION_WITH_MEASUREMENTS_GEOM);
    }

    @Test
    public void testWfs20GetFeatureDefaultGeometry() throws Exception {
        this.testWfsGetFeature("2.0", STATION_FEATURE, XPATH_STATION, XPATH_STATION_FAKE_GEOM, XPATH_STATION_GEOM);
        this.testWfsGetFeature("2.0", STATION_WITH_MEASUREMENTS_FEATURE, XPATH_STATION_WITH_MEASUREMENTS, XPATH_STATION_WITH_MEASUREMENTS_FAKE_GEOM, XPATH_STATION_WITH_MEASUREMENTS_GEOM);
    }

    protected void testWfsGetFeature(String wfsVersion, String featureType, String xpathFeature, String xpathFakeGeom, String xpathActualGeom) throws Exception {
        XpathEngine xpathEngine;
        String xpathBase;
        String gmlPrefix;
        if (wfsVersion.equals("2.0")) {
            gmlPrefix = GML32_PREFIX;
            xpathBase = XPATH_BASE_GML32;
            xpathEngine = this.WFS20_XPATH_ENGINE;
        } else {
            gmlPrefix = GML31_PREFIX;
            xpathBase = XPATH_BASE_GML31;
            xpathEngine = this.WFS11_XPATH_ENGINE;
        }
        String getFeatureUrl = this.buildGetFeatureUrl(wfsVersion, featureType.replace("${GML_PREFIX}", gmlPrefix));
        Document document = this.getAsDOM(getFeatureUrl);
        String xpath = null;
        try {
            xpath = xpathBase + xpathFeature.replace("${GML_PREFIX}", gmlPrefix);
            Assert.assertEquals((long)3L, (long)xpathEngine.getMatchingNodes(xpath, document).getLength());
            xpath = xpathBase + xpathActualGeom.replace("${GML_PREFIX}", gmlPrefix);
            Assert.assertEquals((long)3L, (long)xpathEngine.getMatchingNodes(xpath, document).getLength());
            xpath = xpathBase + xpathFakeGeom.replace("${GML_PREFIX}", gmlPrefix);
            Assert.assertEquals((long)0L, (long)xpathEngine.getMatchingNodes(xpath, document).getLength());
        }
        catch (Exception exception) {
            throw new RuntimeException("Error evaluating xpath.", exception);
        }
    }

    @Test
    public void testWmsGetMapDefaultGeometry() throws IOException {
        BufferedImage imageBuffer;
        String layer = STATION_FEATURE.replace("${GML_PREFIX}", GML31_PREFIX);
        try (InputStream is = this.getBinary(this.buildGetMapUrl(layer, "Default_Point"));){
            imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap nested default geom", imageBuffer, Color.WHITE);
        }
        layer = STATION_FEATURE.replace("${GML_PREFIX}", GML32_PREFIX);
        is = this.getBinary(this.buildGetMapUrl("st_gml32:Station_gml32", "Default_Point"));
        try {
            imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap nested default geom", imageBuffer, Color.WHITE);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Test
    public void testWmsGetMapDefaultGeometryInChainedFeature() throws IOException {
        BufferedImage imageBuffer;
        String layer = STATION_WITH_MEASUREMENTS_FEATURE.replace("${GML_PREFIX}", GML31_PREFIX);
        try (InputStream is = this.getBinary(this.buildGetMapUrl(layer, "Default_Polygon"));){
            imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap nested default geom feature chaining", imageBuffer, Color.WHITE);
        }
        layer = STATION_WITH_MEASUREMENTS_FEATURE.replace("${GML_PREFIX}", GML32_PREFIX);
        is = this.getBinary(this.buildGetMapUrl(layer, "Default_Polygon"));
        try {
            imageBuffer = ImageIO.read(is);
            this.assertNotBlank("app-schema test getmap nested default geom feature chaining", imageBuffer, Color.WHITE);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Test
    public void testWmsGetFeatureInfoDefaultGeometry() throws Exception {
        this.testWmsGetFeatureInfo(STATION_FEATURE, "Default_Point", 89, 114, XPATH_STATION, XPATH_STATION_FAKE_GEOM, XPATH_STATION_GEOM);
    }

    @Test
    public void testWmsGetFeatureInfoDefaultGeometryInChainedFeature() throws Exception {
        this.testWmsGetFeatureInfo(STATION_WITH_MEASUREMENTS_FEATURE, "Default_Polygon", 125, 150, XPATH_STATION_WITH_MEASUREMENTS, XPATH_STATION_WITH_MEASUREMENTS_FAKE_GEOM, XPATH_STATION_WITH_MEASUREMENTS_GEOM);
    }

    protected void testWmsGetFeatureInfo(String layer, String style, int x, int y, String xpathFeature, String xpathFakeGeom, String xpathActualGeom) throws Exception {
        XpathEngine xpathEngine = this.WFS11_XPATH_ENGINE;
        String getFeatureUrl = this.buildGetFeatureInfoUrl(layer.replace("${GML_PREFIX}", GML31_PREFIX), style, "application/vnd.ogc.gml/3.1.1", x, y);
        Document document = this.getAsDOM(getFeatureUrl);
        String xpath = null;
        try {
            xpath = XPATH_BASE_GML31 + xpathFeature.replace("${GML_PREFIX}", GML31_PREFIX);
            Assert.assertEquals((long)1L, (long)xpathEngine.getMatchingNodes(xpath, document).getLength());
            xpath = XPATH_BASE_GML31 + xpathActualGeom.replace("${GML_PREFIX}", GML31_PREFIX);
            Assert.assertEquals((long)1L, (long)xpathEngine.getMatchingNodes(xpath, document).getLength());
            xpath = XPATH_BASE_GML31 + xpathFakeGeom.replace("${GML_PREFIX}", GML31_PREFIX);
            Assert.assertEquals((long)0L, (long)xpathEngine.getMatchingNodes(xpath, document).getLength());
        }
        catch (Exception exception) {
            throw new RuntimeException("Error evaluating xpath.", exception);
        }
    }

    public String buildGetFeatureUrl(String wfsVersion, String featureType) {
        String getFeatureUrl = "wfs?request=GetFeature" + "&" + "version=" + wfsVersion + "&" + "typename=" + featureType;
        return getFeatureUrl;
    }

    public String buildGetMapUrl(String layers, String style) {
        String getMapUrl = "wms?request=GetMap" + "&" + "SRS=EPSG:4326" + "&" + "layers=" + layers + "&" + "styles=" + style + "&" + "BBOX=-10,-10,10,10" + "&" + "WIDTH=256" + "&" + "HEIGHT=256" + "&" + "FORMAT=image/png";
        return getMapUrl;
    }

    public String buildGetFeatureInfoUrl(String layers, String style, String format, int x, int y) {
        String getInfoUrl = "wms?request=GetFeatureInfo" + "&" + "SRS=EPSG:4326" + "&" + "BBOX=-10,-10,10,10" + "&" + "STYLES=" + style + "&" + "LAYERS=" + layers + "&" + "QUERY_LAYERS=" + layers + "&" + "X=" + x + "&" + "Y=" + y + "&" + "WIDTH=256" + "&" + "HEIGHT=256" + "&" + "INFO_FORMAT=" + format;
        return getInfoUrl;
    }

    private static final class MockData
    extends StationsMockData {
        private MockData() {
        }

        @Override
        public void addContent() {
            this.putNamespace("st_gml31", "http://www.stations_gml31.org/1.0");
            this.putNamespace("ms_gml31", "http://www.measurements_gml31.org/1.0");
            this.putNamespace("st_gml32", "http://www.stations_gml32.org/1.0");
            this.putNamespace("ms_gml32", "http://www.measurements_gml32.org/1.0");
            HashMap<String, String> gml31Parameters = new HashMap<String, String>();
            gml31Parameters.put("GML_PREFIX", DefaultGeometryTest.GML31_PREFIX);
            gml31Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml");
            gml31Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.1.1/base/gml.xsd");
            this.addStationFeatureType("st_gml31", DefaultGeometryTest.GML31_PREFIX, "Station", "stations", "defaultGeometry/stations1.xml", gml31Parameters);
            this.addStationFeatureType("st_gml31", DefaultGeometryTest.GML31_PREFIX, "StationWithMeasurements", "stations", "defaultGeometry/stations2.xml", "measurements", "defaultGeometry/measurements.xml", gml31Parameters);
            this.addMeasurementFeatureType("ms_gml31", DefaultGeometryTest.GML31_PREFIX, "measurements", "defaultGeometry/measurements.xml", gml31Parameters);
            HashMap<String, String> gml32Parameters = new HashMap<String, String>();
            gml32Parameters.put("GML_PREFIX", DefaultGeometryTest.GML32_PREFIX);
            gml32Parameters.put("GML_NAMESPACE", "http://www.opengis.net/gml/3.2");
            gml32Parameters.put("GML_LOCATION", "http://schemas.opengis.net/gml/3.2.1/gml.xsd");
            this.addStationFeatureType("st_gml32", DefaultGeometryTest.GML32_PREFIX, "Station", "stations", "defaultGeometry/stations1.xml", gml32Parameters);
            this.addStationFeatureType("st_gml32", DefaultGeometryTest.GML32_PREFIX, "StationWithMeasurements", "stations", "defaultGeometry/stations2.xml", "measurements", "defaultGeometry/measurements.xml", gml32Parameters);
            this.addMeasurementFeatureType("ms_gml32", DefaultGeometryTest.GML32_PREFIX, "measurements", "defaultGeometry/measurements.xml", gml32Parameters);
        }

        protected void addStationFeatureType(String namespacePrefix, String gmlPrefix, String featureType, String mappingsName, String mappingsPath, Map<String, String> parameters) {
            File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
            gmlDirectory.mkdirs();
            File stationsMappings = new File(gmlDirectory, String.format("%s_%s.xml", mappingsName, gmlPrefix));
            File stationsProperties = new File(gmlDirectory, String.format("stations_%s.properties", gmlPrefix));
            File stationsSchema = new File(gmlDirectory, String.format("stations_%s.xsd", gmlPrefix));
            MockData.substituteParameters("/test-data/stations/" + mappingsPath, parameters, stationsMappings);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/stations.properties", parameters, stationsProperties);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/stations.xsd", parameters, stationsSchema);
            this.addFeatureType(namespacePrefix, String.format("%s_%s", featureType, gmlPrefix), stationsMappings.getAbsolutePath(), stationsProperties.getAbsolutePath(), stationsSchema.getAbsolutePath());
        }

        protected void addStationFeatureType(String namespacePrefix, String gmlPrefix, String stationsFeatureType, String stationsMappingsName, String stationsMappingsPath, String measurementsMappingsName, String measurementsMappingsPath, Map<String, String> parameters) {
            File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
            gmlDirectory.mkdirs();
            File stationsMappings = new File(gmlDirectory, String.format("%s_%s.xml", stationsMappingsName, gmlPrefix));
            File stationsProperties = new File(gmlDirectory, String.format("stations_%s.properties", gmlPrefix));
            File stationsSchema = new File(gmlDirectory, String.format("stations_%s.xsd", gmlPrefix));
            File measurementsSchema = new File(gmlDirectory, String.format("measurements_%s.xsd", gmlPrefix));
            MockData.substituteParameters("/test-data/stations/" + stationsMappingsPath, parameters, stationsMappings);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/stations.properties", parameters, stationsProperties);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/stations.xsd", parameters, stationsSchema);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/measurements.xsd", parameters, measurementsSchema);
            this.addFeatureType(namespacePrefix, String.format("%s_%s", stationsFeatureType, gmlPrefix), stationsMappings.getAbsolutePath(), stationsProperties.getAbsolutePath(), stationsSchema.getAbsolutePath(), measurementsSchema.getAbsolutePath());
        }

        @Override
        protected void addMeasurementFeatureType(String namespacePrefix, String gmlPrefix, String mappingsName, String mappingsPath, Map<String, String> parameters) {
            File gmlDirectory = this.getDirectoryForGmlPrefix(gmlPrefix);
            gmlDirectory.mkdirs();
            File measurementsMappings = new File(gmlDirectory, String.format("%s_%s.xml", mappingsName, gmlPrefix));
            File measurementsProperties = new File(gmlDirectory, String.format("measurements_%s.properties", gmlPrefix));
            File measurementsSchema = new File(gmlDirectory, String.format("measurements_%s.xsd", gmlPrefix));
            MockData.substituteParameters("/test-data/stations/" + mappingsPath, parameters, measurementsMappings);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/measurements.properties", parameters, measurementsProperties);
            MockData.substituteParameters("/test-data/stations/defaultGeometry/measurements.xsd", parameters, measurementsSchema);
            this.addFeatureType(namespacePrefix, String.format("Measurement_%s", gmlPrefix), measurementsMappings.getAbsolutePath(), measurementsProperties.getAbsolutePath(), measurementsSchema.getAbsolutePath());
        }
    }
}

