/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.util.Optional;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.test.StationsAppSchemaTestSupport;
import org.geoserver.test.StationsMockData;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.junit.Test;
import org.w3c.dom.Document;

public class CoordinatesFormattingTest
extends StationsAppSchemaTestSupport {
    @Test
    public void testCoordinateFormatWfs11() throws Exception {
        this.enableCoordinatesFormattingGml31();
        Document doc = this.getAsDOM("st_gml31/wfs?request=GetFeature&version=1.1.0&typename=st_gml31:Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, doc, 1, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id=\"st.1\"]/st_gml31:location/gml:Point/gml:pos[text()=\"1.00000000 -1.00000000\"]");
        this.checkCount(this.WFS11_XPATH_ENGINE, doc, 1, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id=\"st.2\"]/st_gml31:location/gml:Point/gml:pos[text()=\"0.00000010 -0.00000010\"]");
    }

    @Test
    public void testCoordinateFormatDisabledWfs11() throws Exception {
        this.disableCoordinatesFormattingGml31();
        Document doc = this.getAsDOM("st_gml31/wfs?request=GetFeature&version=1.1.0&typename=st_gml31:Station_gml31");
        this.checkCount(this.WFS11_XPATH_ENGINE, doc, 1, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id=\"st.1\"]/st_gml31:location/gml:Point/gml:pos[text()=\"1 -1\"]");
        this.checkCount(this.WFS11_XPATH_ENGINE, doc, 1, "//wfs:FeatureCollection/gml:featureMember/st_gml31:Station_gml31[@gml:id=\"st.2\"]/st_gml31:location/gml:Point/gml:pos[text()=\"1.0E-7 -1.0E-7\"]");
    }

    @Test
    public void testCoordinateFormatWfs20() throws Exception {
        this.enableCoordinatesFormattingGml32();
        Document document = this.getAsDOM("wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id=\"st.1\"]/st_gml32:location/gml:Point/gml:pos[text()=\"1.00000000 -1.00000000\"]");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id=\"st.2\"]/st_gml32:location/gml:Point/gml:pos[text()=\"0.00000010 -0.00000010\"]");
    }

    @Test
    public void testCoordinateFormatDisabledWfs20() throws Exception {
        this.disableCoordinatesFormattingGml32();
        Document document = this.getAsDOM("wfs?request=GetFeature&version=2.0&typename=st_gml32:Station_gml32");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id=\"st.1\"]/st_gml32:location/gml:Point/gml:pos[text()=\"1 -1\"]");
        this.checkCount(this.WFS20_XPATH_ENGINE, document, 1, "//wfs:FeatureCollection/wfs:member/st_gml32:Station_gml32[@gml:id=\"st.2\"]/st_gml32:location/gml:Point/gml:pos[text()=\"1.0E-7 -1.0E-7\"]");
    }

    private void enableCoordinatesFormattingGml31() {
        this.enableCoordinateFormatting((Name)new NameImpl("st_gml31", "Station_gml31"));
    }

    private void disableCoordinatesFormattingGml31() {
        this.disableCoordinateFormatting((Name)new NameImpl("st_gml31", "Station_gml31"));
    }

    private void enableCoordinatesFormattingGml32() {
        this.enableCoordinateFormatting((Name)new NameImpl("st_gml32", "Station_gml32"));
    }

    private void disableCoordinatesFormattingGml32() {
        this.disableCoordinateFormatting((Name)new NameImpl("st_gml32", "Station_gml32"));
    }

    private void enableCoordinateFormatting(Name qname) {
        FeatureTypeInfo info = (FeatureTypeInfo)this.getGeoServer().getCatalog().getResourceByName(qname, FeatureTypeInfo.class);
        info.setNumDecimals(8);
        info.setForcedDecimal(true);
        info.setPadWithZeros(true);
        this.getGeoServer().getCatalog().save((ResourceInfo)info);
    }

    private void disableCoordinateFormatting(Name qname) {
        FeatureTypeInfo info = (FeatureTypeInfo)this.getGeoServer().getCatalog().getResourceByName(qname, FeatureTypeInfo.class);
        info.setForcedDecimal(false);
        info.setPadWithZeros(false);
        this.getGeoServer().getCatalog().save((ResourceInfo)info);
    }

    @Override
    protected StationsMockData createTestData() {
        return new StationsMockData(){

            @Override
            protected Optional<String> extraStationFeatures() {
                String features = "\nst.2=st.2|station2|32154895|station2@stations.org|POINT(-1.0E-7 1.0E-7)";
                return Optional.of(features);
            }

            @Override
            protected Optional<String> extraMeasurementFeatures() {
                String features = "\nms.3=ms.3|wind|km/h|st.2";
                return Optional.of(features);
            }
        };
    }
}

