/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.ConnectionUsageMockData;
import org.geoserver.test.MockConnectionLifecycleListener;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.appschema.filter.FilterFactoryImplNamespaceAware;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureCollection;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.joining.JoiningNestedAttributeMapping;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.jdbc.JDBCDataStore;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ConnectionUsageTest
extends AbstractAppSchemaTestSupport {
    private FilterFactoryImplNamespaceAware ff;
    private MockConnectionLifecycleListener connListener;
    private MappingFeatureSource mappingFs;
    private Transaction transaction;
    private JDBCDataStore sourceDataStore;
    private int nestedFeaturesCount;

    @Override
    protected ConnectionUsageMockData createTestData() {
        return new ConnectionUsageMockData();
    }

    @Before
    public void setUp() throws Exception {
        this.nestedFeaturesCount = 0;
        this.init();
    }

    @Test
    public void testConnectionSharedAmongNestedIterators() throws Exception {
        PropertyIsEqualTo equals = this.ff.equals((Expression)this.ff.property("ex:nestedFeature/ex:ConnectionUsageFirstNested/ex:nestedFeature/ex:ConnectionUsageSecondNested/gml:name"), (Expression)this.ff.literal((Object)"C_nested_second"));
        try (FeatureIterator fIt = this.mappingFs.getFeatures((Filter)equals).features();){
            this.testNestedIterators(fIt);
        }
        Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.size());
        Assert.assertTrue((boolean)this.connListener.actionCountByDataStore.containsKey(this.sourceDataStore));
        Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).borrowCount);
        Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).releaseCount);
        Assert.assertEquals((long)2L, (long)this.nestedFeaturesCount);
    }

    @Test
    public void testConnectionSharedIfTransactionIs() throws Exception {
        PropertyIsEqualTo equals = this.ff.equals((Expression)this.ff.property("ex:nestedFeature/ex:ConnectionUsageFirstNested/ex:nestedFeature/ex:ConnectionUsageSecondNested/gml:name"), (Expression)this.ff.literal((Object)"C_nested_second"));
        FeatureCollection fc = this.mappingFs.getFeatures((Filter)equals);
        Assert.assertTrue((boolean)(fc instanceof MappingFeatureCollection));
        MappingFeatureCollection mfc = (MappingFeatureCollection)fc;
        try (DefaultTransaction tx = new DefaultTransaction();){
            try (FeatureIterator fIt = mfc.features((Transaction)tx);){
                this.testNestedIterators(fIt);
            }
            Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.size());
            Assert.assertTrue((boolean)this.connListener.actionCountByDataStore.containsKey(this.sourceDataStore));
            Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).borrowCount);
            Assert.assertEquals((long)0L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).releaseCount);
            Assert.assertEquals((long)2L, (long)this.nestedFeaturesCount);
            fIt = mfc.features((Transaction)tx);
            try {
                this.testNestedIterators(fIt);
            }
            finally {
                if (fIt != null) {
                    fIt.close();
                }
            }
            Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.size());
            Assert.assertTrue((boolean)this.connListener.actionCountByDataStore.containsKey(this.sourceDataStore));
            Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).borrowCount);
            Assert.assertEquals((long)0L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).releaseCount);
            Assert.assertEquals((long)4L, (long)this.nestedFeaturesCount);
        }
        Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).releaseCount);
    }

    @Test
    public void testConnectionNotSharedIfTransactionIsNot() throws Exception {
        FeatureIterator fIt;
        PropertyIsEqualTo equals = this.ff.equals((Expression)this.ff.property("ex:nestedFeature/ex:ConnectionUsageFirstNested/ex:nestedFeature/ex:ConnectionUsageSecondNested/gml:name"), (Expression)this.ff.literal((Object)"C_nested_second"));
        FeatureCollection fc = this.mappingFs.getFeatures((Filter)equals);
        Assert.assertTrue((boolean)(fc instanceof MappingFeatureCollection));
        MappingFeatureCollection mfc = (MappingFeatureCollection)fc;
        try (DefaultTransaction tx = new DefaultTransaction();){
            fIt = mfc.features((Transaction)tx);
            try {
                this.testNestedIterators(fIt);
            }
            finally {
                if (fIt != null) {
                    fIt.close();
                }
            }
            Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.size());
            Assert.assertTrue((boolean)this.connListener.actionCountByDataStore.containsKey(this.sourceDataStore));
            Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).borrowCount);
            Assert.assertEquals((long)0L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).releaseCount);
            Assert.assertEquals((long)2L, (long)this.nestedFeaturesCount);
        }
        Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).releaseCount);
        tx = new DefaultTransaction();
        try {
            fIt = mfc.features((Transaction)tx);
            try {
                this.testNestedIterators(fIt);
            }
            finally {
                if (fIt != null) {
                    fIt.close();
                }
            }
            Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.size());
            Assert.assertTrue((boolean)this.connListener.actionCountByDataStore.containsKey(this.sourceDataStore));
            Assert.assertEquals((long)2L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).borrowCount);
            Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).releaseCount);
            Assert.assertEquals((long)4L, (long)this.nestedFeaturesCount);
        }
        finally {
            tx.close();
        }
        Assert.assertEquals((long)2L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).releaseCount);
    }

    @Test
    public void testNoConnectionLeakIfExceptionThrown() throws Exception {
        FilterFactoryImplNamespaceAware ff = new FilterFactoryImplNamespaceAware();
        ff.setNamepaceContext(this.mappingFs.getMapping().getNamespaces());
        PropertyIsEqualTo equals = ff.equals((Expression)ff.property("ex:nestedFeature/ex:ConnectionUsageFirstNested/ex:nestedFeature/ex:ConnectionUsageSecondNested/gml:name"), (Expression)ff.literal((Object)"A_nested_second"));
        try (FeatureIterator fIt = this.mappingFs.getFeatures((Filter)equals).features();){
            this.testNestedIterators(fIt);
            Assert.fail((String)"Expected exception was not thrown!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.size());
        Assert.assertTrue((boolean)this.connListener.actionCountByDataStore.containsKey(this.sourceDataStore));
        Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).borrowCount);
        Assert.assertEquals((long)1L, (long)this.connListener.actionCountByDataStore.get((Object)this.sourceDataStore).releaseCount);
    }

    private void init() throws Exception {
        this.connListener = new MockConnectionLifecycleListener();
        FeatureTypeInfo typeInfo = this.getCatalog().getFeatureTypeByName("ex", "ConnectionUsageParent");
        Assert.assertNotNull((Object)typeInfo);
        FeatureSource fs = typeInfo.getFeatureSource((ProgressListener)new NullProgressListener(), null);
        this.initMappingFS(fs);
        FeatureSource sourceFs = this.mappingFs.getMapping().getSource();
        Assume.assumeTrue((sourceFs.getDataStore() instanceof JDBCDataStore && AppSchemaDataAccessConfigurator.isJoining() ? 1 : 0) != 0);
        this.sourceDataStore = (JDBCDataStore)sourceFs.getDataStore();
        this.ff = new FilterFactoryImplNamespaceAware();
        this.ff.setNamepaceContext(this.mappingFs.getMapping().getNamespaces());
        PropertyIsEqualTo equals = this.ff.equals((Expression)this.ff.property("gml:name"), (Expression)this.ff.literal((Object)"C_parent"));
        try (FeatureIterator fIt = this.mappingFs.getFeatures((Filter)equals).features();){
            Assert.assertTrue((boolean)fIt.hasNext());
            Assert.assertNotNull((Object)fIt.next());
        }
        this.sourceDataStore.getConnectionLifecycleListeners().add(this.connListener);
    }

    private void initMappingFS(FeatureSource fs) {
        if (fs instanceof DecoratingFeatureSource) {
            this.mappingFs = (MappingFeatureSource)((DecoratingFeatureSource)fs).unwrap(MappingFeatureSource.class);
        } else {
            Assert.assertTrue((boolean)(fs instanceof MappingFeatureSource));
            this.mappingFs = (MappingFeatureSource)fs;
        }
    }

    private void testNestedIterators(FeatureIterator iterator) throws IOException {
        Assert.assertTrue((boolean)(iterator instanceof DataAccessMappingFeatureIterator));
        DataAccessMappingFeatureIterator mappingIt = (DataAccessMappingFeatureIterator)iterator;
        Assert.assertTrue((boolean)iterator.hasNext());
        Feature f = iterator.next();
        Assert.assertNotNull((Object)f);
        FeatureSource mappedSource = mappingIt.getMappedSource();
        Assert.assertSame((Object)mappedSource.getDataStore(), (Object)this.sourceDataStore);
        Assert.assertNotNull((Object)mappingIt.getTransaction());
        this.transaction = mappingIt.getTransaction();
        this.testNestedIteratorsRecursively(this.mappingFs.getMapping(), mappingIt);
    }

    private void testNestedIteratorsRecursively(FeatureTypeMapping mapping, DataAccessMappingFeatureIterator mappingIt) throws IOException {
        List attrs = mapping.getAttributeMappings();
        Assert.assertNotNull((Object)attrs);
        Assert.assertFalse((boolean)attrs.isEmpty());
        for (AttributeMapping attr : attrs) {
            if (!(attr instanceof JoiningNestedAttributeMapping)) continue;
            ++this.nestedFeaturesCount;
            JoiningNestedAttributeMapping joiningNestedAttr = (JoiningNestedAttributeMapping)attr;
            Map nestedFeatureIterators = joiningNestedAttr.getNestedFeatureIterators((Object)mappingIt);
            Assert.assertNotNull((Object)nestedFeatureIterators);
            if (nestedFeatureIterators.isEmpty()) continue;
            Assert.assertEquals((long)1L, (long)nestedFeatureIterators.size());
            FeatureTypeMapping nestedMapping = joiningNestedAttr.getFeatureTypeMapping(null);
            DataAccessMappingFeatureIterator nestedIt = (DataAccessMappingFeatureIterator)nestedFeatureIterators.values().iterator().next();
            try {
                FeatureSource nestedMappedSource = nestedIt.getMappedSource();
                Assert.assertEquals((Object)this.sourceDataStore, (Object)nestedMappedSource.getDataStore());
                Assert.assertEquals((Object)this.transaction, (Object)nestedIt.getTransaction());
                this.testNestedIteratorsRecursively(nestedMapping, nestedIt);
            }
            finally {
                if (nestedIt == null) continue;
                nestedIt.close();
            }
        }
    }
}

