/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.BoreholeViewMockData;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class CSVOutputFormatTest
extends AbstractAppSchemaTestSupport {
    @Override
    protected BoreholeViewMockData createTestData() {
        return new BoreholeViewMockData();
    }

    @Test
    public void testFullRequest() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?service=WFS&version=1.1.0&request=GetFeature&typename=gsmlp:BoreholeView&outputFormat=csv");
        Assert.assertEquals((Object)"text/csv", (Object)this.getBaseMimeType(resp.getContentType()));
        Assert.assertEquals((Object)"attachment; filename=BoreholeView.csv", (Object)resp.getHeader("Content-Disposition"));
        List<String[]> lines = CSVOutputFormatTest.readLines(resp.getContentAsString());
        Assert.assertEquals((long)3L, (long)lines.size());
        String[] header = new String[]{"gml:id", "gsmlp:identifier", "gsmlp:name", "gsmlp:drillingMethod", "gsmlp:driller", "gsmlp:drillStartDate", "gsmlp:startPoint", "gsmlp:inclinationType", "gsmlp:boreholeMaterialCustodian", "gsmlp:boreholeLength_m", "gsmlp:elevation_m", "gsmlp:elevation_srs", "gsmlp:specification_uri", "gsmlp:metadata_uri", "gsmlp:shape"};
        Assert.assertTrue((boolean)Arrays.asList(lines.get(0)).containsAll(Arrays.asList(header)));
        int headerCount = lines.get(0).length;
        Assert.assertEquals((long)headerCount, (long)lines.get(1).length);
        Assert.assertEquals((long)headerCount, (long)lines.get(2).length);
    }

    @Test
    public void testFilter() throws Exception {
        String IDENTIFIER = "borehole.GA.17338";
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gsmlp=\"http://xmlns.geosciml.org/geosciml-portrayal/2.0\" >    <wfs:Query typeName=\"gsmlp:BoreholeView\" outputFormat=\"csv\">        <ogc:Filter>            <ogc:PropertyIsEqualTo>                <ogc:Literal>" + IDENTIFIER + "</ogc:Literal>                <ogc:PropertyName>gsmlp:identifier</ogc:PropertyName>            </ogc:PropertyIsEqualTo>        </ogc:Filter>    </wfs:Query> </wfs:GetFeature>";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs?service=WFS&request=GetFeature&version=1.1.0&typeName=gsmlp:BoreholeView&outputFormat=csv", xml, "text/csv");
        Assert.assertEquals((Object)"text/csv", (Object)this.getBaseMimeType(resp.getContentType()));
        Assert.assertEquals((Object)"attachment; filename=BoreholeView.csv", (Object)resp.getHeader("Content-Disposition"));
        List<String[]> lines = CSVOutputFormatTest.readLines(resp.getContentAsString());
        Assert.assertEquals((long)2L, (long)lines.size());
        int identifierIndex = Arrays.asList(lines.get(0)).indexOf("gsmlp:identifier");
        Assert.assertEquals((Object)IDENTIFIER, (Object)lines.get(1)[identifierIndex]);
        String[] header = new String[]{"gml:id", "gsmlp:identifier", "gsmlp:name", "gsmlp:drillingMethod", "gsmlp:driller", "gsmlp:drillStartDate", "gsmlp:startPoint", "gsmlp:inclinationType", "gsmlp:boreholeMaterialCustodian", "gsmlp:boreholeLength_m", "gsmlp:elevation_m", "gsmlp:elevation_srs", "gsmlp:specification_uri", "gsmlp:metadata_uri", "gsmlp:shape"};
        Assert.assertTrue((boolean)Arrays.asList(lines.get(0)).containsAll(Arrays.asList(header)));
        int headerCount = lines.get(0).length;
        Assert.assertEquals((long)headerCount, (long)lines.get(1).length);
    }

    static List<String[]> readLines(String csvContent) throws IOException {
        String[] nextLine;
        CSVReader reader = new CSVReader((Reader)new StringReader(csvContent));
        ArrayList<String[]> result = new ArrayList<String[]>();
        while ((nextLine = reader.readNext()) != null) {
            result.add(nextLine);
        }
        return result;
    }
}

