/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import org.geoserver.test.AbstractAppSchemaTestSupport;
import org.geoserver.test.BBoxMockData;
import org.geoserver.test.GeoPackageUtil;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.JTS;
import org.geotools.gml.producer.CoordinateFormatter;
import org.geotools.referencing.CRS;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.w3c.dom.Document;

public class BBoxFilterTest
extends AbstractAppSchemaTestSupport {
    private final String WFS_GET_FEATURE = "wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer";
    private final String WFS_GET_FEATURE_LOG = "WFS GetFeature&typename=ex:geomContainerresponse:\n";
    private final String LONGLAT = "&BBOX=130,-29,134,-24";
    private final String LATLONG = "&BBOX=-29,130,-24,134";
    private final String EPSG_4326 = "EPSG:4326";
    private final String EPSG_4283 = "urn:x-ogc:def:crs:EPSG:4283";

    @Override
    protected BBoxMockData createTestData() {
        return new BBoxMockData();
    }

    @Test
    public void testQuery() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainerresponse:\n" + this.prettyString(doc));
        this.assertXpathEvaluatesTo("3", "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(3, "//ex:geomContainer", doc);
    }

    @Test
    public void testQueryBboxLongLat() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&BBOX=130,-29,134,-24");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainerresponse:\n&BBOX=130,-29,134,-24" + this.prettyString(doc));
        if (!GeoPackageUtil.isGeopkgTest()) {
            this.assertNumberMatched(doc, 0);
        } else {
            this.assertNumberMatched(doc, 2);
        }
    }

    @Test
    public void testQueryBboxLongLatEPSGCode() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&BBOX=130,-29,134,-24,EPSG:4326");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainerresponse:\n&BBOX=130,-29,134,-24" + this.prettyString(doc));
        if (!GeoPackageUtil.isGeopkgTest()) {
            this.assertNumberMatched(doc, 2);
        } else {
            this.assertNumberMatched(doc, 0);
        }
    }

    @Test
    public void testQueryBboxLongLatURN() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&BBOX=130,-29,134,-24,urn:x-ogc:def:crs:EPSG:4326");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainerresponse:\n&BBOX=130,-29,134,-24" + this.prettyString(doc));
        if (!GeoPackageUtil.isGeopkgTest()) {
            this.assertNumberMatched(doc, 0);
        } else {
            this.assertNumberMatched(doc, 2);
        }
    }

    @Test
    public void testQueryBboxLatLong() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&BBOX=-29,130,-24,134");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainerresponse:\n&BBOX=-29,130,-24,134" + this.prettyString(doc));
        if (!GeoPackageUtil.isGeopkgTest()) {
            this.assertNumberMatched(doc, 2);
        } else {
            this.assertNumberMatched(doc, 0);
        }
    }

    @Test
    public void testQueryBboxLatLongEPSGCode() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&BBOX=-29,130,-24,134,EPSG:4326");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainerresponse:\n&BBOX=-29,130,-24,134" + this.prettyString(doc));
        if (!GeoPackageUtil.isGeopkgTest()) {
            this.assertNumberMatched(doc, 0);
        } else {
            this.assertNumberMatched(doc, 2);
        }
    }

    @Test
    public void testQueryBboxLatLongURN() {
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&BBOX=-29,130,-24,134,urn:x-ogc:def:crs:EPSG:4326");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainerresponse:\n&BBOX=-29,130,-24,134" + this.prettyString(doc));
        if (!GeoPackageUtil.isGeopkgTest()) {
            this.assertNumberMatched(doc, 2);
        } else {
            this.assertNumberMatched(doc, 0);
        }
    }

    @Test
    public void testQueryBboxLatLongPost() {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ex=\"http://example.com\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd \"><wfs:Query typeName=\"ex:geomContainer\">    <ogc:Filter>        <ogc:BBOX>            <ogc:PropertyName>ex:geom</ogc:PropertyName>            <gml:Envelope srsName=\"urn:x-ogc:def:crs:EPSG:4326\">                  <gml:lowerCorner>-29 130</gml:lowerCorner>                  <gml:upperCorner>-24 134</gml:upperCorner>            </gml:Envelope>        </ogc:BBOX>    </ogc:Filter></wfs:Query></wfs:GetFeature>";
        this.validate(xml);
        Document doc = this.postAsDOM("wfs", xml);
        LOGGER.info("WFS GetFeature&typename=ex:geomContainerresponse:\n with POST filter " + this.prettyString(doc));
        if (!GeoPackageUtil.isGeopkgTest()) {
            this.assertNumberMatched(doc, 2);
        } else {
            this.assertNumberMatched(doc, 0);
        }
    }

    @Test
    public void testQueryBboxLatLongSrs4283() throws NoSuchAuthorityCodeException, FactoryException, MismatchedDimensionException, TransformException {
        if (GeoPackageUtil.isGeopkgTest()) {
            return;
        }
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&typename=ex:geomContainer&BBOX=-29,130,-24,134&srsName=urn:x-ogc:def:crs:EPSG:4283");
        LOGGER.info("WFS GetFeature&typename=ex:geomContainerresponse:\n&BBOX=130,-29,134,-24" + this.prettyString(doc));
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"urn:x-ogc:def:crs:EPSG:4283");
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        GeometryFactory factory = new GeometryFactory();
        Point targetPoint = (Point)JTS.transform((Geometry)factory.createPoint(new Coordinate(132.61, -26.98)), (MathTransform)transform);
        CoordinateFormatter format = new CoordinateFormatter(8);
        String targetPointCoord1 = format.format(targetPoint.getCoordinate().x) + " " + format.format(targetPoint.getCoordinate().y);
        targetPoint = (Point)JTS.transform((Geometry)factory.createPoint(new Coordinate(132.71, -26.46)), (MathTransform)transform);
        String targetPointCoord2 = format.format(targetPoint.getCoordinate().x) + " " + format.format(targetPoint.getCoordinate().y);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "//ex:geomContainer[@gml:id='1']/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "//ex:geomContainer[@gml:id='1']/ex:geom/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo(targetPointCoord1, "//ex:geomContainer[@gml:id='1']/ex:geom/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "//ex:geomContainer[@gml:id='1']/ex:nestedFeature/ex:nestedGeom[@gml:id='nested.1']/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "//ex:geomContainer[@gml:id='1']/ex:nestedFeature/ex:nestedGeom[@gml:id='nested.1']/ex:geom/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo(targetPointCoord1, "//ex:geomContainer[@gml:id='1']/ex:nestedFeature/ex:nestedGeom[@gml:id='nested.1']/ex:geom/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "//ex:geomContainer[@gml:id='2']/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "//ex:geomContainer[@gml:id='2']/ex:geom/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo(targetPointCoord2, "//ex:geomContainer[@gml:id='2']/ex:geom/gml:Point/gml:pos", doc);
        this.assertXpathEvaluatesTo("urn:x-ogc:def:crs:EPSG:4283", "//ex:geomContainer[@gml:id='2']/ex:nestedFeature/ex:nestedGeom[@gml:id='nested.2']/ex:geom/gml:Point/@srsName", doc);
        this.assertXpathEvaluatesTo("2", "//ex:geomContainer[@gml:id='2']/ex:nestedFeature/ex:nestedGeom[@gml:id='nested.2']/ex:geom/gml:Point/@srsDimension", doc);
        this.assertXpathEvaluatesTo(targetPointCoord2, "//ex:geomContainer[@gml:id='2']/ex:nestedFeature/ex:nestedGeom[@gml:id='nested.2']/ex:geom/gml:Point/gml:pos", doc);
    }

    private void assertNumberMatched(Document doc, Integer numberMatched) {
        this.assertXpathEvaluatesTo(numberMatched.toString(), "/wfs:FeatureCollection/@numberOfFeatures", doc);
        this.assertXpathCount(numberMatched, "//ex:geomContainer", doc);
    }
}

