/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.AbstractAppSchemaMockData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.NormalizedMultiValuesTest;
import org.geoserver.util.IOUtils;
import org.geoserver.wfs.WFSInfo;
import org.geotools.api.data.DataAccess;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.appschema.jdbc.NestedFilterToSQL;
import org.geotools.appschema.resolver.xml.AppSchemaValidator;
import org.geotools.appschema.resolver.xml.AppSchemaXSDRegistry;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessConfigurator;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.SQLDialect;
import org.geotools.xml.resolver.SchemaCache;
import org.geotools.xml.resolver.SchemaCatalog;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class AbstractAppSchemaTestSupport
extends GeoServerSystemTestSupport {
    protected static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    private final Map<String, String> WFS_NAMESPACES = Map.ofEntries(Map.entry("wfs", "http://www.opengis.net/wfs"), Map.entry("ows", "http://www.opengis.net/ows"), Map.entry("ogc", "http://www.opengis.net/ogc"), Map.entry("xs", "http://www.w3.org/2001/XMLSchema"), Map.entry("xsd", "http://www.w3.org/2001/XMLSchema"), Map.entry("gml", "http://www.opengis.net/gml"), Map.entry("xlink", "http://www.w3.org/1999/xlink"), Map.entry("xsi", "http://www.w3.org/2001/XMLSchema-instance"), Map.entry("wms", "http://www.opengis.net/wms"));
    private XpathEngine xpathEngine;
    private SchemaCatalog catalog;

    protected abstract AbstractAppSchemaMockData createTestData();

    protected void onSetUp(SystemTestData testData) throws Exception {
        WFSInfo wfs = (WFSInfo)this.getGeoServer().getService(WFSInfo.class);
        wfs.setCanonicalSchemaLocation(true);
        wfs.setEncodeFeatureMember(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        SchemaCache.disableAutomaticConfiguration();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        DataAccessRegistry.unregisterAndDisposeAll();
        AppSchemaDataAccessRegistry.clearAppSchemaProperties();
        AppSchemaXSDRegistry.getInstance().dispose();
        this.catalog = null;
    }

    public AbstractAppSchemaMockData getTestData() {
        return (AbstractAppSchemaMockData)super.getTestData();
    }

    public Map<String, String> getNamespaces() {
        return this.getTestData().getNamespaces();
    }

    public String getNamespace(String prefix) {
        return this.getNamespaces().get(prefix);
    }

    protected InputStream get(String path) {
        try {
            return super.get(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected InputStream getBinary(String path) {
        try {
            return this.getBinaryInputStream(this.getAsServletResponse(path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Document getAsDOM(String path) {
        try {
            return super.getAsDOM(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected InputStream post(String path, String xml) {
        try {
            return super.post(path, xml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Document postAsDOM(String path, String xml) {
        try {
            return super.postAsDOM(path, xml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XpathEngine getXpathEngine() {
        if (this.xpathEngine == null) {
            this.xpathEngine = XMLUnit.newXpathEngine();
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.putAll(this.WFS_NAMESPACES);
            namespaces.putAll(this.getTestData().getNamespaces());
            this.xpathEngine.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        }
        return this.xpathEngine;
    }

    private SchemaCatalog getSchemaCatalog() {
        if (this.catalog == null && testData instanceof AbstractAppSchemaMockData) {
            this.catalog = ((AbstractAppSchemaMockData)testData).getSchemaCatalog();
        }
        return this.catalog;
    }

    protected String evaluate(String xpath, Document document) {
        try {
            return this.getXpathEngine().evaluate(xpath, document);
        }
        catch (XpathException e) {
            throw new RuntimeException(e);
        }
    }

    protected NodeList getMatchingNodes(String xpath, Document document) {
        try {
            return this.getXpathEngine().getMatchingNodes(xpath, document);
        }
        catch (XpathException e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertXpathEvaluatesTo(String expected, String xpath, Document document) {
        Assert.assertEquals((Object)expected, (Object)this.evaluate(xpath, document));
    }

    protected void assertXpathCount(int count, String xpath, Document document) {
        Assert.assertEquals((long)count, (long)this.getMatchingNodes(xpath, document).getLength());
    }

    protected void assertXpathMatches(String regex, String xpath, Document document) {
        Assert.assertTrue((boolean)this.evaluate(xpath, document).matches(regex));
    }

    protected void assertXpathNotMatches(String regex, String xpath, Document document) {
        Assert.assertFalse((boolean)this.evaluate(xpath, document).matches(regex));
    }

    protected String prettyString(Document document) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.prettyPrint(document, output);
        return ((Object)output).toString();
    }

    protected void prettyPrint(Document document, OutputStream output) {
        try {
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            tx.setOutputProperty("indent", "yes");
            tx.transform(new DOMSource(document), new StreamResult(output));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected File findFile(String path, File root) {
        File target = null;
        List<File> files = Arrays.asList(root.listFiles());
        String[] steps = path.split("/");
        for (int i = 0; i < steps.length; ++i) {
            for (File file : files) {
                if (!file.getName().equals(steps[i])) continue;
                if (i < steps.length - 1) {
                    return this.findFile(path.substring(steps[i].length() + 1, path.length()), file);
                }
                return file;
            }
        }
        return target;
    }

    protected void validateGet(String path) {
        try {
            AppSchemaValidator.validate((InputStream)this.get(path), (SchemaCatalog)this.getSchemaCatalog());
        }
        catch (RuntimeException e) {
            LOGGER.severe(e.getMessage());
            throw e;
        }
    }

    protected void validatePost(String path, String xml) {
        try {
            AppSchemaValidator.validate((InputStream)this.post(path, xml), (SchemaCatalog)this.getSchemaCatalog());
        }
        catch (RuntimeException e) {
            LOGGER.severe(e.getMessage());
            throw e;
        }
    }

    protected void validate(String xml) {
        try {
            AppSchemaValidator.validate((String)xml, (SchemaCatalog)this.getSchemaCatalog());
        }
        catch (RuntimeException e) {
            LOGGER.severe(e.getMessage());
            throw e;
        }
    }

    protected void assertNotBlank(String testName, BufferedImage image, Color bgColor) {
        int pixelsDiffer = super.countNonBlankPixels(testName, image, bgColor);
        Assert.assertTrue((String)(testName + " image is completely blank"), (0 < pixelsDiffer ? 1 : 0) != 0);
    }

    protected void assertContainsFeatures(FeatureCollection featureSet, String ... fids) {
        List<String> fidList = Arrays.asList(fids);
        try (FeatureIterator it = featureSet.features();){
            int count = 0;
            while (it.hasNext()) {
                Feature f = it.next();
                String[] parts = f.getIdentifier().getID().split("\\.");
                String fid = parts[parts.length - 1];
                Assert.assertTrue((boolean)fidList.contains(fid));
                ++count;
            }
            Assert.assertEquals((long)fidList.size(), (long)count);
        }
    }

    protected boolean shouldTestNestedFiltersEncoding(FeatureTypeMapping rootMapping) {
        if (!(rootMapping.getSource().getDataStore() instanceof JDBCDataStore)) {
            return false;
        }
        if (!AppSchemaDataAccessConfigurator.isJoining()) {
            return false;
        }
        return AppSchemaDataAccessConfigurator.shouldEncodeNestedFilters();
    }

    protected NestedFilterToSQL createNestedFilterEncoder(FeatureTypeMapping mapping) {
        DataAccess source = mapping.getSource().getDataStore();
        if (!(source instanceof JDBCDataStore)) {
            throw new IllegalArgumentException("nested filters encoding requires the source datastore be a JDBCDataStore");
        }
        JDBCDataStore store = (JDBCDataStore)source;
        SQLDialect dialect = store.getSQLDialect();
        FilterToSQL original = null;
        if (dialect instanceof BasicSQLDialect) {
            original = ((BasicSQLDialect)dialect).createFilterToSQL();
        } else if (dialect instanceof PreparedStatementSQLDialect) {
            original = ((PreparedStatementSQLDialect)dialect).createPreparedFilterToSQL();
            ((PreparedFilterToSQL)original).setPrepareEnabled(false);
        }
        original.setFeatureType((SimpleFeatureType)mapping.getSource().getSchema());
        NestedFilterToSQL nestedFilterToSQL = new NestedFilterToSQL(mapping, original);
        nestedFilterToSQL.setInline(true);
        return nestedFilterToSQL;
    }

    protected static String toString(Document document) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    protected String readResource(String resourcePath) {
        String string;
        block8: {
            InputStream input = NormalizedMultiValuesTest.class.getResourceAsStream(resourcePath);
            try {
                string = IOUtils.toString((InputStream)input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new RuntimeException(String.format("Error reading resource '%s'.", resourcePath));
                }
            }
            input.close();
        }
        return string;
    }

    protected JSONObject getNestedObject(JSONObject root, String ... keys) {
        JSONObject curr = root;
        for (String key : keys) {
            if (!curr.has(key)) {
                Assert.fail((String)("Could not find property " + key + " in " + curr));
            }
            curr = curr.getJSONObject(key);
        }
        return curr;
    }

    protected JSONObject getFeaturePropertiesById(JSON geoJson, String id) {
        MatcherAssert.assertThat((Object)geoJson, (Matcher)CoreMatchers.instanceOf(JSONObject.class));
        JSONObject json = (JSONObject)geoJson;
        JSONArray features = json.getJSONArray("features");
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            if (!Objects.equals(id, feature.get("id"))) continue;
            return feature.getJSONObject("properties");
        }
        return null;
    }
}

