/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.geoserver.data.CatalogWriter;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.NamespaceTestData;
import org.geoserver.test.onlineTest.setup.AppSchemaTestGeopackageSetup;
import org.geoserver.test.onlineTest.setup.AppSchemaTestOracleSetup;
import org.geoserver.test.onlineTest.setup.AppSchemaTestPostgisSetup;
import org.geoserver.test.onlineTest.support.AbstractReferenceDataSetup;
import org.geoserver.util.IOUtils;
import org.geotools.data.complex.AppSchemaDataAccessTest;
import org.geotools.xml.resolver.SchemaCatalog;
import org.locationtech.jts.geom.Envelope;

public abstract class AbstractAppSchemaMockData
extends SystemTestData
implements NamespaceTestData {
    private static final String TEST_DATA = "/test-data/";
    public static final String GSML_PREFIX = "gsml";
    public static final String GSML_URI = "urn:cgi:xmlns:CGI:GeoSciML:2.0";
    public static final String GSML_SCHEMA_LOCATION_URL = "http://www.geosciml.org/geosciml/2.0/xsd/geosciml.xsd";
    public static final String SPEC_PREFIX = "spec";
    protected static final Map<String, String> GML32_NAMESPACES = Map.ofEntries(Map.entry("cgu", "urn:cgi:xmlns:CGI:Utilities:3.0.0"), Map.entry("gco", "http://www.isotc211.org/2005/gco"), Map.entry("gmd", "http://www.isotc211.org/2005/gmd"), Map.entry("gml", "http://www.opengis.net/gml/3.2"), Map.entry("gsml", "urn:cgi:xmlns:CGI:GeoSciML-Core:3.0.0"), Map.entry("sa", "http://www.opengis.net/sampling/2.0"), Map.entry("spec", "http://www.opengis.net/samplingSpecimen/2.0"), Map.entry("swe", "http://www.opengis.net/swe/1.0/gml32"), Map.entry("wfs", "http://www.opengis.net/wfs/2.0"), Map.entry("xlink", "http://www.w3.org/1999/xlink"));
    private static final Map<String, String> NAMESPACES = Map.ofEntries(Map.entry("gsml", "urn:cgi:xmlns:CGI:GeoSciML:2.0"), Map.entry("gml", "http://www.opengis.net/gml"), Map.entry("xlink", "http://www.w3.org/1999/xlink"), Map.entry("sa", "http://www.opengis.net/sampling/1.0"), Map.entry("om", "http://www.opengis.net/om/1.0"), Map.entry("cv", "http://www.opengis.net/cv/0.2.1"), Map.entry("swe", "http://www.opengis.net/swe/1.0.1"), Map.entry("sml", "http://www.opengis.net/sensorML/1.0.1"));
    static final String KEY_SRS_HANDLINGS = "srsHandling";
    static final String KEY_ALIAS = "alias";
    static final String KEY_STYLE = "style";
    static final String KEY_SRS_NUMBER = "srs";
    static final String KEY_LL_ENVELOPE = "ll_envelope";
    static final String KEY_NATIVE_ENVELOPE = "native_envelope";
    static final Envelope DEFAULT_ENVELOPE = new Envelope(-180.0, 180.0, -90.0, 90.0);
    private final Map<String, Map<String, Serializable>> datastoreParams = new LinkedHashMap<String, Map<String, Serializable>>();
    private final Map<String, String> datastoreNamespacePrefixes = new LinkedHashMap<String, String>();
    private final Map<String, String> namespaces;
    private final List<String> isolatedNamespaces = new ArrayList<String>();
    private final Map<String, String> layerStyles = new LinkedHashMap<String, String>();
    private File appschema;
    private final boolean createPrimaryKey;
    private File styles;
    private String geopkgDir;
    protected File featureTypesBaseDir;
    private Map<String, File> propertiesFiles;
    private String onlineTestId;
    private SchemaCatalog catalog;
    private boolean is3D = false;

    public AbstractAppSchemaMockData() {
        this(NAMESPACES);
    }

    public AbstractAppSchemaMockData(boolean createPrimaryKey) {
        this(NAMESPACES, createPrimaryKey);
    }

    static File newRandomDirectory() {
        try {
            return IOUtils.createRandomDirectory((String)"target", (String)"app-schema-mock", (String)"data");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AbstractAppSchemaMockData(Map<String, String> namespaces) {
        this(namespaces, true);
    }

    public AbstractAppSchemaMockData(Map<String, String> namespaces, boolean createPrimaryKey) {
        super(AbstractAppSchemaMockData.newRandomDirectory());
        this.namespaces = new LinkedHashMap<String, String>(namespaces);
        this.createPrimaryKey = createPrimaryKey;
        this.featureTypesBaseDir = new File(this.data, "featureTypes");
        this.featureTypesBaseDir.mkdir();
        this.styles = new File(this.data, "styles");
        this.styles.mkdir();
        this.appschema = new File(this.data, "appschema");
        this.appschema.mkdir();
        this.propertiesFiles = new HashMap<String, File>();
        this.addContent();
        if (!this.propertiesFiles.isEmpty()) {
            try {
                this.createTablesInTestDatabase();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.setUpCatalog();
    }

    public boolean isOracleOnlineTest() {
        return "oracle".equals(this.onlineTestId);
    }

    public boolean isPostgisOnlineTest() {
        return "postgis".equals(this.onlineTestId);
    }

    public boolean isGeopackageOnlineTest() {
        return "geopkg".equals(this.onlineTestId);
    }

    protected void setSchemaCatalog(String catalogLocation) {
        if (catalogLocation != null) {
            URL resolvedCatalogLocation = this.getClass().getResource(TEST_DATA + catalogLocation);
            if (resolvedCatalogLocation == null) {
                throw new RuntimeException("Test catalog location must be relative to test-data directory!");
            }
            this.catalog = SchemaCatalog.build((URL)resolvedCatalogLocation);
        }
    }

    public SchemaCatalog getSchemaCatalog() {
        return this.catalog;
    }

    @Override
    public Map<String, String> getNamespaces() {
        return Collections.unmodifiableMap(this.namespaces);
    }

    protected abstract void addContent();

    private InputStream openResource(String resource) {
        File resourceFile = new File(resource);
        if (resourceFile.exists()) {
            try {
                return new FileInputStream(resourceFile);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Error reading file '%s'.", resourceFile.getAbsolutePath()), exception);
            }
        }
        return AppSchemaDataAccessTest.class.getResourceAsStream(TEST_DATA + resource);
    }

    private void copyFileToFeatureTypeDir(String namespacePrefix, String typeName, String fileName) throws IOException {
        try (InputStream input = this.openResource(fileName);){
            this.copy(input, "featureTypes/" + this.getDataStoreName(namespacePrefix, typeName) + "/" + this.getFileNamePart(fileName));
        }
    }

    protected String getFileNamePart(String fileName) {
        if (fileName.indexOf(File.separator) > 0) {
            return fileName.substring(fileName.lastIndexOf(File.separator) + 1, fileName.length());
        }
        return fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
    }

    public File getDataDirectoryRoot() {
        return this.data;
    }

    public boolean isTestDataAvailable() {
        return true;
    }

    public void setUp() throws IOException {
        this.setUpCatalog();
        this.setUpSecurity();
        this.copy(MockData.class.getResourceAsStream("services.xml"), "services.xml");
    }

    public void setUpDefault() throws Exception {
    }

    public void tearDown() {
        try {
            IOUtils.delete((File)this.data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.data = null;
    }

    private void setUpCatalog() {
        CatalogWriter writer = new CatalogWriter();
        writer.dataStores(this.datastoreParams, this.datastoreNamespacePrefixes, Collections.emptySet());
        writer.coverageStores(new HashMap(), new HashMap(), Collections.emptySet());
        writer.namespaces(this.namespaces, this.isolatedNamespaces);
        writer.styles(this.layerStyles);
        try {
            writer.write(new File(this.data, "catalog.xml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void copy(InputStream input, String location) {
        try {
            IOUtils.copy((InputStream)input, (File)new File(this.data, location));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void copy(String content, String location) {
        File file = new File(this.data, location);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeInfoFile(String namespacePrefix, String typeName, File featureTypeDir, String dataStoreName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_STYLE, "Default");
        params.put(KEY_SRS_HANDLINGS, 2);
        params.put(KEY_ALIAS, null);
        Integer srs = 4326;
        params.put(KEY_SRS_NUMBER, srs);
        try {
            featureTypeDir.mkdir();
            File info = new File(featureTypeDir, "info.xml");
            info.delete();
            info.createNewFile();
            try (FileWriter writer = new FileWriter(info);){
                String style;
                writer.write("<featureType datastore=\"" + dataStoreName + "\">");
                writer.write("<name>" + typeName + "</name>");
                writer.write("<nativeName>" + typeName + "</nativeName>");
                if (params.get(KEY_ALIAS) != null) {
                    writer.write("<alias>" + params.get(KEY_ALIAS) + "</alias>");
                }
                writer.write("<SRS>" + params.get(KEY_SRS_NUMBER) + "</SRS>");
                writer.write("<SRSHandling>" + params.get(KEY_SRS_HANDLINGS) + "</SRSHandling>");
                writer.write("<title>" + typeName + "</title>");
                writer.write("<abstract>abstract about " + typeName + "</abstract>");
                writer.write("<numDecimals value=\"8\"/>");
                writer.write("<keywords>" + typeName + "</keywords>");
                Envelope llEnvelope = (Envelope)params.get(KEY_LL_ENVELOPE);
                if (llEnvelope == null) {
                    llEnvelope = DEFAULT_ENVELOPE;
                }
                writer.write("<latLonBoundingBox dynamic=\"false\" minx=\"" + llEnvelope.getMinX() + "\" miny=\"" + llEnvelope.getMinY() + "\" maxx=\"" + llEnvelope.getMaxX() + "\" maxy=\"" + llEnvelope.getMaxY() + "\"/>");
                Envelope nativeEnvelope = (Envelope)params.get(KEY_NATIVE_ENVELOPE);
                if (nativeEnvelope != null) {
                    writer.write("<nativeBBox dynamic=\"false\" minx=\"" + nativeEnvelope.getMinX() + "\" miny=\"" + nativeEnvelope.getMinY() + "\" maxx=\"" + nativeEnvelope.getMaxX() + "\" maxy=\"" + nativeEnvelope.getMaxY() + "\"/>");
                }
                if ((style = (String)params.get(KEY_STYLE)) == null) {
                    style = "Default";
                }
                writer.write("<styles default=\"" + style + "\"/>");
                writer.write("</featureType>");
                writer.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Map<String, Serializable> buildAppSchemaDatastoreParams(String namespacePrefix, String typeName, String mappingFileName, File featureTypesBaseDir, String dataStoreName) {
        try {
            return Map.ofEntries(Map.entry("dbtype", "app-schema"), Map.entry("url", new File(new File(featureTypesBaseDir, dataStoreName), mappingFileName).toURI().toURL()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void addFeatureType(String namespacePrefix, String typeName, String mappingFileName, String ... supportFileNames) {
        File featureTypeDir = this.getFeatureTypeDir(this.featureTypesBaseDir, namespacePrefix, typeName);
        String dataStoreName = this.getDataStoreName(namespacePrefix, typeName);
        try {
            AbstractAppSchemaMockData.writeInfoFile(namespacePrefix, typeName, featureTypeDir, dataStoreName);
            this.copyMappingAndSupportFiles(namespacePrefix, typeName, mappingFileName, supportFileNames);
            this.addDataStore(dataStoreName, namespacePrefix, AbstractAppSchemaMockData.buildAppSchemaDatastoreParams(namespacePrefix, typeName, this.getFileNamePart(mappingFileName), this.featureTypesBaseDir, dataStoreName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void add3DFeatureType(String namespacePrefix, String typeName, String mappingFileName, String ... supportFileNames) {
        this.addFeatureType(namespacePrefix, typeName, mappingFileName, supportFileNames);
        this.is3D = true;
    }

    private void createTablesInTestDatabase() throws Exception {
        AbstractReferenceDataSetup setup = null;
        if (this.isOracleOnlineTest()) {
            setup = this.is3D ? AppSchemaTestOracleSetup.get3DInstance(this.propertiesFiles) : AppSchemaTestOracleSetup.getInstance(this.propertiesFiles);
            setup.setUp();
            setup.tearDown();
        } else if (this.isPostgisOnlineTest()) {
            setup = AppSchemaTestPostgisSetup.getInstance(this.propertiesFiles, this.createPrimaryKey);
            setup.setUp();
            setup.tearDown();
        } else if (this.isGeopackageOnlineTest()) {
            setup = AppSchemaTestGeopackageSetup.getInstance(this.propertiesFiles, this.geopkgDir);
            setup.setUp();
            setup.tearDown();
        }
    }

    public void addStyle(String styleId, String fileName) {
        this.layerStyles.put(styleId, styleId + ".sld");
        try (InputStream styleContents = this.getClass().getResourceAsStream(TEST_DATA + fileName);){
            File to = new File(this.styles, styleId + ".sld");
            IOUtils.copy((InputStream)styleContents, (File)to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addDataStore(String dataStoreName, String namespacePrefix, Map<String, Serializable> params) {
        this.datastoreParams.put(dataStoreName, params);
        this.datastoreNamespacePrefixes.put(dataStoreName, namespacePrefix);
    }

    protected void putNamespace(String namspacePrefix, String namespaceUri) {
        this.namespaces.put(namspacePrefix, namespaceUri);
    }

    protected void putIsolatedNamespace(String namespacePrefix, String namespaceUri) {
        this.namespaces.put(namespacePrefix, namespaceUri);
        this.isolatedNamespaces.add(namespacePrefix);
    }

    protected void removeNamespace(String namespacePrefix) {
        this.namespaces.remove(namespacePrefix);
        this.isolatedNamespaces.remove(namespacePrefix);
    }

    protected String getDataStoreName(String namespacePrefix, String typeName) {
        return namespacePrefix + "_" + typeName;
    }

    protected File getFeatureTypesBaseDir() {
        return this.featureTypesBaseDir;
    }

    protected File getFeatureTypeDir(File featureTypesBaseDir, String namespacePrefix, String typeName) {
        return new File(featureTypesBaseDir, this.getDataStoreName(namespacePrefix, typeName));
    }

    protected void copyMappingAndSupportFiles(String namespacePrefix, String typeName, String mappingFileName, String ... supportFileNames) throws IOException {
        this.onlineTestId = System.getProperty("testDatabase");
        if (this.onlineTestId != null) {
            this.onlineTestId = this.onlineTestId.toLowerCase().trim();
            try {
                String newContent = this.modifyOnlineMappingFileContent(mappingFileName);
                this.copy(newContent, "featureTypes/" + this.getDataStoreName(namespacePrefix, typeName) + "/" + this.getFileNamePart(mappingFileName));
                for (String propertyFileName : supportFileNames) {
                    if (propertyFileName.endsWith(".xml")) {
                        newContent = this.modifyOnlineMappingFileContent(propertyFileName);
                        this.copy(newContent, "featureTypes/" + this.getDataStoreName(namespacePrefix, typeName) + "/" + this.getFileNamePart(propertyFileName));
                        continue;
                    }
                    this.copyFileToFeatureTypeDir(namespacePrefix, typeName, propertyFileName);
                    if (!propertyFileName.endsWith(".properties")) continue;
                    File file = new File(propertyFileName);
                    if (file.exists()) {
                        propertyFileName = file.getName();
                    }
                    this.propertiesFiles.put(propertyFileName, this.getFeatureTypeDir(this.featureTypesBaseDir, namespacePrefix, typeName));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.copyFileToFeatureTypeDir(namespacePrefix, typeName, mappingFileName);
            for (String propertyFileName : supportFileNames) {
                this.copyFileToFeatureTypeDir(namespacePrefix, typeName, propertyFileName);
            }
        }
    }

    private String modifyOnlineMappingFileContent(String mappingFileName) throws Exception {
        try (InputStream is = this.openResource(mappingFileName);){
            String string;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                StringBuffer content = new StringBuffer();
                boolean parametersStartFound = false;
                boolean parametersEndFound = false;
                boolean isOracle = this.onlineTestId.equals("oracle");
                boolean isPostgis = this.onlineTestId.equals("postgis");
                boolean isGeoPkg = this.onlineTestId.equals("geopkg");
                String line = br.readLine();
                while (line != null) {
                    if (!parametersStartFound || parametersStartFound && parametersEndFound) {
                        if (!parametersStartFound) {
                            if (line.trim().equals("<parameters>")) {
                                parametersStartFound = true;
                                if (isOracle) {
                                    content.append(AppSchemaTestOracleSetup.DB_PARAMS);
                                } else if (isPostgis) {
                                    content.append(AppSchemaTestPostgisSetup.DB_PARAMS);
                                } else if (isGeoPkg) {
                                    this.copy(this.getClass().getClassLoader().getResourceAsStream("appschema/stations.gpkg"), "appschema/stations.gpkg");
                                    File[] stations = Objects.requireNonNull(this.data.listFiles(this.getAppschema()))[0].listFiles(this.getGpkgFile());
                                    File resourceFile = null;
                                    if (stations.length > 0) {
                                        resourceFile = stations[0];
                                    }
                                    this.geopkgDir = resourceFile.toURI().toString();
                                    String DB_PARAMS = AppSchemaTestGeopackageSetup.DB_PARAMS.replace("PATH_TO_BE_REPLACED", this.geopkgDir);
                                    content.append(DB_PARAMS);
                                }
                            } else {
                                content.append(line);
                            }
                        } else if (line.trim().startsWith("<sourceType>")) {
                            line = line.trim();
                            String sourceTypeTag = "<sourceType>";
                            content.append(sourceTypeTag);
                            String tableName = line.substring(line.indexOf(sourceTypeTag) + sourceTypeTag.length(), line.indexOf("</sourceType>"));
                            content.append(tableName.toUpperCase());
                            content.append("</sourceType>");
                            content.append("\n");
                        } else {
                            content.append(line);
                        }
                        content.append("\n");
                    } else if (line.trim().equals("</parameters>")) {
                        parametersEndFound = true;
                    }
                    line = br.readLine();
                }
                string = content.toString();
            }
            return string;
        }
    }

    private FilenameFilter getAppschema() {
        return (dir, name) -> name.startsWith("appschema");
    }

    private FilenameFilter getGpkgFile() {
        return (dir, name) -> name.endsWith("gpkg");
    }
}

