/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.complex;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.complex.ComplexToSimpleOutputCommons;
import org.geoserver.complex.ComplexToSimpleOutputHandler;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.response.ComplexFeatureAwareFormat;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ComplexToSimpleOutputDispatcherCallback
extends AbstractDispatcherCallback {
    private static final Logger LOGGER = Logging.getLogger(ComplexToSimpleOutputDispatcherCallback.class);
    private static final String GET_FEATURE = "GetFeature";
    private static final String WFS = "WFS";
    private final GeoServer geoServer;

    @Autowired
    public ComplexToSimpleOutputDispatcherCallback(@Qualifier(value="geoServer") GeoServer geoServer) {
        this.geoServer = geoServer;
        LOGGER.config("ComplexToSimpleOutputDispatcherCallback instance is activated");
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        try {
            this.logRequest(request, operation, result);
            if (request == null || result == null || !this.isSupported(request, result, operation) || !this.isConvertActivated(request)) {
                return null;
            }
            LOGGER.log(Level.FINE, () -> "Support found for request: " + request);
            Catalog catalog = this.geoServer.getCatalog();
            ComplexToSimpleOutputHandler handler = new ComplexToSimpleOutputHandler(request, (FeatureCollectionResponse)result, catalog);
            return handler.execute();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error executing the dispatcher callback", ex);
            return null;
        }
    }

    private void logRequest(Request request, Operation operation, Object result) {
        LOGGER.log(Level.FINE, () -> "Checking support for request: " + request + " | operation: " + operation + " | result: " + result);
    }

    private boolean isConvertActivated(Request request) {
        WFSInfo wfsInfo = (WFSInfo)this.geoServer.getService(WFSInfo.class);
        if (wfsInfo.isSimpleConversionEnabled()) {
            return true;
        }
        QName layerName = ComplexToSimpleOutputCommons.getLayerName(request);
        if (layerName != null) {
            LayerInfo layerInfo = this.geoServer.getCatalog().getLayerByName((Name)new NameImpl(layerName));
            return layerInfo != null && layerInfo.getResource().isSimpleConversionEnabled();
        }
        return false;
    }

    private boolean isSupported(Request request, Object result, Operation operation) {
        return this.isRequestSupported(request, operation, result) && this.isSupportedResult(result);
    }

    private boolean isSupportedResult(Object result) {
        if (!(result instanceof FeatureCollectionResponse)) {
            return false;
        }
        FeatureCollectionResponse fcResponse = (FeatureCollectionResponse)result;
        List featureCollectionList = fcResponse.getFeature();
        if (featureCollectionList == null || featureCollectionList.size() > 1) {
            return false;
        }
        FeatureCollection featureCollection = (FeatureCollection)featureCollectionList.get(0);
        if (featureCollection == null) {
            return false;
        }
        FeatureType featureType = featureCollection.getSchema();
        return this.isSupported(featureType);
    }

    private boolean isRequestSupported(Request request, Operation operation, Object result) {
        return WFS.equalsIgnoreCase(request.getService()) && GET_FEATURE.equalsIgnoreCase(request.getRequest()) && this.isOutputFormatSupported(request.getOutputFormat(), operation, result);
    }

    private boolean isOutputFormatSupported(String outputFormat, Operation operation, Object result) {
        if (StringUtils.isBlank((CharSequence)outputFormat)) {
            return false;
        }
        return this.isSupported(outputFormat, result, operation);
    }

    private boolean isSupported(FeatureType featureType) {
        return !(featureType instanceof SimpleFeatureType);
    }

    private boolean isSupported(String format, Object value, Operation operation) {
        if (StringUtils.isBlank((CharSequence)format)) {
            return false;
        }
        List formats = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class).stream().filter(of -> !this.supportsComplexFeatures((WFSGetFeatureOutputFormat)of, value, operation)).collect(Collectors.toList());
        for (WFSGetFeatureOutputFormat outputFormat : formats) {
            if (!format.equalsIgnoreCase(outputFormat.getCapabilitiesElementName()) && !format.equalsIgnoreCase(outputFormat.getMimeType(value, operation))) continue;
            return true;
        }
        return false;
    }

    private boolean supportsComplexFeatures(WFSGetFeatureOutputFormat outputFormat, Object value, Operation operation) {
        if (!(outputFormat instanceof ComplexFeatureAwareFormat)) {
            return false;
        }
        return ((ComplexFeatureAwareFormat)outputFormat).supportsComplexFeatures(value, operation);
    }
}

