/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

class FeatureTypeConverter {
    private static final Logger LOGGER = Logging.getLogger(FeatureTypeConverter.class);
    private final FeatureType featureType;
    private final Map<String, String> rules;
    private final SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
    private final NamespaceSupport namespaceSupport;
    private List<AttributeDescriptor> processedDescriptors = new ArrayList<AttributeDescriptor>();

    public FeatureTypeConverter(FeatureType featureType, Map<String, String> rules, NamespaceSupport namespaceSupport) {
        this.featureType = Objects.requireNonNull(featureType);
        this.rules = Objects.requireNonNull(rules);
        this.namespaceSupport = Objects.requireNonNull(namespaceSupport);
    }

    public SimpleFeatureType produceSimpleType() {
        this.builder.setNamespaceURI(this.featureType.getName().getNamespaceURI());
        this.builder.setName(this.convertTypeName(this.featureType));
        this.processAllAttributes();
        SimpleFeatureType simpleFeatureType = this.builder.buildFeatureType();
        LOGGER.info(() -> "Converted simple feature type: " + simpleFeatureType);
        return simpleFeatureType;
    }

    private void processAllAttributes() {
        this.processRules();
        Collection descriptors = this.featureType.getDescriptors();
        for (PropertyDescriptor descriptor : descriptors) {
            this.processDescriptor(descriptor);
        }
    }

    private void processRules() {
        for (Map.Entry<String, String> rule : this.rules.entrySet()) {
            this.processRule(rule);
        }
    }

    private void processRule(Map.Entry<String, String> rule) {
        Optional<AttributeDescriptor> descriptorOpt = this.getDescriptor(rule.getValue());
        if (!descriptorOpt.isPresent()) {
            LOGGER.warning(() -> "Descriptor for attribute: '" + (String)rule.getValue() + "' not found on feature type: " + this.featureType);
            return;
        }
        AttributeDescriptor descriptor = descriptorOpt.get();
        LOGGER.finer(() -> "Descriptor found: " + descriptor);
        this.builder.add(rule.getKey(), descriptor.getType().getBinding());
        this.processedDescriptors.add(descriptor);
    }

    private boolean processDescriptor(PropertyDescriptor descriptor) {
        if (this.processedDescriptors.contains(descriptor)) {
            return false;
        }
        if (descriptor instanceof GeometryDescriptor) {
            this.processGeometryDescriptor((GeometryDescriptor)descriptor);
            return true;
        }
        if (descriptor instanceof AttributeDescriptor) {
            return this.processAttributeDescriptor((AttributeDescriptor)descriptor);
        }
        return false;
    }

    private void processGeometryDescriptor(GeometryDescriptor descriptor) {
        this.builder.add((AttributeDescriptor)descriptor);
    }

    private boolean processAttributeDescriptor(AttributeDescriptor descriptor) {
        if (!this.isSimpleType(descriptor)) {
            return false;
        }
        String name = descriptor.getName().getLocalPart();
        Class binding = descriptor.getType().getSuper().getBinding();
        this.builder.add(name, binding);
        return true;
    }

    private boolean isSimpleType(AttributeDescriptor descriptor) {
        if (this.isBlackListed(descriptor)) {
            return false;
        }
        if (descriptor.getMaxOccurs() > 1) {
            return false;
        }
        AttributeType attributeType = descriptor.getType();
        if (this.isSimple(attributeType)) {
            return true;
        }
        while (attributeType.getSuper() != null) {
            if (!this.isSimple(attributeType = attributeType.getSuper())) continue;
            return true;
        }
        return false;
    }

    private boolean isSimple(AttributeType attributeType) {
        Name name = attributeType.getName();
        return "http://www.w3.org/2001/XMLSchema".equals(name.getNamespaceURI()) && "anySimpleType".equals(name.getLocalPart());
    }

    private boolean isBlackListed(AttributeDescriptor descriptor) {
        if (descriptor.getName().getNamespaceURI() == null) {
            return true;
        }
        return descriptor.getName().getNamespaceURI().startsWith("http://www.opengis.net/gml");
    }

    private String convertTypeName(FeatureType featureType) {
        String typeName = featureType.getName().getLocalPart();
        if (typeName.contains("Type")) {
            return typeName.replace("Type", "SimpleType");
        }
        return typeName + "SimpleType";
    }

    protected Optional<AttributeDescriptor> getDescriptor(String xpath) {
        AttributeExpressionImpl attr = new AttributeExpressionImpl(xpath, this.namespaceSupport);
        return Optional.ofNullable((AttributeDescriptor)attr.evaluate((Object)this.featureType, AttributeDescriptor.class));
    }
}

