/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.complex;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.tuple.Pair;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.complex.ComplexToSimpleFeatureCollection;
import org.geoserver.complex.ComplexToSimpleFeatureCollectionResponse11;
import org.geoserver.complex.ComplexToSimpleFeatureCollectionResponse20;
import org.geoserver.complex.ComplexToSimpleOutputCommons;
import org.geoserver.ows.Request;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

public class ComplexToSimpleOutputHandler {
    private static final Logger LOGGER = Logging.getLogger(ComplexToSimpleOutputHandler.class);
    private final FeatureCollectionResponse result;
    private final Catalog catalog;
    private final QName layerName;

    public ComplexToSimpleOutputHandler(Request request, FeatureCollectionResponse result, Catalog catalog) {
        this.result = Objects.requireNonNull(result);
        this.catalog = Objects.requireNonNull(catalog);
        this.layerName = Objects.requireNonNull(ComplexToSimpleOutputCommons.getLayerName(request));
    }

    public Object execute() {
        LOGGER.fine(() -> "Executing handler for layer name: " + this.layerName);
        Map<String, String> rulesMap = this.getRulesMap();
        ComplexToSimpleFeatureCollection collection = new ComplexToSimpleFeatureCollection(rulesMap, (FeatureCollection<FeatureType, Feature>)((FeatureCollection)this.result.getFeature().get(0)), this.buildNamespaceSupport(this.catalog));
        if (this.result instanceof FeatureCollectionResponse.WFS20) {
            return new ComplexToSimpleFeatureCollectionResponse20(this.result, collection);
        }
        if (this.result instanceof FeatureCollectionResponse.WFS11) {
            return new ComplexToSimpleFeatureCollectionResponse11(this.result, collection);
        }
        return collection;
    }

    private Map<String, String> getRulesMap() {
        NameImpl name = new NameImpl(this.layerName);
        LayerInfo layerInfo = this.catalog.getLayerByName((Name)name);
        MetadataMap metadataMap = layerInfo.getMetadata();
        Map map = (Map)metadataMap.get("ComplexToSimpleRules", Map.class);
        if (map == null) {
            LOGGER.fine(() -> "Rules map not found on layer: " + layerInfo);
            return Collections.emptyMap();
        }
        LOGGER.fine(() -> "Rules map found: " + map);
        return map;
    }

    private NamespaceSupport buildNamespaceSupport(Catalog catalog) {
        List namespaces = catalog.getNamespaces();
        NamespaceSupport nsSupport = new NamespaceSupport();
        for (NamespaceInfo namespaceInfo : namespaces) {
            nsSupport.declarePrefix(namespaceInfo.getPrefix(), namespaceInfo.getURI());
        }
        this.addSupportedNamespaces(nsSupport);
        return nsSupport;
    }

    private void addSupportedNamespaces(NamespaceSupport nsSupport) {
        LayerInfo layerInfo = this.catalog.getLayerByName((Name)new NameImpl(this.layerName));
        FeatureTypeInfo featureTypeInfo = (FeatureTypeInfo)layerInfo.getResource();
        List<Pair<String, String>> supportedNamespaces = this.getSupportedNamespaces(featureTypeInfo);
        for (Pair<String, String> pair : supportedNamespaces) {
            nsSupport.declarePrefix((String)pair.getLeft(), (String)pair.getRight());
        }
    }

    private List<Pair<String, String>> getSupportedNamespaces(FeatureTypeInfo featureTypeInfo) {
        try {
            Object object = featureTypeInfo.getFeatureType().getUserData().get("declaredNamespacesMap");
            if (object instanceof Map) {
                return Collections.emptyList();
            }
            Map nsMap = (Map)object;
            return nsMap.entrySet().stream().map(es -> Pair.of((Object)((String)es.getKey()), (Object)((String)es.getValue()))).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return Collections.emptyList();
        }
    }
}

