/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.elasticsearch;

import org.geoserver.catalog.FeatureTypeCallback;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geotools.data.DataAccess;
import org.geotools.data.elasticsearch.ElasticDataStore;
import org.geotools.data.elasticsearch.ElasticLayerConfiguration;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

class ElasticFeatureTypeCallback
implements FeatureTypeCallback {
    ElasticFeatureTypeCallback() {
    }

    public boolean canHandle(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess) {
        return dataAccess instanceof ElasticDataStore;
    }

    public boolean initialize(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess, Name temporaryName) {
        ElasticLayerConfiguration layerConfig = (ElasticLayerConfiguration)info.getMetadata().get((Object)"ElasticLayerConfiguration");
        if (layerConfig == null) {
            layerConfig = new ElasticLayerConfiguration(info.getName());
        }
        ((ElasticDataStore)dataAccess).setLayerConfiguration(layerConfig);
        return false;
    }

    public void dispose(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess, Name temporaryName) {
        ElasticLayerConfiguration layerConfig = (ElasticLayerConfiguration)info.getMetadata().get((Object)"ElasticLayerConfiguration");
        if (layerConfig != null) {
            layerConfig.getAttributes().stream().filter(attr -> attr.getName().equals(info.getName())).findFirst().ifPresent(attribute -> layerConfig.getAttributes().remove(attribute));
            ((ElasticDataStore)dataAccess).getDocTypes().remove(info.getQualifiedName());
        }
    }

    public void flush(FeatureTypeInfo info, DataAccess<? extends FeatureType, ? extends Feature> dataAccess) {
    }
}

