/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.elasticsearch;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.elasticsearch.ElasticConfigurationPage;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.data.FeatureSource;
import org.geotools.data.elasticsearch.ElasticDataStore;
import org.geotools.data.elasticsearch.ElasticLayerConfiguration;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;

public class ElasticConfigurationPanel
extends ResourceConfigurationPanel {
    private static final long serialVersionUID = 3382530429105288433L;
    private LayerInfo _layerInfo;
    private ElasticLayerConfiguration _layerConfig;

    public ElasticConfigurationPanel(String panelId, IModel<?> model) {
        super(panelId, model);
        FeatureTypeInfo fti = (FeatureTypeInfo)model.getObject();
        final ModalWindow modal = new ModalWindow("modal");
        modal.setInitialWidth(800);
        modal.setTitle((IModel)new ParamResourceModel("modalTitle", (Component)this, new Object[0]));
        if (fti.getMetadata().get((Object)"ElasticLayerConfiguration") == null) {
            modal.add(new Behavior[]{new OpenWindowOnLoadBehavior()});
        }
        modal.setContent((Component)new ElasticConfigurationPage(panelId, model){

            @Override
            void done(AjaxRequestTarget target, LayerInfo layerInfo, ElasticLayerConfiguration layerConfig) {
                MarkupContainer parent;
                ElasticConfigurationPanel.this._layerInfo = layerInfo;
                ElasticConfigurationPanel.this._layerConfig = layerConfig;
                try {
                    ElasticConfigurationPanel.this.saveLayer((FeatureTypeInfo)ElasticConfigurationPanel.this.getResourceInfo());
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    this.error((Serializable)((Object)new ParamResourceModel("creationFailure", (Component)this, new Object[]{e}).getString()));
                }
                for (parent = ElasticConfigurationPanel.this.getParent(); parent != null && !(parent instanceof ResourceConfigurationPage); parent = parent.getParent()) {
                }
                if (parent != null) {
                    ResourceInfo ri = ElasticConfigurationPanel.this.getResourceInfo();
                    ((ResourceConfigurationPage)parent).updateResource(ri, target);
                }
                modal.close((IPartialPageRequestHandler)target);
            }
        });
        this.add(new Component[]{modal});
        AjaxLink findLink = new AjaxLink("edit"){

            public void onClick(AjaxRequestTarget target) {
                modal.show((IPartialPageRequestHandler)target);
            }
        };
        Fragment attributePanel = new Fragment("esPanel", "esPanelFragment", (MarkupContainer)this);
        attributePanel.setOutputMarkupId(true);
        this.add(new Component[]{attributePanel});
        attributePanel.add(new Component[]{findLink});
    }

    private void saveLayer(FeatureTypeInfo ft) throws IOException {
        boolean isNew;
        GeoServerApplication app = (GeoServerApplication)this.getApplication();
        Catalog catalog = app.getCatalog();
        String namespace = ft.getNamespace().getURI();
        NameImpl qualifiedName = new NameImpl(namespace, this._layerInfo.getName());
        LayerInfo layerInfo = catalog.getLayerByName((Name)qualifiedName);
        boolean bl = isNew = ft.getId() == null || app.getCatalog().getResource(ft.getId(), ResourceInfo.class) == null;
        if (layerInfo == null || isNew) {
            DataStoreInfo dsInfo = (DataStoreInfo)catalog.getStore(ft.getStore().getId(), DataStoreInfo.class);
            ElasticDataStore ds = (ElasticDataStore)dsInfo.getDataStore(null);
            CatalogBuilder builder = new CatalogBuilder(catalog);
            builder.setStore((StoreInfo)dsInfo);
            ElasticLayerConfiguration layerConfig = new ElasticLayerConfiguration(this._layerConfig);
            layerConfig.setLayerName(this._layerInfo.getName());
            layerConfig.getAttributes().clear();
            List attributes = this._layerConfig.getAttributes();
            layerConfig.getAttributes().addAll(attributes);
            ds.setLayerConfiguration(layerConfig);
            FeatureTypeInfo _typeInfo = (FeatureTypeInfo)this._layerInfo.getResource();
            FeatureTypeInfo typeInfo = builder.buildFeatureType((FeatureSource)ds.getFeatureSource((Name)qualifiedName));
            typeInfo.setName(this._layerInfo.getName());
            typeInfo.getMetadata().put("ElasticLayerConfiguration", (Serializable)layerConfig);
            typeInfo.setEnabled(_typeInfo.isEnabled());
            typeInfo.setAdvertised(_typeInfo.isAdvertised());
            typeInfo.setTitle(_typeInfo.getTitle());
            typeInfo.setDescription(_typeInfo.getDescription());
            typeInfo.setAbstract(_typeInfo.getAbstract());
            typeInfo.getKeywords().addAll(_typeInfo.getKeywords());
            typeInfo.getMetadataLinks().addAll(_typeInfo.getMetadataLinks());
            typeInfo.getDataLinks().addAll(_typeInfo.getDataLinks());
            typeInfo.setSRS(_typeInfo.getSRS());
            typeInfo.setProjectionPolicy(_typeInfo.getProjectionPolicy());
            typeInfo.setNativeBoundingBox(_typeInfo.getNativeBoundingBox());
            typeInfo.setLatLonBoundingBox(_typeInfo.getLatLonBoundingBox());
            typeInfo.setCircularArcPresent(_typeInfo.isCircularArcPresent());
            typeInfo.setLinearizationTolerance(_typeInfo.getLinearizationTolerance());
            layerInfo = builder.buildLayer(typeInfo);
            builder.updateLayer(layerInfo, this._layerInfo);
            layerInfo.setName(this._layerInfo.getName());
            layerInfo.setResource((ResourceInfo)typeInfo);
        } else {
            FeatureTypeInfo typeInfo = (FeatureTypeInfo)layerInfo.getResource();
            typeInfo.getMetadata().put("ElasticLayerConfiguration", (Serializable)this._layerConfig);
        }
    }

    private class OpenWindowOnLoadBehavior
    extends AbstractDefaultAjaxBehavior {
        private OpenWindowOnLoadBehavior() {
        }

        protected void respond(AjaxRequestTarget target) {
            ModalWindow window = (ModalWindow)this.getComponent();
            window.show((IPartialPageRequestHandler)target);
        }

        public void renderHead(Component component, IHeaderResponse response) {
            response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)this.getCallbackScript().toString()));
        }
    }
}

