/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.elasticsearch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.elasticsearch.ElasticAttributeProvider;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.data.FeatureSource;
import org.geotools.data.elasticsearch.ElasticAttribute;
import org.geotools.data.elasticsearch.ElasticDataStore;
import org.geotools.data.elasticsearch.ElasticLayerConfiguration;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.type.Name;
import org.opengis.util.ProgressListener;

abstract class ElasticConfigurationPage
extends Panel {
    private static final long serialVersionUID = 5615867383881988931L;
    private static final Logger LOGGER = Logging.getLogger(ElasticConfigurationPage.class);
    private final String useAllMarkupId;
    private static final List<Class<? extends Geometry>> GEOMETRY_TYPES = Arrays.asList(Geometry.class, GeometryCollection.class, Point.class, MultiPoint.class, LineString.class, MultiLineString.class, Polygon.class, MultiPolygon.class);

    public ElasticConfigurationPage(String panelId, IModel<?> model) {
        super(panelId, model);
        ResourceInfo ri = (ResourceInfo)model.getObject();
        Form elastic_form = new Form("es_form", (IModel)new CompoundPropertyModel((Object)this));
        this.add(new Component[]{elastic_form});
        List attributes = this.fillElasticAttributes(ri).getAttributes();
        final ElasticAttributeProvider attProvider = new ElasticAttributeProvider(attributes);
        final GeoServerTablePanel<ElasticAttribute> elasticAttributePanel = this.getElasticAttributePanel(attProvider);
        elastic_form.add(new Component[]{elasticAttributePanel});
        boolean selectAll = true;
        for (ElasticAttribute attribute : attributes) {
            if (attribute.isUse() != null && attribute.isUse().booleanValue()) continue;
            selectAll = false;
        }
        AjaxCheckBox useAllCheckBox = new AjaxCheckBox("useAll", (IModel)Model.of((Serializable)Boolean.valueOf(selectAll))){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean use = (Boolean)this.getDefaultModelObject();
                for (ElasticAttribute attribute : attProvider.getItems()) {
                    attribute.setUse(Boolean.valueOf(use));
                }
                target.add(new Component[]{elasticAttributePanel});
            }
        };
        useAllCheckBox.setOutputMarkupId(true);
        elastic_form.add(new Component[]{useAllCheckBox});
        this.useAllMarkupId = useAllCheckBox.getMarkupId();
        elastic_form.add(new Component[]{new AjaxButton("es_save"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ElasticConfigurationPage.this.onSave(target);
            }
        }});
        FeedbackPanel feedbackPanel = new FeedbackPanel("es_feedback");
        feedbackPanel.setOutputMarkupId(true);
        elastic_form.add(new Component[]{feedbackPanel});
    }

    protected void onCancel(AjaxRequestTarget target) {
        this.done(target, null, null);
    }

    private void onSave(AjaxRequestTarget target) {
        try {
            ResourceInfo ri = (ResourceInfo)this.getDefaultModel().getObject();
            ElasticLayerConfiguration layerConfig = this.fillElasticAttributes(ri);
            boolean geomSet = false;
            for (ElasticAttribute att : layerConfig.getAttributes()) {
                if (!Geometry.class.isAssignableFrom(att.getType()) || !att.isUse().booleanValue()) continue;
                geomSet = true;
            }
            if (!geomSet) {
                this.error((Serializable)((Object)new ParamResourceModel("geomEmptyFailure", (Component)this, new Object[0]).getString()));
            }
            Catalog catalog = ((GeoServerApplication)this.getPage().getApplication()).getCatalog();
            DataStoreInfo dsInfo = (DataStoreInfo)catalog.getStore(ri.getStore().getId(), DataStoreInfo.class);
            ElasticDataStore ds = (ElasticDataStore)dsInfo.getDataStore(null);
            CatalogBuilder builder = new CatalogBuilder(catalog);
            builder.setStore((StoreInfo)dsInfo);
            FeatureTypeInfo typeInfo = builder.buildFeatureType((FeatureSource)ds.getFeatureSource(ri.getQualifiedName()));
            typeInfo.setName(ri.getName());
            typeInfo.getMetadata().put("ElasticLayerConfiguration", (Serializable)layerConfig);
            LayerInfo layerInfo = builder.buildLayer(typeInfo);
            layerInfo.setName(ri.getName());
            this.done(target, layerInfo, layerConfig);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            this.error((Serializable)((Object)new ParamResourceModel("creationFailure", (Component)this, new Object[]{e}).getString()));
        }
    }

    private ElasticLayerConfiguration fillElasticAttributes(ResourceInfo ri) {
        ElasticLayerConfiguration layerConfig = (ElasticLayerConfiguration)ri.getMetadata().get((Object)"ElasticLayerConfiguration");
        if (layerConfig == null) {
            layerConfig = new ElasticLayerConfiguration(ri.getName());
            ri.getMetadata().put("ElasticLayerConfiguration", (Serializable)layerConfig);
        }
        try {
            ElasticDataStore dataStore = (ElasticDataStore)((DataStoreInfo)ri.getStore()).getDataStore((ProgressListener)new NullProgressListener());
            ArrayList<ElasticAttribute> result = new ArrayList<ElasticAttribute>();
            HashMap<String, ElasticAttribute> tempMap = new HashMap<String, ElasticAttribute>();
            List attributes = layerConfig.getAttributes();
            for (ElasticAttribute att : attributes) {
                tempMap.put(att.getName(), att);
            }
            String docType = layerConfig.getDocType();
            NameImpl layerName = new NameImpl(layerConfig.getLayerName());
            dataStore.getDocTypes().put(layerName, docType);
            for (ElasticAttribute at : dataStore.getElasticAttributes((Name)layerName)) {
                if (tempMap.containsKey(at.getName())) {
                    at = (ElasticAttribute)tempMap.get(at.getName());
                }
                result.add(at);
            }
            layerConfig.getAttributes().clear();
            layerConfig.getAttributes().addAll(result);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        Collections.sort(layerConfig.getAttributes());
        return layerConfig;
    }

    private GeoServerTablePanel<ElasticAttribute> getElasticAttributePanel(ElasticAttributeProvider attProvider) {
        GeoServerTablePanel<ElasticAttribute> atts = new GeoServerTablePanel<ElasticAttribute>("esAttributes", (GeoServerDataProvider)attProvider){

            protected Component getComponentForProperty(String id, IModel<ElasticAttribute> itemModel, GeoServerDataProvider.Property<ElasticAttribute> property) {
                boolean isGeometry;
                ElasticAttribute att = (ElasticAttribute)itemModel.getObject();
                boolean bl = isGeometry = att.getType() != null && Geometry.class.isAssignableFrom(att.getType());
                if (property == ElasticAttributeProvider.NAME && isGeometry) {
                    Fragment f = new Fragment(id, "label", (MarkupContainer)ElasticConfigurationPage.this);
                    f.add(new Component[]{new Label("label", (Serializable)((Object)(att.getDisplayName() + "*")))});
                    return f;
                }
                if (property == ElasticAttributeProvider.TYPE && isGeometry) {
                    Fragment f = new Fragment(id, "geometry", (MarkupContainer)ElasticConfigurationPage.this);
                    f.add(new Component[]{new DropDownChoice("geometry", (IModel)new PropertyModel(itemModel, "type"), GEOMETRY_TYPES, (IChoiceRenderer)new GeometryTypeRenderer())});
                    return f;
                }
                if (property == ElasticAttributeProvider.USE) {
                    CheckBox checkBox = new CheckBox("use", (IModel)new PropertyModel(itemModel, "use"));
                    String onclick = "document.getElementById(\"" + ElasticConfigurationPage.this.useAllMarkupId + "\").checked = false;";
                    checkBox.add(new Behavior[]{new AttributeAppender("onclick", (IModel)new Model((Serializable)((Object)onclick)), ";")});
                    Fragment f = new Fragment(id, "checkboxUse", (MarkupContainer)ElasticConfigurationPage.this);
                    f.add(new Component[]{checkBox});
                    return f;
                }
                if (property == ElasticAttributeProvider.DEFAULT_GEOMETRY) {
                    if (isGeometry) {
                        Fragment f = new Fragment(id, "checkboxDefaultGeometry", (MarkupContainer)ElasticConfigurationPage.this);
                        f.add(new Component[]{new CheckBox("defaultGeometry", (IModel)new PropertyModel(itemModel, "defaultGeometry"))});
                        return f;
                    }
                    return new Fragment(id, "empty", (MarkupContainer)ElasticConfigurationPage.this);
                }
                if (property == ElasticAttributeProvider.SRID) {
                    if (isGeometry) {
                        Fragment f = new Fragment(id, "label", (MarkupContainer)ElasticConfigurationPage.this);
                        f.add(new Component[]{new Label("label", (Serializable)((Object)String.valueOf(att.getSrid())))});
                        return f;
                    }
                    return new Fragment(id, "empty", (MarkupContainer)ElasticConfigurationPage.this);
                }
                if (property == ElasticAttributeProvider.DATE_FORMAT) {
                    if (att.getDateFormat() != null) {
                        Fragment f = new Fragment(id, "label", (MarkupContainer)ElasticConfigurationPage.this);
                        f.add(new Component[]{new Label("label", (Serializable)((Object)String.valueOf(att.getDateFormat())))});
                        return f;
                    }
                    return new Fragment(id, "empty", (MarkupContainer)ElasticConfigurationPage.this);
                }
                if (property == ElasticAttributeProvider.ANALYZED) {
                    if (att.getAnalyzed() != null && att.getAnalyzed().booleanValue()) {
                        Fragment f = new Fragment(id, "label", (MarkupContainer)ElasticConfigurationPage.this);
                        f.add(new Component[]{new Label("label", (Serializable)((Object)"x"))});
                        return f;
                    }
                    return new Fragment(id, "empty", (MarkupContainer)ElasticConfigurationPage.this);
                }
                if (property == ElasticAttributeProvider.STORED) {
                    if (att.isStored()) {
                        Fragment f = new Fragment(id, "label", (MarkupContainer)ElasticConfigurationPage.this);
                        f.add(new Component[]{new Label("label", (Serializable)((Object)"x"))});
                        return f;
                    }
                    return new Fragment(id, "empty", (MarkupContainer)ElasticConfigurationPage.this);
                }
                if (property == ElasticAttributeProvider.ORDER) {
                    TextField order = new TextField("order", (IModel)new PropertyModel(itemModel, "order"));
                    Fragment f = new Fragment(id, "textOrderValue", (MarkupContainer)ElasticConfigurationPage.this);
                    f.add(new Component[]{order});
                    return f;
                }
                if (property == ElasticAttributeProvider.CUSTOM_NAME) {
                    TextField customName = new TextField("customName", (IModel)new PropertyModel(itemModel, "customName"));
                    Fragment f = new Fragment(id, "textCustomNameValue", (MarkupContainer)ElasticConfigurationPage.this);
                    f.add(new Component[]{customName});
                    return f;
                }
                return null;
            }

            protected void onPopulateItem(GeoServerDataProvider.Property<ElasticAttribute> property, ListItem<GeoServerDataProvider.Property<ElasticAttribute>> item) {
                if (property == ElasticAttributeProvider.STORED) {
                    item.add(new Behavior[]{new AttributeModifier("style", (IModel)Model.of((Serializable)((Object)"text-align:center")))});
                } else if (property == ElasticAttributeProvider.ANALYZED) {
                    item.add(new Behavior[]{new AttributeModifier("style", (IModel)Model.of((Serializable)((Object)"text-align:center")))});
                }
            }
        };
        atts.setOutputMarkupId(true);
        atts.setFilterVisible(false);
        atts.setSortable(false);
        atts.setPageable(false);
        atts.setOutputMarkupId(true);
        return atts;
    }

    abstract void done(AjaxRequestTarget var1, LayerInfo var2, ElasticLayerConfiguration var3);

    private static class GeometryTypeRenderer
    implements IChoiceRenderer<Object> {
        private GeometryTypeRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return ((Class)object).getSimpleName();
        }

        public String getIdValue(Object object, int index) {
            return (String)this.getDisplayValue(object);
        }

        public Object getObject(String id, IModel<? extends List<?>> choices) {
            for (Class c : GEOMETRY_TYPES) {
                if (!id.equals(this.getDisplayValue(c))) continue;
                return c;
            }
            return null;
        }
    }
}

