/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.publish.dggs;

import java.io.IOException;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.data.FeatureSource;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.gstore.DGGSFeatureSource;
import org.geotools.util.decorate.Wrapper;

public class DGGSConfigPanel
extends PublishedConfigurationPanel<LayerInfo> {
    private static final long serialVersionUID = 6469105227923320272L;
    private final TextField<Integer> minResolution;
    private final TextField<Integer> maxResolution;

    public DGGSConfigPanel(String id, IModel<LayerInfo> model) throws IOException {
        super(id, model);
        PropertyModel metadata = new PropertyModel(model, "resource.metadata");
        this.add(new Component[]{DGGSConfigPanel.metadataIntegerEditor("resolutionOffset", (PropertyModel<MetadataMap>)metadata, "dggs.resOffset")});
        DGGSInstance dggs = DGGSConfigPanel.getDGGS(model);
        int[] resolutions = dggs.getResolutions();
        int minDggsRes = Arrays.stream(resolutions).min().orElse(0);
        int maxDggsRes = Arrays.stream(resolutions).max().orElse(Integer.MAX_VALUE);
        this.minResolution = DGGSConfigPanel.metadataIntegerEditor("minResolution", (PropertyModel<MetadataMap>)metadata, "dggs.minResolution");
        this.add(new Component[]{this.minResolution});
        this.minResolution.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(minDggsRes)));
        this.maxResolution = DGGSConfigPanel.metadataIntegerEditor("maxResolution", (PropertyModel<MetadataMap>)metadata, "dggs.maxResolution");
        this.add(new Component[]{this.maxResolution});
        this.maxResolution.add((IValidator)RangeValidator.maximum((Comparable)Integer.valueOf(maxDggsRes)));
    }

    private static TextField<Integer> metadataIntegerEditor(String fieldName, PropertyModel<MetadataMap> metadata, String metadataMapKey) {
        return new TextField(fieldName, (IModel)new MapModel(metadata, metadataMapKey), Integer.class);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.minResolution.getForm().add((IFormValidator)new MinMaxValidator(this.minResolution, this.maxResolution));
    }

    private static DGGSInstance getDGGS(IModel<LayerInfo> model) throws IOException {
        FeatureTypeInfo fti = (FeatureTypeInfo)((LayerInfo)model.getObject()).getResource();
        FeatureSource fs = fti.getFeatureSource(null, null);
        if (fs instanceof Wrapper) {
            fs = (FeatureSource)((Wrapper)fs).unwrap(DGGSFeatureSource.class);
        }
        return ((DGGSFeatureSource)fs).getDGGS();
    }

    public class MinMaxValidator
    implements IFormValidator {
        private final TextField<Integer> minField;
        private final TextField<Integer> maxField;

        public MinMaxValidator(TextField<Integer> minField, TextField<Integer> maxField) {
            this.minField = minField;
            this.maxField = maxField;
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return new FormComponent[]{this.minField, this.maxField};
        }

        public void validate(Form<?> form) {
            Integer minValue = (Integer)this.minField.getConvertedInput();
            Integer maxValue = (Integer)this.maxField.getConvertedInput();
            if (minValue != null && maxValue != null && minValue > maxValue) {
                ValidationError error = new ValidationError();
                error.setMessage((String)new ParamResourceModel("minMaxError", (Component)DGGSConfigPanel.this, new Object[0]).getObject());
                this.minField.error((IValidationError)error);
            }
        }
    }
}

