/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.oauth2;

import java.util.logging.Logger;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.oauth2.GeoNodeOAuth2FilterConfig;
import org.geoserver.security.oauth2.GeoServerOAuthAuthenticationFilter;
import org.geoserver.security.oauth2.OAuth2FilterConfig;
import org.geoserver.security.oauth2.OAuth2FilterConfigException;
import org.geoserver.security.oauth2.OAuth2FilterConfigValidator;
import org.geoserver.security.validation.FilterConfigException;
import org.geoserver.test.GeoServerMockTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuth2FilterConfigValidatorTest
extends GeoServerMockTestSupport {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    OAuth2FilterConfigValidator validator;

    @Before
    public void setValidator() {
        this.validator = new OAuth2FilterConfigValidator(this.getSecurityManager());
    }

    @Test
    public void testOAuth2FilterConfigValidation() throws Exception {
        GeoNodeOAuth2FilterConfig config = new GeoNodeOAuth2FilterConfig();
        config.setClassName(GeoServerOAuthAuthenticationFilter.class.getName());
        config.setName("testOAuth2");
        this.check(config);
        this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
    }

    public void check(GeoNodeOAuth2FilterConfig config) throws Exception {
        boolean failed = false;
        try {
            this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"OAUTH2_CLIENT_ID_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService);
        failed = false;
        try {
            this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"OAUTH2_CLIENT_ID_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setUserGroupServiceName("blabla");
        failed = false;
        try {
            this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"OAUTH2_CLIENT_ID_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setRoleConverterName(null);
        config.setCheckTokenEndpointUrl(null);
        failed = false;
        try {
            this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
        }
        catch (OAuth2FilterConfigException ex) {
            Assert.assertEquals((Object)"OAUTH2_CHECKTOKENENDPOINT_URL_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setCheckTokenEndpointUrl("http://localhost/callback");
        config.setAccessTokenUri("blabal");
        failed = false;
        try {
            this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
        }
        catch (OAuth2FilterConfigException ex) {
            Assert.assertEquals((Object)"OAUTH2_ACCESSTOKENURI_MALFORMED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setAccessTokenUri("http://localhost/callback");
        failed = false;
        try {
            this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
        }
        catch (OAuth2FilterConfigException ex) {
            Assert.assertEquals((Object)"OAUTH2_CLIENT_ID_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setAccessTokenUri("https://localhost/callback");
        config.setUserAuthorizationUri("blabal");
        failed = false;
        try {
            this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
        }
        catch (OAuth2FilterConfigException ex) {
            Assert.assertEquals((Object)"OAUTH2_USERAUTHURI_MALFORMED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setUserAuthorizationUri("https://oauth2server/case");
        config.setLogoutUri("blbla");
        failed = false;
        try {
            this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
        }
        catch (OAuth2FilterConfigException ex) {
            Assert.assertEquals((Object)"OAUTH2_URL_IN_LOGOUT_URI_MALFORMED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setLogoutUri("http://localhost/gesoerver");
        config.setCliendId("oauth2clientid");
        config.setClientSecret("oauth2clientsecret");
        config.setScopes("email,profile");
        this.validator.validateOAuth2FilterConfig((OAuth2FilterConfig)config);
    }
}

