/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.oauth2;

import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.oauth2.GeoNodeOAuth2FilterConfig;
import org.geoserver.security.oauth2.GeoNodeOAuthAuthenticationFilter;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class GeoNodeLoginButtonTest
extends GeoServerWicketTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerSecurityManager manager = this.getSecurityManager();
        GeoNodeOAuth2FilterConfig filterConfig = new GeoNodeOAuth2FilterConfig();
        filterConfig.setName("geonode");
        filterConfig.setClassName(GeoNodeOAuthAuthenticationFilter.class.getName());
        filterConfig.setCliendId("foo");
        filterConfig.setClientSecret("bar");
        manager.saveFilter((SecurityNamedServiceConfig)filterConfig);
        SecurityManagerConfig config = manager.getSecurityConfig();
        GeoServerSecurityFilterChain chain = config.getFilterChain();
        RequestFilterChain www = chain.getRequestChainByName("web");
        www.setFilterNames(new String[]{"geonode", "anonymous"});
        manager.saveSecurityConfig(config);
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Test
    public void testLoginButton() {
        tester.startPage(GeoServerHomePage.class);
        String html = tester.getLastResponseAsString();
        LOGGER.info("Last page HTML:\n" + html);
        Assert.assertTrue((boolean)html.contains("<form style=\"display: inline-block;\" method=\"post\" action=\"../web/j_spring_oauth2_geonode_login\">"));
        Assert.assertTrue((boolean)html.contains("<img src=\"./wicket/resource/org.geoserver.web.security.oauth2.GeoNodeOAuth2AuthProviderPanel/geonode"));
    }
}

