/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.oauth2;

import org.geoserver.config.util.XStreamPersister;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.oauth2.GeoNodeOAuth2FilterConfig;
import org.geoserver.security.oauth2.GeoNodeOAuthAuthenticationFilter;
import org.geoserver.security.oauth2.GeoServerOAuthAuthenticationProvider;
import org.springframework.security.oauth2.client.OAuth2RestOperations;

public class GeoNodeOAuth2AuthenticationProvider
extends GeoServerOAuthAuthenticationProvider {
    public GeoNodeOAuth2AuthenticationProvider(GeoServerSecurityManager securityManager, String tokenServices, String oauth2SecurityConfiguration, String geoServerOauth2RestTemplate) {
        super(securityManager, tokenServices, oauth2SecurityConfiguration, geoServerOauth2RestTemplate);
    }

    public void configure(XStreamPersister xp) {
        xp.getXStream().alias("geoNodeOauth2Authentication", GeoNodeOAuth2FilterConfig.class);
    }

    public Class<? extends GeoServerSecurityFilter> getFilterClass() {
        return GeoNodeOAuthAuthenticationFilter.class;
    }

    public GeoServerSecurityFilter createFilter(SecurityNamedServiceConfig config) {
        return new GeoNodeOAuthAuthenticationFilter(config, this.tokenServices, this.oauth2SecurityConfiguration, (OAuth2RestOperations)this.geoServerOauth2RestTemplate);
    }
}

