/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.oauth2;

import java.util.Arrays;
import java.util.HashMap;
import org.geoserver.ows.URLMangler;
import org.geoserver.security.oauth2.AbstractOAuth2RestTemplateTest;
import org.geoserver.security.oauth2.GeoNodeOAuth2SecurityConfiguration;
import org.geoserver.security.oauth2.OAuth2AccessTokenURLMangler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RequestAuthenticator;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class OAuth2RestTemplateTest
extends AbstractOAuth2RestTemplateTest {
    public void open() throws Exception {
        this.configuration = new GeoNodeOAuth2SecurityConfiguration();
        this.configuration.setAccessTokenRequest(this.accessTokenRequest);
        this.resource = (AuthorizationCodeResourceDetails)this.configuration.geoServerOAuth2Resource();
        Assert.assertNotNull((Object)this.resource);
        this.resource.setTokenName("bearer_token");
        this.restTemplate = this.configuration.geoServerOauth2RestTemplate();
        Assert.assertNotNull((Object)this.restTemplate);
        this.request = (ClientHttpRequest)Mockito.mock(ClientHttpRequest.class);
        this.headers = new HttpHeaders();
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)this.headers);
        ClientHttpResponse response = (ClientHttpResponse)Mockito.mock(ClientHttpResponse.class);
        HttpStatus statusCode = HttpStatus.OK;
        Mockito.when((Object)response.getStatusCode()).thenReturn((Object)statusCode);
        Mockito.when((Object)this.request.execute()).thenReturn((Object)response);
    }

    @Test(expected=AccessTokenRequiredException.class)
    public void testAccessDeneiedException() throws Exception {
        DefaultOAuth2AccessToken token = new DefaultOAuth2AccessToken("12345");
        token.setTokenType("access_token");
        this.authenticator.authenticate((OAuth2ProtectedResourceDetails)this.resource, this.restTemplate.getOAuth2ClientContext(), this.request);
    }

    @Test
    public void testNonBearerToken() throws Exception {
        DefaultOAuth2AccessToken token = new DefaultOAuth2AccessToken("12345");
        token.setTokenType("access_token");
        this.restTemplate.getOAuth2ClientContext().setAccessToken((OAuth2AccessToken)token);
        this.authenticator.authenticate((OAuth2ProtectedResourceDetails)this.resource, this.restTemplate.getOAuth2ClientContext(), this.request);
        String auth = this.request.getHeaders().getFirst("Authorization");
        Assert.assertTrue((boolean)auth.startsWith("access_token "));
    }

    @Test
    public void testCustomAuthenticator() throws Exception {
        DefaultOAuth2AccessToken token = new DefaultOAuth2AccessToken("12345");
        token.setTokenType("access_token");
        this.restTemplate.getOAuth2ClientContext().setAccessToken((OAuth2AccessToken)token);
        OAuth2RequestAuthenticator customAuthenticator = new OAuth2RequestAuthenticator(){

            public void authenticate(OAuth2ProtectedResourceDetails resource, OAuth2ClientContext clientContext, ClientHttpRequest req) {
                req.getHeaders().set("X-Authorization", clientContext.getAccessToken().getTokenType() + " Nah-nah-na-nah-nah");
            }
        };
        customAuthenticator.authenticate((OAuth2ProtectedResourceDetails)this.resource, this.restTemplate.getOAuth2ClientContext(), this.request);
        String auth = this.request.getHeaders().getFirst("X-Authorization");
        Assert.assertEquals((Object)"access_token Nah-nah-na-nah-nah", (Object)auth);
    }

    @Test
    public void testBearerAccessTokenURLMangler() {
        DefaultOAuth2AccessToken token = new DefaultOAuth2AccessToken("12345");
        token.setTokenType("access_token");
        token.setTokenType("Bearer");
        this.restTemplate.getOAuth2ClientContext().setAccessToken((OAuth2AccessToken)token);
        this.authenticator.authenticate((OAuth2ProtectedResourceDetails)this.resource, this.restTemplate.getOAuth2ClientContext(), this.request);
        String auth = this.request.getHeaders().getFirst("Authorization");
        Assert.assertTrue((boolean)auth.startsWith("Bearer"));
        OAuth2AccessTokenURLMangler urlMangler = new OAuth2AccessTokenURLMangler(this.getSecurityManager(), this.configuration, this.restTemplate);
        urlMangler.geoServerOauth2RestTemplate = this.restTemplate;
        Assert.assertNotNull((Object)urlMangler);
        UsernamePasswordAuthenticationToken user = new UsernamePasswordAuthenticationToken((Object)"admin", (Object)"geoserver", Arrays.asList(new SimpleGrantedAuthority("ROLE_ADMINISTRATOR")));
        SecurityContextHolder.getContext().setAuthentication((Authentication)user);
        StringBuilder baseURL = new StringBuilder("http://test.geoserver-org/wms");
        StringBuilder path = new StringBuilder();
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("request", "GetCapabilities");
        urlMangler.mangleURL(baseURL, path, kvp, URLMangler.URLType.SERVICE);
        Assert.assertTrue((boolean)kvp.containsKey("access_token"));
        Assert.assertTrue((boolean)"12345".equals(kvp.get("access_token")));
    }
}

