/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.type;

import java.util.Collection;
import java.util.List;
import org.geoserver.schemalessfeatures.type.DynamicComplexTypeImpl;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.InternationalString;

public class DynamicFeatureType
extends DynamicComplexTypeImpl
implements FeatureType {
    private GeometryDescriptor defaultGeometry;
    private CoordinateReferenceSystem crs;

    public DynamicFeatureType(Name name, Collection<PropertyDescriptor> schema, GeometryDescriptor defaultGeometry, boolean isAbstract, List<Filter> restrictions, AttributeType superType, InternationalString description) {
        super(name, schema, true, isAbstract, restrictions, superType, description);
        this.defaultGeometry = defaultGeometry;
        if (defaultGeometry != null && !(defaultGeometry.getType() instanceof GeometryType)) {
            throw new IllegalArgumentException("defaultGeometry must have a GeometryType");
        }
    }

    public GeometryDescriptor getGeometryDescriptor() {
        return this.defaultGeometry;
    }

    public void setGeometryDescriptor(GeometryDescriptor geometryDescriptor) {
        this.defaultGeometry = geometryDescriptor;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.crs == null) {
            if (this.getGeometryDescriptor() != null && this.getGeometryDescriptor().getType().getCoordinateReferenceSystem() != null) {
                this.crs = this.defaultGeometry.getType().getCoordinateReferenceSystem();
            }
            if (this.crs == null) {
                for (PropertyDescriptor property : this.getDescriptors()) {
                    GeometryDescriptor geometry;
                    if (!(property instanceof GeometryDescriptor) || (geometry = (GeometryDescriptor)property).getType().getCoordinateReferenceSystem() == null) continue;
                    this.crs = geometry.getType().getCoordinateReferenceSystem();
                    break;
                }
            }
        }
        return this.crs;
    }
}

