/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geoserver.schemalessfeatures.type.DynamicComplexType;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.ComplexType;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.ComplexTypeImpl;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.util.factory.Hints;

public class SchemalessPropertyAccessorFactory
implements PropertyAccessorFactory {
    public static final String NESTED_FEATURE_SUFFIX = "Feature";
    public static final ComplexType ANYTYPE_TYPE = new ComplexTypeImpl((Name)new NameImpl("http://www.w3.org/2001/XMLSchema", "anyType"), null, false, true, Collections.emptyList(), null, null);

    public PropertyAccessor createPropertyAccessor(Class type, String propertyPath, Class target, Hints hints) {
        if (propertyPath == null) {
            return null;
        }
        if (!(ComplexAttribute.class.isAssignableFrom(type) || DynamicComplexType.class.isAssignableFrom(type) || AttributeDescriptor.class.isAssignableFrom(type))) {
            return null;
        }
        return new SchemalessFeaturePropertyAccessor();
    }

    static class SchemalessFeaturePropertyAccessor
    implements PropertyAccessor {
        SchemalessFeaturePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            AttributeType type = null;
            if (object instanceof Attribute) {
                type = ((Attribute)object).getType();
            } else if (object instanceof AttributeType) {
                type = (AttributeType)object;
            } else if (object instanceof AttributeDescriptor) {
                type = ((AttributeDescriptor)object).getType();
            }
            return type != null && type instanceof DynamicComplexType;
        }

        public <T> T get(Object object, String xpath, Class<T> target) throws IllegalArgumentException {
            if (object instanceof ComplexAttribute) {
                String[] pathParts = xpath.indexOf(47) != -1 ? xpath.split("/") : xpath.split("\\.");
                return (T)this.walkComplexAttribute((ComplexAttribute)object, pathParts);
            }
            if (object instanceof DynamicComplexType) {
                return (T)ANYTYPE_TYPE;
            }
            if (object instanceof AttributeDescriptor) {
                return (T)new AttributeDescriptorImpl((AttributeType)ANYTYPE_TYPE, (Name)new NameImpl(null, "anyType"), 0, Integer.MAX_VALUE, true, null);
            }
            throw new IllegalArgumentException("Cannot handle the object");
        }

        private Object walkComplexAttribute(ComplexAttribute complexAttribute, String[] path) {
            List<Object> result = null;
            for (int i = 0; i < path.length; ++i) {
                String pathPart = path[i];
                result = this.walkComplexAttribute(complexAttribute, pathPart);
                if (result instanceof ComplexAttribute) {
                    complexAttribute = (ComplexAttribute)result;
                    continue;
                }
                if (result instanceof List) {
                    List attributes = (List)List.class.cast(result);
                    List<Object> results = this.walkList(attributes, path, i);
                    if (results.size() == 1) {
                        result = results.get(0);
                        break;
                    }
                    if (results.isEmpty()) {
                        result = null;
                        break;
                    }
                    result = results;
                    break;
                }
                if (result == null) break;
            }
            return result;
        }

        private Object walkComplexAttribute(ComplexAttribute complexAttribute, String pathPart) {
            if (complexAttribute == null) {
                return null;
            }
            Collection properties = complexAttribute.getProperties(pathPart);
            if (properties == null || properties.isEmpty()) {
                return null;
            }
            Object value = properties.size() == 1 ? this.extractValue((Property)properties.iterator().next(), pathPart) : this.extractValues(properties, pathPart);
            return value;
        }

        private List<Object> walkList(List<Object> attributes, String[] path, int currentIndex) {
            boolean lastPathPart;
            boolean bl = lastPathPart = currentIndex + 1 == path.length;
            if (lastPathPart) {
                return attributes;
            }
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object value : attributes) {
                List values;
                if (value == null) continue;
                if (!(value instanceof ComplexAttribute)) {
                    if (value instanceof List) {
                        values = (List)List.class.cast(value);
                        results.addAll(values);
                        continue;
                    }
                    results.add(value);
                    continue;
                }
                if ((value = this.walkComplexAttribute((ComplexAttribute)value, Arrays.copyOfRange(path, currentIndex + 1, path.length))) == null) continue;
                if (value instanceof List) {
                    values = (List)List.class.cast(value);
                    results.addAll(values);
                    continue;
                }
                results.add(value);
            }
            return results;
        }

        private Object extractValue(Property property, String pathPart) {
            Object value;
            if (property instanceof ComplexAttribute) {
                ComplexAttribute complexProp = (ComplexAttribute)property;
                String featurePath = pathPart.substring(0, 1).toUpperCase() + pathPart.substring(1) + SchemalessPropertyAccessorFactory.NESTED_FEATURE_SUFFIX;
                value = complexProp.getProperty(featurePath);
            } else {
                value = property.getValue();
            }
            return value;
        }

        private List<Object> extractValues(Collection<Property> properties, String pathPart) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Property property : properties) {
                values.add(this.extractValue(property, pathPart));
            }
            return values;
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalAttributeException {
            throw new UnsupportedOperationException("Set is not supported");
        }
    }
}

