/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.schemalessfeatures;

import org.geoserver.schemalessfeatures.builders.DynamicComplexTypeBuilder;
import org.geoserver.schemalessfeatures.type.DynamicComplexType;
import org.geoserver.schemalessfeatures.type.DynamicFeatureType;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.gml3.v3_2.GMLSchema;

public abstract class SchemalessFeatureMapper<T> {
    public static final String TYPE_SUFFIX = "Type";
    public static final String PROPERTY_TYPE_SUFFIX = "PropertyType";
    protected AttributeBuilder attributeBuilder;
    protected DynamicComplexTypeBuilder typeBuilder;

    public SchemalessFeatureMapper(AttributeBuilder attributeBuilder, DynamicComplexTypeBuilder typeBuilder) {
        this.attributeBuilder = attributeBuilder;
        this.typeBuilder = typeBuilder;
    }

    public abstract Feature buildFeature(T var1);

    protected PropertyDescriptor buildFullyObjectPropertyModelDescriptor(DynamicComplexType parentType, String namespaceURI, String attrName, boolean isCollection) {
        this.typeBuilder.nillable(true).namespaceURI(namespaceURI).name(this.capitalizeName(attrName) + PROPERTY_TYPE_SUFFIX).superType((AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE);
        DynamicComplexType complexPropertyType = this.typeBuilder.buildComplexType();
        AttributeDescriptor descriptorProperty = this.typeBuilder.buildDescriptor(attrName, (AttributeType)complexPropertyType, isCollection);
        parentType.addPropertyDescriptor((PropertyDescriptor)descriptorProperty);
        this.typeBuilder.nillable(true).namespaceURI(namespaceURI).name(this.capitalizeName(attrName) + TYPE_SUFFIX).superType((AttributeType)GMLSchema.ABSTRACTGMLTYPE_TYPE);
        DynamicFeatureType nestedFeatureType = this.typeBuilder.buildNestedFeatureType();
        AttributeDescriptor nestedFeatureDescriptor = this.typeBuilder.buildDescriptor(this.capitalizeNameFeature(attrName), (AttributeType)nestedFeatureType, isCollection);
        complexPropertyType.addPropertyDescriptor((PropertyDescriptor)nestedFeatureDescriptor);
        return descriptorProperty;
    }

    private String capitalizeName(String typeName) {
        return typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
    }

    private String capitalizeNameFeature(String typeName) {
        return this.capitalizeName(typeName) + "Feature";
    }

    protected Attribute buildSimpleAttribute(String namespaceURI, String attrName, Object value, DynamicComplexType parentType, boolean isCollection) {
        boolean shouldRemove;
        NameImpl name = new NameImpl(namespaceURI, attrName);
        PropertyDescriptor attrDescriptor = parentType.getDescriptor((Name)name);
        boolean bl = shouldRemove = attrDescriptor != null && attrDescriptor.getType().getBinding().equals(Object.class);
        if (shouldRemove) {
            parentType.removePropertyDescriptor(attrDescriptor);
        }
        if (attrDescriptor == null || shouldRemove) {
            this.typeBuilder.binding(value.getClass()).name(attrName).namespaceURI(namespaceURI).maxOccurs(isCollection ? Integer.MAX_VALUE : 1).minOccurs(0);
            AttributeType attrType = this.typeBuilder.buildType();
            attrDescriptor = this.typeBuilder.buildDescriptor(attrType.getName(), attrType);
            if (parentType instanceof DynamicComplexType) {
                parentType.addPropertyDescriptor(attrDescriptor);
            }
        }
        this.attributeBuilder.setDescriptor((AttributeDescriptor)attrDescriptor);
        return this.attributeBuilder.buildSimple(null, value);
    }

    protected Attribute buildSimpleAttribute(String namespaceURI, String attrName, Object value, DynamicComplexType parentType) {
        return this.buildSimpleAttribute(namespaceURI, attrName, value, parentType, false);
    }

    protected Attribute buildNullAttribute(String namespaceURI, String attrName, DynamicComplexType parentType) {
        this.typeBuilder.binding(Object.class).name(attrName).namespaceURI(namespaceURI).maxOccurs(1).minOccurs(0).nillable(true);
        AttributeType attrType = this.typeBuilder.buildType();
        AttributeDescriptor attrDescriptor = this.typeBuilder.buildDescriptor(attrType.getName(), attrType);
        if (parentType instanceof DynamicComplexType) {
            parentType.addPropertyDescriptor((PropertyDescriptor)attrDescriptor);
        }
        this.attributeBuilder.setDescriptor(attrDescriptor);
        return this.attributeBuilder.buildSimple(null, null);
    }
}

